/*
 * Decompiled with CFR 0.152.
 */
package octree;

import octree.AppearanceCreator;
import octree.CubeData;
import octree.GeometryCreator;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;

public class ShapeGroup
implements Comparable {
    float pos;
    Shape3D shape;
    BranchGroup group = new BranchGroup();
    BranchGroup child;
    int indexInParent;

    public ShapeGroup() {
        this.group.setCapability(13);
        this.group.setCapability(14);
        this.child = new BranchGroup();
        this.child.setCapability(17);
    }

    public void prepareForAxis(float pos) {
        this.pos = pos;
    }

    public void show(CubeData cdata, int index) {
        this.shape = new Shape3D((Geometry)ShapeGroup.createGeometry(cdata, index), ShapeGroup.createAppearance(cdata, index));
        this.child.addChild((Node)this.shape);
        this.group.addChild((Node)this.child);
    }

    public void hide() {
        this.child.detach();
        this.child.removeAllChildren();
        this.shape = null;
    }

    private static GeometryArray createGeometry(CubeData cdata, int index) {
        GeometryArray arr = GeometryCreator.instance().getQuad(cdata, index);
        return arr;
    }

    private static Appearance createAppearance(CubeData cdata, int index) {
        return AppearanceCreator.instance().getAppearance(cdata, index);
    }

    public int compareTo(Object o) {
        ShapeGroup sg = (ShapeGroup)o;
        if (this.pos < sg.pos) {
            return -1;
        }
        if (this.pos > sg.pos) {
            return 1;
        }
        return 0;
    }

    public ShapeGroup duplicate() {
        ShapeGroup ret = new ShapeGroup();
        if (this.shape != null) {
            ret.shape = new Shape3D(this.shape.getGeometry(), this.shape.getAppearance());
            ret.group.addChild((Node)ret.shape);
        }
        ret.pos = this.pos;
        return ret;
    }
}

