/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import octree.CubeData;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.QuadArray;

public class GeometryCreator
implements AxisConstants {
    private final float[] quadCoords = new float[12];
    private static GeometryCreator instance;

    private GeometryCreator() {
    }

    public static GeometryCreator instance() {
        if (instance == null) {
            instance = new GeometryCreator();
        }
        return instance;
    }

    public GeometryArray getQuad(CubeData cdata, int index) {
        this.calculateQuad(cdata, index);
        QuadArray quadArray = new QuadArray(4, 1);
        quadArray.setCoordinates(0, this.quadCoords);
        return quadArray;
    }

    public float[] getQuadCoordinates(CubeData cdata, int index) {
        this.calculateQuad(cdata, index);
        return this.quadCoords;
    }

    private void calculateQuad(CubeData cdata, int index) {
        switch (cdata.axis) {
            case 0: {
                this.setCoordsY(cdata);
                this.setCoordsZ(cdata);
                this.setCurCoordX(index, cdata);
                break;
            }
            case 1: {
                this.setCoordsX(cdata);
                this.setCoordsZ(cdata);
                this.setCurCoordY(index, cdata);
                break;
            }
            case 2: {
                this.setCoordsX(cdata);
                this.setCoordsY(cdata);
                this.setCurCoordZ(index, cdata);
            }
        }
    }

    private void setCurCoordX(int i, CubeData cdata) {
        float curX;
        this.quadCoords[0] = curX = (float)i * cdata.cal[0] + cdata.min[0];
        this.quadCoords[3] = curX;
        this.quadCoords[6] = curX;
        this.quadCoords[9] = curX;
    }

    private void setCurCoordY(int i, CubeData cdata) {
        float curY;
        this.quadCoords[1] = curY = (float)i * cdata.cal[1] + cdata.min[1];
        this.quadCoords[4] = curY;
        this.quadCoords[7] = curY;
        this.quadCoords[10] = curY;
    }

    private void setCurCoordZ(int i, CubeData cdata) {
        float curZ;
        this.quadCoords[2] = curZ = (float)i * cdata.cal[2] + cdata.min[2];
        this.quadCoords[5] = curZ;
        this.quadCoords[8] = curZ;
        this.quadCoords[11] = curZ;
    }

    private void setCoordsX(CubeData cdata) {
        this.quadCoords[1] = cdata.min[1];
        this.quadCoords[2] = cdata.min[2];
        this.quadCoords[4] = cdata.max[1];
        this.quadCoords[5] = cdata.min[2];
        this.quadCoords[7] = cdata.max[1];
        this.quadCoords[8] = cdata.max[2];
        this.quadCoords[10] = cdata.min[1];
        this.quadCoords[11] = cdata.max[2];
    }

    private void setCoordsY(CubeData cdata) {
        this.quadCoords[0] = cdata.min[0];
        this.quadCoords[2] = cdata.min[2];
        this.quadCoords[3] = cdata.min[0];
        this.quadCoords[5] = cdata.max[2];
        this.quadCoords[6] = cdata.max[0];
        this.quadCoords[8] = cdata.max[2];
        this.quadCoords[9] = cdata.max[0];
        this.quadCoords[11] = cdata.min[2];
    }

    private void setCoordsZ(CubeData cdata) {
        this.quadCoords[0] = cdata.min[0];
        this.quadCoords[1] = cdata.min[1];
        this.quadCoords[3] = cdata.max[0];
        this.quadCoords[4] = cdata.min[1];
        this.quadCoords[6] = cdata.max[0];
        this.quadCoords[7] = cdata.max[1];
        this.quadCoords[9] = cdata.min[0];
        this.quadCoords[10] = cdata.max[1];
    }
}

