/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import org.scijava.java3d.Appearance;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.LineArray;
import org.scijava.java3d.Node;
import org.scijava.java3d.OrientedShape3D;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.geometry.Text2D;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3f;

public class CoordinateSystem
extends BranchGroup {
    private final float length;
    private final Color3f color;

    public CoordinateSystem(float length, Color3f color) {
        this.length = length;
        this.color = color;
        this.setCapability(17);
        Shape3D lines = new Shape3D();
        lines.setGeometry(this.createGeometry());
        this.addChild((Node)lines);
        Appearance textAppear = new Appearance();
        ColoringAttributes textColor = new ColoringAttributes();
        textColor.setColor(color);
        textAppear.setColoringAttributes(textColor);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        pa.setBackFaceNormalFlip(true);
        textAppear.setPolygonAttributes(pa);
        try {
            Transform3D translate = new Transform3D();
            translate.setTranslation(new Vector3f(length, -length / 8.0f, 0.0f));
            this.addText("x", translate, textAppear);
            translate.setTranslation(new Vector3f(-length / 8.0f, length, 0.0f));
            this.addText("y", translate, textAppear);
            translate.setTranslation(new Vector3f(-length / 8.0f, -length / 8.0f, length));
            this.addText("z", translate, textAppear);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addText(String s, Transform3D translate, Appearance textAppear) {
        TransformGroup tg = new TransformGroup(translate);
        this.addChild((Node)tg);
        OrientedShape3D textShape = new OrientedShape3D();
        textShape.setAlignmentMode(1);
        textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        textShape.setRotationPoint(new Point3f(0.0f, 0.0f, 0.0f));
        textShape.setConstantScaleEnable(true);
        Text2D t2d = new Text2D(s, this.color, "Helvetica", 24, 0);
        t2d.setRectangleScaleFactor(0.03f);
        textShape.setGeometry(t2d.getGeometry());
        textShape.setAppearance(t2d.getAppearance());
        tg.addChild((Node)textShape);
    }

    public Geometry createGeometry() {
        Point3f origin = new Point3f();
        Point3f onX = new Point3f(this.length, 0.0f, 0.0f);
        Point3f onY = new Point3f(0.0f, this.length, 0.0f);
        Point3f onZ = new Point3f(0.0f, 0.0f, this.length);
        Point3f[] coords = new Point3f[]{origin, onX, origin, onY, origin, onZ};
        int N = coords.length;
        Color3f[] colors = new Color3f[N];
        for (int i = 0; i < N; ++i) {
            colors[i] = this.color;
        }
        LineArray ta = new LineArray(N, 5);
        ta.setCoordinates(0, coords);
        ta.setColors(0, colors);
        return ta;
    }
}

