/*
 * Decompiled with CFR 0.152.
 */
package ij3d.gui;

import customnode.Box;
import customnode.Cone;
import customnode.Primitive;
import customnode.Sphere;
import customnode.Tube;
import ij.gui.GenericDialog;
import ij3d.Content;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.vecmath.Point3f;

public class PrimitiveDialogs {
    private static final String ws = "\\s*";
    private static final String no = "(\\S*?)";
    private static final Pattern tuplePattern = Pattern.compile("\\(?(\\S*?),\\s*(\\S*?),\\s*(\\S*?)\\)?");

    public static void addBox(Image3DUniverse univ) {
        new BoxDialog(univ);
    }

    public static void addSphere(Image3DUniverse univ) {
        new SphereDialog(univ);
    }

    public static void addCone(Image3DUniverse univ) {
        new ConeDialog(univ);
    }

    public static void addTube(Image3DUniverse univ) {
        new TubeDialog(univ);
    }

    public static Point3f parsePoint(String s) {
        Point3f tuple = new Point3f();
        s = s.trim();
        try {
            Matcher m = tuplePattern.matcher(s);
            m.matches();
            tuple.x = Float.parseFloat(m.group(1));
            tuple.y = Float.parseFloat(m.group(2));
            tuple.z = Float.parseFloat(m.group(3));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse " + s);
        }
        return tuple;
    }

    private static final class TubeDialog
    extends PrimitiveDialog {
        private final TextField tf0;
        private final TextField tf1;
        private final List<TextField> tfs = new ArrayList<TextField>();

        public TubeDialog(Image3DUniverse univ) {
            super("Tube", univ);
            this.addStringField("Name", "");
            this.tf0 = (TextField)this.getStringFields().get(0);
            this.addNumericField("Radius", 0.0, 5);
            this.tf1 = (TextField)this.getNumericFields().get(0);
            final Panel p = new Panel(new GridBagLayout());
            final GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            p.add((Component)new Label("Point1"), c);
            ++c.gridx;
            TextField tf = new TextField(10);
            this.tfs.add(tf);
            tf.addFocusListener(this);
            p.add((Component)tf, c);
            c.gridx = 0;
            ++c.gridy;
            p.add((Component)new Label("Point2"), c);
            ++c.gridx;
            tf = new TextField(10);
            this.tfs.add(tf);
            tf.addFocusListener(this);
            p.add((Component)tf, c);
            this.addPanel(p);
            this.addMessage("Add Point");
            Component co = this.getMessage();
            co.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ++c.gridy;
                    c.gridx = 0;
                    int i = tfs.size() + 1;
                    p.add((Component)new Label("Point" + i), c);
                    ++c.gridx;
                    TextField tf = new TextField(10);
                    tfs.add(tf);
                    tf.addFocusListener(this);
                    p.add((Component)tf, c);
                    this.pack();
                }
            });
            co.setForeground(Color.BLUE);
            this.showDialog();
            if (this.wasCanceled()) {
                univ.removeContent(this.tf0.getText());
            } else {
                this.updatePreview();
                for (int i = 0; i < this.tfs.size() - 1; ++i) {
                    Executer.record("addTubePoint", this.tfs.get(i).getText());
                }
                Executer.record("finishTube", this.tf0.getText(), this.tf1.getText(), this.tfs.get(this.tfs.size() - 1).getText());
            }
        }

        @Override
        public String getNameForContent() {
            return this.tf0.getText();
        }

        @Override
        public Primitive getPrimitive() {
            float radius = Float.parseFloat(this.tf1.getText());
            if (this.tfs.size() < 2) {
                return null;
            }
            ArrayList<Point3f> pts = new ArrayList<Point3f>();
            for (int i = 0; i < this.tfs.size(); ++i) {
                pts.add(PrimitiveDialogs.parsePoint(this.tfs.get(i).getText()));
            }
            return new Tube(pts, radius);
        }
    }

    private static final class ConeDialog
    extends PrimitiveDialog {
        private final TextField tf0;
        private final TextField tf1;
        private final TextField tf2;
        private final TextField tf3;

        public ConeDialog(Image3DUniverse univ) {
            super("Cone", univ);
            this.addStringField("Name", "");
            this.addStringField("From", "");
            this.addStringField("To", "");
            this.addNumericField("Radius", 0.0, 4);
            Vector v = this.getStringFields();
            this.tf0 = (TextField)v.get(0);
            this.tf1 = (TextField)v.get(1);
            this.tf2 = (TextField)v.get(2);
            v = this.getNumericFields();
            this.tf3 = (TextField)v.get(0);
            this.tf0.addFocusListener(this);
            this.tf1.addFocusListener(this);
            this.tf2.addFocusListener(this);
            this.tf3.addFocusListener(this);
            this.showDialog();
            if (this.wasCanceled()) {
                univ.removeContent(this.tf0.getText());
            } else {
                this.updatePreview();
                Executer.record("addCone", this.tf0.getText(), this.tf1.getText(), this.tf2.getText(), this.tf3.getText());
            }
        }

        @Override
        public String getNameForContent() {
            return this.tf0.getText();
        }

        @Override
        public Primitive getPrimitive() {
            Point3f from = PrimitiveDialogs.parsePoint(this.tf1.getText());
            Point3f to = PrimitiveDialogs.parsePoint(this.tf2.getText());
            float radius = Float.parseFloat(this.tf3.getText());
            return new Cone(from, to, radius);
        }
    }

    private static final class SphereDialog
    extends PrimitiveDialog {
        private final TextField tf0;
        private final TextField tf1;
        private final TextField tf2;

        public SphereDialog(Image3DUniverse univ) {
            super("Sphere", univ);
            this.addStringField("Name", "");
            this.addStringField("Center", "");
            this.addNumericField("Radius", 0.0, 4);
            Vector v = this.getStringFields();
            this.tf0 = (TextField)v.get(0);
            this.tf1 = (TextField)v.get(1);
            v = this.getNumericFields();
            this.tf2 = (TextField)v.get(0);
            this.tf0.addFocusListener(this);
            this.tf1.addFocusListener(this);
            this.tf2.addFocusListener(this);
            this.showDialog();
            if (this.wasCanceled()) {
                univ.removeContent(this.tf0.getText());
            } else {
                this.updatePreview();
                Executer.record("addSphere", this.tf0.getText(), this.tf1.getText(), this.tf2.getText());
            }
        }

        @Override
        public String getNameForContent() {
            return this.tf0.getText();
        }

        @Override
        public Primitive getPrimitive() {
            Point3f center = PrimitiveDialogs.parsePoint(this.tf1.getText());
            float radius = Float.parseFloat(this.tf2.getText());
            return new Sphere(center, radius);
        }
    }

    private static final class BoxDialog
    extends PrimitiveDialog {
        private final TextField tf0;
        private final TextField tf1;
        private final TextField tf2;

        public BoxDialog(Image3DUniverse univ) {
            super("Box", univ);
            this.addStringField("Name", "");
            this.addStringField("Lower corner", "");
            this.addStringField("Upper corner", "");
            Vector v = this.getStringFields();
            this.tf0 = (TextField)v.get(0);
            this.tf1 = (TextField)v.get(1);
            this.tf2 = (TextField)v.get(2);
            this.tf0.addFocusListener(this);
            this.tf1.addFocusListener(this);
            this.tf2.addFocusListener(this);
            this.showDialog();
            if (this.wasCanceled()) {
                univ.removeContent(this.tf0.getText());
            } else {
                this.updatePreview();
                Executer.record("addBox", this.tf0.getText(), this.tf1.getText(), this.tf2.getText());
            }
        }

        @Override
        public String getNameForContent() {
            return this.tf0.getText();
        }

        @Override
        public Primitive getPrimitive() {
            Point3f lc = PrimitiveDialogs.parsePoint(this.tf1.getText());
            Point3f uc = PrimitiveDialogs.parsePoint(this.tf2.getText());
            return new Box(lc, uc);
        }
    }

    private static abstract class PrimitiveDialog
    extends GenericDialog
    implements FocusListener {
        protected final Image3DUniverse univ;
        protected Content content;

        public PrimitiveDialog(String title, Image3DUniverse univ) {
            super(title);
            this.univ = univ;
        }

        @Override
        public void focusLost(FocusEvent e) {
            try {
                boolean b = this.univ.getUseToFront();
                this.univ.setUseToFront(false);
                this.updatePreview();
                this.univ.setUseToFront(b);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public abstract Primitive getPrimitive();

        public abstract String getNameForContent();

        public void updatePreview() {
            Primitive prim;
            String name = this.getNameForContent();
            if (this.content != null) {
                this.univ.removeContent(this.content.getName());
            }
            if ((prim = this.getPrimitive()) != null) {
                this.content = this.univ.addCustomMesh(prim, name);
            }
        }
    }
}

