/*
 * Decompiled with CFR 0.152.
 */
package ij3d.gui;

import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import math3d.TransformIO;
import org.scijava.vecmath.AxisAngle4f;
import org.scijava.vecmath.Matrix3f;
import org.scijava.vecmath.Matrix4f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class InteractiveTransformDialog
extends GenericDialog {
    private static final String ws = "\\s*";
    private static final String no = "(\\S*?)";
    private static final Pattern matrixPattern = Pattern.compile("\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*\n\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*\n\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*(\\S*?)\\s*");
    private static final Pattern vectorPattern = Pattern.compile("\\(?(\\S*?),\\s*(\\S*?),\\s*(\\S*?)\\)?");
    private final Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f origin = new Vector3f();
    private float angle = 0.0f;
    private final Vector3f translation = new Vector3f();
    private final Point3f contentCenter;
    private final TextField axisTF;
    private final TextField angleTF;
    private final TextField originTF;
    private final TextField translationTF;
    private final TextArea matrixTA;

    public InteractiveTransformDialog(String title, Point3f contentCenter, Matrix4f m) {
        super(title);
        this.contentCenter = contentCenter;
        this.addStringField("Rotation origin", "C", 15);
        this.originTF = (TextField)this.getStringFields().lastElement();
        this.addTextListener(this.originTF);
        this.addStringField("Rotation axis", this.toString((Tuple3f)this.axis), 15);
        this.axisTF = (TextField)this.getStringFields().lastElement();
        this.addTextListener(this.axisTF);
        this.addNumericField("Angle (in deg)", this.angle, 5);
        this.angleTF = (TextField)this.getNumericFields().lastElement();
        this.addTextListener(this.angleTF);
        this.addStringField("Translation", this.toString((Tuple3f)this.translation), 15);
        this.translationTF = (TextField)this.getStringFields().lastElement();
        this.addTextListener(this.translationTF);
        this.addTextAreas("", null, 4, 50);
        this.matrixTA = this.getTextArea1();
        this.matrixTA.setFont(new Font("Monospaced", 0, 12));
        this.matrixTA.setColumns(50);
        this.matrixTA.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Matrix4f m = new Matrix4f();
                try {
                    InteractiveTransformDialog.this.fromString(InteractiveTransformDialog.this.matrixTA.getText(), m);
                    if (m.determinant() != 0.0f) {
                        InteractiveTransformDialog.this.setTransformation(m, InteractiveTransformDialog.this.origin, true);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        });
        this.matrixTA.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Matrix4f m = new Matrix4f();
                try {
                    InteractiveTransformDialog.this.fromString(InteractiveTransformDialog.this.matrixTA.getText(), m);
                    if (m.determinant() != 0.0f) {
                        InteractiveTransformDialog.this.setTransformation(m, InteractiveTransformDialog.this.origin, false);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        });
        Panel p = new Panel(new FlowLayout());
        Button b = new Button("Open from file");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float[] m = new TransformIO().openAffineTransform();
                if (m != null) {
                    InteractiveTransformDialog.this.setTransformation(new Matrix4f(m), InteractiveTransformDialog.this.origin, true);
                }
            }
        });
        p.add(b);
        this.addPanel(p);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    if (InteractiveTransformDialog.this.wasOKed()) {
                        InteractiveTransformDialog.this.oked(InteractiveTransformDialog.this.fromFields());
                    } else {
                        InteractiveTransformDialog.this.canceled();
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        });
        this.addMessage("You can specify vectors either by tuples in the \nform of (x, y, z) or using the following letters \nas abbreviations:\n  \nX for (1, 0, 0) \nY for (0, 1, 0) \nZ for (0, 0, 1) \nO for (0, 0, 0) \nC for the object center " + contentCenter);
        this.setModal(false);
        this.setTransformation(m, new Vector3f((Tuple3f)contentCenter), true);
        this.showDialog();
    }

    private void setTransformation(Matrix4f m, Vector3f center, boolean setMatrixField) {
        this.origin.set((Tuple3f)center);
        try {
            AxisAngle4f rot = new AxisAngle4f();
            InteractiveTransformDialog.decompose(m, this.origin, rot, this.translation);
            this.angle = (float)((double)(180.0f * rot.getAngle()) / Math.PI);
            this.axis.x = rot.x;
            this.axis.y = rot.y;
            this.axis.z = rot.z;
            this.axisTF.setText(this.toString((Tuple3f)this.axis));
            this.angleTF.setText(Float.toString(this.angle));
            this.originTF.setText(this.toString((Tuple3f)this.origin));
            this.translationTF.setText(this.toString((Tuple3f)this.translation));
            if (setMatrixField) {
                this.matrixTA.setText(this.toString(m));
            }
            this.transformationUpdated(m);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected void transformationUpdated(Matrix4f matrix) {
    }

    protected void oked(Matrix4f mat) {
    }

    protected void canceled() {
    }

    private Matrix4f fromFields() {
        this.fromString(this.axisTF.getText(), (Tuple3f)this.axis);
        this.angle = (float)(Math.PI * (double)Float.parseFloat(this.angleTF.getText()) / 180.0);
        this.fromString(this.originTF.getText(), (Tuple3f)this.origin);
        this.fromString(this.translationTF.getText(), (Tuple3f)this.translation);
        Matrix4f m = new Matrix4f();
        InteractiveTransformDialog.compose(new AxisAngle4f(this.axis, this.angle), this.origin, this.translation, m);
        return m;
    }

    private void addTextListener(TextField tf) {
        tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                try {
                    Matrix4f m = InteractiveTransformDialog.this.fromFields();
                    InteractiveTransformDialog.this.matrixTA.setText(InteractiveTransformDialog.this.toString(m));
                    InteractiveTransformDialog.this.transformationUpdated(m);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        });
    }

    public static void compose(AxisAngle4f rot, Vector3f origin, Vector3f translation, Matrix4f ret) {
        ret.set(rot);
        Vector3f trans = new Vector3f(origin);
        trans.scale(-1.0f);
        ret.transform(trans);
        trans.add((Tuple3f)translation);
        trans.add((Tuple3f)origin);
        ret.setTranslation(trans);
    }

    public static void decompose(Matrix4f mat, Vector3f origin, AxisAngle4f rotation, Vector3f translation) {
        Matrix3f rot = new Matrix3f();
        mat.get(rot);
        rotation.set(rot);
        Point3f tmp = new Point3f((Tuple3f)origin);
        rot.transform((Tuple3f)tmp);
        tmp.sub((Tuple3f)origin);
        mat.get(translation);
        translation.add((Tuple3f)tmp);
    }

    public String toString(Matrix4f mat) {
        return String.format("% 10.3f  % 10.3f  % 10.3f  % 10.3f\n", Float.valueOf(mat.m00), Float.valueOf(mat.m01), Float.valueOf(mat.m02), Float.valueOf(mat.m03)) + String.format("% 10.3f  % 10.3f  % 10.3f  % 10.3f\n", Float.valueOf(mat.m10), Float.valueOf(mat.m11), Float.valueOf(mat.m12), Float.valueOf(mat.m13)) + String.format("% 10.3f  % 10.3f  % 10.3f  % 10.3f", Float.valueOf(mat.m20), Float.valueOf(mat.m21), Float.valueOf(mat.m22), Float.valueOf(mat.m23));
    }

    public void fromString(String s, Matrix4f mat) {
        try {
            Matcher m = matrixPattern.matcher(s);
            m.matches();
            float[] v = new float[16];
            for (int i = 0; i < 12; ++i) {
                v[i] = Float.parseFloat(m.group(i + 1));
            }
            v[15] = 1.0f;
            mat.set(v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse " + s, e);
        }
    }

    public String toString(Tuple3f tuple) {
        if (tuple.x == 0.0f && tuple.y == 0.0f && tuple.z == 0.0f) {
            return "O";
        }
        if (tuple.x == 1.0f && tuple.y == 0.0f && tuple.z == 0.0f) {
            return "X";
        }
        if (tuple.x == 0.0f && tuple.y == 1.0f && tuple.z == 0.0f) {
            return "Y";
        }
        if (tuple.x == 0.0f && tuple.y == 0.0f && tuple.z == 1.0f) {
            return "Z";
        }
        if (tuple.equals((Tuple3f)this.contentCenter)) {
            return "C";
        }
        return "(" + tuple.x + ", " + tuple.y + ", " + tuple.z + ")";
    }

    public void fromString(String s, Tuple3f tuple) {
        if ((s = s.trim()).equalsIgnoreCase("X")) {
            s = "1, 0, 0";
        } else if (s.equalsIgnoreCase("Y")) {
            s = "0, 1, 0";
        } else if (s.equalsIgnoreCase("Z")) {
            s = "0, 0, 1";
        } else if (s.equalsIgnoreCase("O") || s.equals("0")) {
            s = "0, 0, 0";
        } else if (s.equalsIgnoreCase("C")) {
            s = this.contentCenter.x + ", " + this.contentCenter.y + ", " + this.contentCenter.z;
        }
        try {
            Matcher m = vectorPattern.matcher(s);
            m.matches();
            tuple.x = Float.parseFloat(m.group(1));
            tuple.y = Float.parseFloat(m.group(2));
            tuple.z = Float.parseFloat(m.group(3));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse " + s);
        }
    }
}

