/*
 * Decompiled with CFR 0.152.
 */
package ij3d.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij3d.ColorTable;
import ij3d.Content;
import ij3d.ContentCreator;
import ij3d.Image3DUniverse;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import org.scijava.vecmath.Color3f;

public class ContentCreatorDialog {
    private Color3f color;
    private int threshold;
    private String name;
    private int resamplingFactor;
    private boolean[] channels;
    private int timepoint;
    private int type;
    private ImagePlus image;
    private File file;
    private Content content;
    private GenericDialog gd;

    public Content showDialog(final Image3DUniverse univ, ImagePlus imp, File fi) {
        boolean fromFile;
        if (fi != null) {
            this.file = fi;
        }
        int img_count = WindowManager.getImageCount();
        Vector<String> windows = new Vector<String>();
        if (this.file != null) {
            windows.add(this.file.getAbsolutePath());
        } else {
            for (int i = 1; i <= img_count; ++i) {
                int id = WindowManager.getNthImageID((int)i);
                ImagePlus ip = WindowManager.getImage((int)id);
                if (ip == null || ip.getWidth() == 0 || ip.getTitle().equals("3d")) continue;
                windows.add(ip.getTitle());
            }
        }
        if (windows.size() == 0) {
            IJ.error((String)"Need an image!");
            return null;
        }
        String[] images = new String[windows.size()];
        windows.toArray(images);
        this.name = this.file != null ? this.file.getName() : (imp == null ? images[0] : imp.getTitle());
        String[] types = new String[]{"Volume", "Orthoslice", "Surface", "Surface Plot 2D", "Multiorthoslices"};
        this.type = this.type < 0 ? 0 : this.type;
        this.threshold = this.type == 2 ? 50 : 0;
        this.resamplingFactor = 2;
        this.gd = new GenericDialog("Add ...", (Frame)univ.getWindow());
        this.gd.addChoice("Image", images, this.name);
        this.gd.addStringField("Name", this.getUniqueContentLabel(univ, this.name), 10);
        this.gd.addChoice("Display as", types, types[this.type]);
        this.gd.addChoice("Color", ColorTable.colorNames, ColorTable.colorNames[0]);
        this.gd.addNumericField("Threshold", (double)this.threshold, 0);
        this.gd.addNumericField("Resampling factor", (double)this.resamplingFactor, 0);
        this.gd.addMessage("Channels");
        this.gd.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, new boolean[]{true, true, true});
        this.gd.addNumericField("Start at time point", (double)univ.getCurrentTimepoint(), 0);
        final TextField th = (TextField)this.gd.getNumericFields().get(0);
        final Choice di = (Choice)this.gd.getChoices().get(1);
        di.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (di.getSelectedIndex() == 2) {
                    th.setText(Integer.toString(50));
                } else {
                    th.setText(Integer.toString(0));
                }
            }
        });
        final Choice im = (Choice)this.gd.getChoices().get(0);
        final TextField na = (TextField)this.gd.getStringFields().get(0);
        im.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int idx = im.getSelectedIndex();
                String name = ContentCreatorDialog.this.file == null || idx > 0 ? im.getSelectedItem() : ContentCreatorDialog.this.file.getName();
                na.setText(ContentCreatorDialog.this.getUniqueContentLabel(univ, name));
            }
        });
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return null;
        }
        String imChoice = this.gd.getNextChoice();
        boolean bl = fromFile = this.file != null && im.getSelectedIndex() == 0;
        if (!fromFile) {
            this.image = WindowManager.getImage((String)imChoice);
            this.file = null;
        }
        this.name = this.gd.getNextString();
        this.type = this.gd.getNextChoiceIndex();
        this.color = ColorTable.getColor(this.gd.getNextChoice());
        this.threshold = (int)this.gd.getNextNumber();
        this.resamplingFactor = (int)this.gd.getNextNumber();
        this.channels = new boolean[]{this.gd.getNextBoolean(), this.gd.getNextBoolean(), this.gd.getNextBoolean()};
        this.timepoint = (int)this.gd.getNextNumber();
        if (this.resamplingFactor < 1) {
            IJ.error((String)"Resampling factor must be greater than 0");
            return null;
        }
        if (univ.contains(this.name)) {
            IJ.error((String)("Could not add new content. A content with name \"" + this.name + "\" exists already."));
            return null;
        }
        return this.createContent();
    }

    protected String getUniqueContentLabel(Image3DUniverse univ, String name) {
        if (!univ.contains(name)) {
            return name;
        }
        int nr = 2;
        while (univ.contains(name + "-" + nr)) {
            ++nr;
        }
        return name + "-" + nr;
    }

    private Content createContent() {
        ImagePlus[] imps;
        ImagePlus[] imagePlusArray = imps = this.file != null ? ContentCreator.getImages(this.file) : ContentCreator.getImages(this.image);
        if (imps == null || imps.length == 0) {
            return null;
        }
        int imaget = imps[0].getType();
        if (imaget != 0 && imaget != 3 && imaget != 4) {
            if (IJ.showMessageWithCancel((String)"Convert...", (String)"8-bit or RGB image required. Convert?")) {
                for (ImagePlus ip : imps) {
                    ContentCreator.convert(ip);
                }
            } else {
                return null;
            }
        }
        Content c = ContentCreator.createContent(this.name, imps, this.type, this.resamplingFactor, this.timepoint, this.color, this.threshold, this.channels);
        return c;
    }

    public File getFile() {
        return this.file;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public Color3f getColor() {
        return this.color;
    }

    public boolean[] getChannels() {
        return this.channels;
    }

    public int getResamplingFactor() {
        return this.resamplingFactor;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }
}

