/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij.IJ;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.utils.pickfast.PickCanvas;
import org.scijava.java3d.utils.pickfast.PickTool;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Vector3d;
import vib.BenesNamedPoint;
import vib.PointList;
import voltex.VoltexGroup;
import voltex.VoltexVolume;

public class Picker {
    private final DefaultUniverse univ;
    private final ImageCanvas3D canvas;
    private int movingIndex = -1;

    public Picker(DefaultUniverse univ) {
        this.univ = univ;
        this.canvas = (ImageCanvas3D)univ.getCanvas();
    }

    public void deletePoint(Content c, MouseEvent e) {
        float tol;
        if (c == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d p3d = this.getPickPointGeometry(c, e);
        if (p3d == null) {
            return;
        }
        PointList pl = c.getPointList();
        int ind = pl.indexOfPointAt(p3d.x, p3d.y, p3d.z, (double)(tol = c.getLandmarkPointSize()));
        if (ind != -1) {
            pl.remove(ind);
        }
    }

    public synchronized void movePoint(Content c, MouseEvent e) {
        if (c == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d p3d = this.getPickPointGeometry(c, e);
        if (p3d == null) {
            return;
        }
        PointList pl = c.getPointList();
        if (this.movingIndex == -1) {
            this.movingIndex = pl.indexOfPointAt(p3d.x, p3d.y, p3d.z, (double)c.getLandmarkPointSize());
        }
        if (this.movingIndex != -1) {
            pl.placePoint(pl.get(this.movingIndex), p3d.x, p3d.y, p3d.z);
        }
    }

    public synchronized void stopMoving() {
        this.movingIndex = -1;
    }

    public void addPoint(Content c, int x, int y) {
        float tol;
        if (c == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d p3d = this.getPickPointGeometry(c, x, y);
        if (p3d == null) {
            return;
        }
        PointList pl = c.getPointList();
        BenesNamedPoint bnp = pl.pointAt(p3d.x, p3d.y, p3d.z, (double)(tol = c.getLandmarkPointSize()));
        if (bnp == null) {
            pl.add(p3d.x, p3d.y, p3d.z);
        }
    }

    public void addPoint(Content c, MouseEvent e) {
        float tol;
        if (c == null) {
            IJ.error((String)"Selection required");
            return;
        }
        Point3d p3d = this.getPickPointGeometry(c, e);
        if (p3d == null) {
            return;
        }
        PointList pl = c.getPointList();
        BenesNamedPoint bnp = pl.pointAt(p3d.x, p3d.y, p3d.z, (double)(tol = c.getLandmarkPointSize()));
        if (bnp == null) {
            pl.add(p3d.x, p3d.y, p3d.z);
        }
    }

    public Point3d getPickPointGeometry(Content c, Point3d origin, Vector3d dir) {
        PickTool pickTool = new PickTool((BranchGroup)c);
        pickTool.setShapeRay(origin, dir);
        pickTool.setMode(2);
        pickTool.setFlags(8);
        try {
            PickInfo[] result = pickTool.pickAllSorted();
            if (result == null || result.length == 0) {
                return null;
            }
            for (int i = 0; i < result.length; ++i) {
                Point3d intersection = result[i].getClosestIntersectionPoint();
                if (c.getType() != 0) {
                    return intersection;
                }
                float v = Picker.getVolumePoint(c, intersection);
                if (!(v > 20.0f)) continue;
                return intersection;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Point3d getPickPointGeometry(Content c, MouseEvent e) {
        return this.getPickPointGeometry(c, e.getX(), e.getY());
    }

    public Point3d getPickPointGeometry(Content c, int x, int y) {
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this.canvas, (BranchGroup)c);
        pickCanvas.setMode(2);
        pickCanvas.setFlags(8);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(x, y);
        try {
            PickInfo[] result = pickCanvas.pickAllSorted();
            if (result == null || result.length == 0) {
                return null;
            }
            for (int i = 0; i < result.length; ++i) {
                Point3d intersection = result[i].getClosestIntersectionPoint();
                if (c.getType() != 0) {
                    return intersection;
                }
                float v = Picker.getVolumePoint(c, intersection);
                if (!(v > 20.0f)) continue;
                return intersection;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public List<Map.Entry<Point3d, Float>> getPickPointColumn(final Content c, int x, int y) {
        if (c.getType() != 0) {
            return null;
        }
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this.canvas, (BranchGroup)c);
        pickCanvas.setMode(2);
        pickCanvas.setFlags(8);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(x, y);
        try {
            PickInfo[] result = pickCanvas.pickAllSorted();
            if (result == null || result.length == 0) {
                return null;
            }
            ArrayList<Map.Entry<Point3d, Float>> list = new ArrayList<Map.Entry<Point3d, Float>>();
            for (int i = 0; i < result.length; ++i) {
                final Point3d intersection = result[i].getClosestIntersectionPoint();
                list.add(new Map.Entry<Point3d, Float>(){

                    @Override
                    public Point3d getKey() {
                        return intersection;
                    }

                    @Override
                    public Float getValue() {
                        return Float.valueOf(Picker.getVolumePoint(c, intersection));
                    }

                    @Override
                    public Float setValue(Float f) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int[] getPickedVertexIndices(BranchGroup bg, int x, int y) {
        PickCanvas pickCanvas = new PickCanvas(this.univ.getCanvas(), bg);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setMode(2);
        pickCanvas.setFlags(32);
        pickCanvas.setShapeLocation(x, y);
        try {
            PickInfo result = pickCanvas.pickClosest();
            if (result == null) {
                return null;
            }
            PickInfo.IntersectionInfo info = result.getIntersectionInfos()[0];
            return info.getVertexIndices();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Content getPickedContent(int x, int y) {
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this.canvas, this.univ.getScene());
        pickCanvas.setMode(2);
        pickCanvas.setFlags(9);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(x, y);
        try {
            PickInfo[] result = pickCanvas.pickAllSorted();
            if (result == null) {
                return null;
            }
            for (int i = 0; i < result.length; ++i) {
                SceneGraphPath path = result[i].getSceneGraphPath();
                Content c = null;
                for (int j = path.nodeCount() - 1; j >= 0; --j) {
                    if (!(path.getNode(j) instanceof Content)) continue;
                    c = (Content)path.getNode(j);
                }
                if (c == null) continue;
                if (c.getType() != 0 && c.getType() != 1) {
                    return c;
                }
                Point3d intersection = result[i].getClosestIntersectionPoint();
                float v = Picker.getVolumePoint(c, intersection);
                if (!(v > 20.0f)) continue;
                return c;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static float getVolumePoint(Content c, Point3d p) {
        VoltexVolume v = ((VoltexGroup)c.getContent()).getRenderer().getVolume();
        int ix = (int)Math.round(p.x / v.pw);
        int iy = (int)Math.round(p.y / v.ph);
        int iz = (int)Math.round(p.z / v.pd);
        if (ix < 0 || ix >= v.xDim || iy < 0 || iy >= v.yDim || iz < 0 || iz >= v.zDim) {
            return 0.0f;
        }
        return v.getAverage(ix, iy, iz) & 0xFF;
    }
}

