/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij.IJ;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.ContentTransformer;
import ij3d.behaviors.InteractiveViewPlatformTransformer;
import ij3d.behaviors.Picker;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Enumeration;
import java.util.List;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.WakeupCondition;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnAWTEvent;
import org.scijava.java3d.WakeupOr;
import orthoslice.OrthoGroup;

public class InteractiveBehavior
extends Behavior {
    protected final DefaultUniverse univ;
    private final ImageCanvas3D canvas;
    private final WakeupOnAWTEvent[] mouseEvents;
    private WakeupCondition wakeupCriterion;
    private final ContentTransformer contentTransformer;
    private final Picker picker;
    private final InteractiveViewPlatformTransformer viewTransformer;
    private static final int B1 = 1024;
    private static final int B2 = 2048;
    private static final int B3 = 4096;
    private static final int SHIFT = 64;
    private static final int CTRL = 128;
    private static final int PICK_POINT_MASK = 1024;
    private static final int DELETE_POINT_MASK = 1536;
    public static final double TWO_RAD = Math.PI / 90;
    private List<InteractiveBehavior> external;
    private int lastToolID;

    public void setExternalBehaviours(List<InteractiveBehavior> bs) {
        this.external = bs;
    }

    public List<InteractiveBehavior> getExternalBehaviors() {
        return this.external;
    }

    public InteractiveBehavior(DefaultUniverse univ) {
        this.univ = univ;
        this.canvas = (ImageCanvas3D)univ.getCanvas();
        this.contentTransformer = univ.getContentTransformer();
        this.picker = univ.getPicker();
        this.viewTransformer = univ.getViewPlatformTransformer();
        this.mouseEvents = new WakeupOnAWTEvent[6];
        this.lastToolID = univ.ui.getToolId();
    }

    public void initialize() {
        this.mouseEvents[0] = new WakeupOnAWTEvent(506);
        this.mouseEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseEvents[2] = new WakeupOnAWTEvent(502);
        this.mouseEvents[3] = new WakeupOnAWTEvent(500);
        this.mouseEvents[4] = new WakeupOnAWTEvent(507);
        this.mouseEvents[5] = new WakeupOnAWTEvent(8L);
        this.wakeupCriterion = new WakeupOr((WakeupCriterion[])this.mouseEvents);
        this.wakeupOn(this.wakeupCriterion);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            AWTEvent[] events;
            WakeupOnAWTEvent wakeup = (WakeupOnAWTEvent)criteria.nextElement();
            for (AWTEvent evt : events = wakeup.getAWTEvent()) {
                if (evt instanceof MouseEvent) {
                    this.doProcess((MouseEvent)evt);
                }
                if (!(evt instanceof KeyEvent)) continue;
                this.doProcess((KeyEvent)evt);
            }
        }
        this.wakeupOn(this.wakeupCriterion);
    }

    private boolean shouldRotate(int mask) {
        int onmask = 2048;
        int onmask2 = 1024;
        int offmask = 192;
        boolean b0 = (mask & 0x8C0) == 2048;
        boolean b1 = this.univ.ui.isHandTool() && (mask & 0x4C0) == 1024;
        return b0 || b1;
    }

    private boolean shouldTranslate(int mask) {
        int onmask = 2112;
        int onmask2 = 1088;
        int offmask = 128;
        return (mask & 0x8C0) == 2112 || this.univ.ui.isHandTool() && (mask & 0x4C0) == 1088;
    }

    private boolean shouldZoom(int mask) {
        if (!this.univ.ui.isMagnifierTool()) {
            return false;
        }
        int onmask = 1024;
        int offmask = 192;
        return (mask & 0x4C0) == 1024;
    }

    private boolean shouldMovePoint(int mask) {
        if (!this.univ.ui.isPointTool()) {
            return false;
        }
        int onmask = 1024;
        int offmask = 192;
        return (mask & 0x4C0) == 1024;
    }

    private boolean isXYZKey(KeyEvent e) {
        int c = e.getKeyCode();
        boolean b = c == 88 || c == 89 || c == 90;
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(KeyEvent e) {
        if (null != this.external) {
            for (InteractiveBehavior b : this.external) {
                b.doProcess(e);
                if (!e.isConsumed()) continue;
                return;
            }
        }
        int id = e.getID();
        int code = e.getKeyCode();
        boolean consumed = true;
        try {
            if (id == 402) {
                this.canvas.keyReleased(e);
                if (!this.isXYZKey(e)) {
                    consumed = false;
                }
                return;
            }
            if (id == 400) {
                return;
            }
            this.canvas.keyPressed(e);
            if (this.isXYZKey(e)) {
                return;
            }
            consumed = false;
            if (code == 27) {
                if (((Image3DUniverse)this.univ).isFullScreen()) {
                    ((Image3DUniverse)this.univ).setFullScreen(false);
                } else if (this.univ.ui.isHandTool()) {
                    this.univ.ui.setTool(this.lastToolID);
                } else {
                    this.lastToolID = this.univ.ui.getToolId();
                    this.univ.ui.setHandTool();
                }
                return;
            }
            Content c = this.univ.getSelected();
            int axis = -1;
            if (this.canvas.isKeyDown(88)) {
                axis = 0;
            } else if (this.canvas.isKeyDown(89)) {
                axis = 1;
            } else if (this.canvas.isKeyDown(90)) {
                axis = 2;
            }
            if (e.isShiftDown()) {
                if (c != null && !c.isLocked()) {
                    this.contentTransformer.init(c, 0, 0);
                }
                switch (code) {
                    case 39: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.translate(2, 0);
                        } else {
                            this.viewTransformer.translateXY(2, 0);
                        }
                        return;
                    }
                    case 37: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.translate(-2, 0);
                        } else {
                            this.viewTransformer.translateXY(-2, 0);
                        }
                        return;
                    }
                    case 38: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.translate(0, -2);
                        } else {
                            this.viewTransformer.translateXY(0, -2);
                        }
                        return;
                    }
                    case 40: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.translate(0, 2);
                        } else {
                            this.viewTransformer.translateXY(0, 2);
                        }
                        return;
                    }
                }
            } else if (e.isAltDown()) {
                switch (code) {
                    case 38: {
                        this.viewTransformer.zoom(1);
                        return;
                    }
                    case 40: {
                        this.viewTransformer.zoom(-1);
                        return;
                    }
                }
            } else if (c != null && c.getType() == 1 && axis != -1) {
                boolean changed = false;
                for (ContentInstant ci : c.getInstants().values()) {
                    OrthoGroup og = (OrthoGroup)ci.getContent();
                    switch (code) {
                        case 38: 
                        case 39: {
                            og.increase(axis);
                            changed = true;
                            break;
                        }
                        case 37: 
                        case 40: {
                            og.decrease(axis);
                            changed = true;
                            break;
                        }
                        case 32: {
                            og.setVisible(axis, !og.isVisible(axis));
                            changed = true;
                        }
                    }
                }
                if (changed) {
                    this.univ.fireContentChanged(c);
                }
            } else {
                if (c != null && !c.isLocked()) {
                    this.contentTransformer.init(c, 0, 0);
                }
                switch (code) {
                    case 39: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.rotate(5, 0);
                        } else {
                            this.viewTransformer.rotateY(-Math.PI / 90);
                        }
                        return;
                    }
                    case 37: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.rotate(-5, 0);
                        } else {
                            this.viewTransformer.rotateY(Math.PI / 90);
                        }
                        return;
                    }
                    case 38: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.rotate(0, -5);
                        } else {
                            this.viewTransformer.rotateX(Math.PI / 90);
                        }
                        return;
                    }
                    case 40: {
                        if (c != null && !c.isLocked()) {
                            this.contentTransformer.rotate(0, 5);
                        } else {
                            this.viewTransformer.rotateX(-Math.PI / 90);
                        }
                        return;
                    }
                    case 33: {
                        this.viewTransformer.zoom(1);
                        return;
                    }
                    case 34: {
                        this.viewTransformer.zoom(-1);
                        return;
                    }
                }
            }
            consumed = false;
        }
        finally {
            if (consumed) {
                e.consume();
            }
            if (!(e.isConsumed() || IJ.getInstance() == null || code != 76 && code != 10)) {
                IJ.getInstance().keyPressed(e);
            }
        }
    }

    protected void doProcess(MouseEvent e) {
        if (null != this.external) {
            for (InteractiveBehavior b : this.external) {
                b.doProcess(e);
                if (!e.isConsumed()) continue;
                return;
            }
        }
        int id = e.getID();
        int mask = e.getModifiersEx();
        Content c = this.univ.getSelected();
        if (id == 501) {
            if (c != null && !c.isLocked()) {
                this.contentTransformer.init(c, e.getX(), e.getY());
            } else {
                this.viewTransformer.init(e);
            }
            if (this.univ.ui.isPointTool()) {
                Content sel = c;
                if (sel == null && ((Image3DUniverse)this.univ).getContents().size() == 1) {
                    sel = (Content)this.univ.contents().next();
                }
                if (sel != null) {
                    sel.showPointList(true);
                    e.consume();
                }
                if (mask == 1024) {
                    this.picker.addPoint(sel, e);
                    e.consume();
                } else if ((mask & 0x600) == 1536) {
                    this.picker.deletePoint(sel, e);
                    e.consume();
                }
            }
            if (!e.isConsumed()) {
                this.canvas.getRoiCanvas().mousePressed(e);
            }
        } else if (id == 506) {
            if (this.shouldTranslate(mask)) {
                if (c != null && !c.isLocked()) {
                    this.contentTransformer.translate(e);
                } else {
                    this.viewTransformer.translate(e);
                }
                e.consume();
            } else if (this.shouldRotate(mask)) {
                if (c != null && !c.isLocked() && 1024 == (mask & 0x400)) {
                    this.contentTransformer.rotate(e);
                } else {
                    this.viewTransformer.rotate(e);
                }
                e.consume();
            } else if (this.shouldZoom(mask)) {
                this.viewTransformer.zoom(e);
                e.consume();
            } else if (this.shouldMovePoint(mask)) {
                this.picker.movePoint(c, e);
                e.consume();
            }
            if (!e.isConsumed()) {
                this.canvas.getRoiCanvas().mouseDragged(e);
            }
        } else if (id == 502) {
            if (this.univ.ui.isPointTool()) {
                this.picker.stopMoving();
                e.consume();
            }
            if (!e.isConsumed()) {
                this.canvas.getRoiCanvas().mouseReleased(e);
            }
        }
        if (id == 507) {
            int axis = -1;
            if (this.canvas.isKeyDown(88)) {
                axis = 0;
            } else if (this.canvas.isKeyDown(89)) {
                axis = 1;
            } else if (this.canvas.isKeyDown(90)) {
                axis = 2;
            }
            if (c != null && c.getType() == 1 && axis != -1) {
                MouseWheelEvent we = (MouseWheelEvent)e;
                int units = 0;
                if (we.getScrollType() == 0) {
                    units = we.getUnitsToScroll();
                }
                for (ContentInstant ci : c.getInstants().values()) {
                    OrthoGroup og = (OrthoGroup)ci.getContent();
                    if (units > 0) {
                        og.increase(axis);
                        continue;
                    }
                    if (units >= 0) continue;
                    og.decrease(axis);
                }
                this.univ.fireContentChanged(c);
            } else {
                this.viewTransformer.wheel_zoom(e);
            }
            e.consume();
        }
    }
}

