/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.BehaviorCallback;
import java.awt.event.MouseEvent;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.vecmath.AxisAngle4d;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;

public class ContentTransformer {
    private final Initializer initializer;
    private final DefaultUniverse univ;
    private final ImageCanvas3D canvas;
    private final BehaviorCallback callback;
    private Content content;
    private final Vector3d axisPerDx = new Vector3d();
    private final Vector3d axisPerDy = new Vector3d();
    private double anglePerPix;
    private final AxisAngle4d aaX = new AxisAngle4d();
    private final AxisAngle4d aaY = new AxisAngle4d();
    private final Transform3D transX = new Transform3D();
    private final Transform3D transY = new Transform3D();
    private final Transform3D transl = new Transform3D();
    private final Transform3D transl_inv = new Transform3D();
    private final Vector3d translationPerDx = new Vector3d();
    private final Vector3d translationPerDy = new Vector3d();
    private TransformGroup translateTG;
    private TransformGroup rotateTG;
    private int xLast;
    private int yLast;
    private final Transform3D translateNew = new Transform3D();
    private final Transform3D translateOld = new Transform3D();
    private final Vector3d translation = new Vector3d();
    private final Point3d v1 = new Point3d();
    private final Point3d v2 = new Point3d();
    private final Transform3D rotateNew = new Transform3D();
    private final Transform3D rotateOld = new Transform3D();

    public ContentTransformer(DefaultUniverse univ, BehaviorCallback callback) {
        this.univ = univ;
        this.canvas = (ImageCanvas3D)univ.getCanvas();
        this.callback = callback;
        this.initializer = new Initializer();
    }

    public void init(Content c, int x, int y) {
        this.initializer.init(c, x, y);
    }

    public void translate(MouseEvent e) {
        this.translate(e.getX(), e.getY());
    }

    public void rotate(MouseEvent e) {
        this.rotate(e.getX(), e.getY());
    }

    void translate(int xNew, int yNew) {
        if (this.content == null || this.content.isLocked()) {
            return;
        }
        int dx = xNew - this.xLast;
        int dy = yNew - this.yLast;
        this.translateTG.getTransform(this.translateOld);
        this.v1.scale((double)dx, (Tuple3d)this.translationPerDx);
        this.v2.scale((double)(-dy), (Tuple3d)this.translationPerDy);
        this.translation.add((Tuple3d)this.v1, (Tuple3d)this.v2);
        this.translateNew.set(this.translation);
        this.translateNew.mul(this.translateOld);
        this.translateTG.setTransform(this.translateNew);
        this.transformChanged(0, this.translateNew);
        this.xLast = xNew;
        this.yLast = yNew;
    }

    void rotate(int xNew, int yNew) {
        if (this.content == null || this.content.isLocked()) {
            return;
        }
        int dx = xNew - this.xLast;
        int dy = yNew - this.yLast;
        this.aaX.set(this.axisPerDx, (double)dx * this.anglePerPix);
        this.aaY.set(this.axisPerDy, (double)dy * this.anglePerPix);
        this.transX.set(this.aaX);
        this.transY.set(this.aaY);
        this.rotateTG.getTransform(this.rotateOld);
        this.rotateNew.set(this.transl_inv);
        this.rotateNew.mul(this.transY);
        this.rotateNew.mul(this.transX);
        this.rotateNew.mul(this.transl);
        this.rotateNew.mul(this.rotateOld);
        this.rotateTG.setTransform(this.rotateNew);
        this.xLast = xNew;
        this.yLast = yNew;
        this.transformChanged(0, this.rotateNew);
    }

    private void transformChanged(int type, Transform3D t) {
        if (this.callback != null) {
            this.callback.transformChanged(type, t);
        }
    }

    private class Initializer {
        private final Point3d centerInVWorld = new Point3d();
        private final Point3d centerInIp = new Point3d();
        private final Transform3D ipToVWorld = new Transform3D();
        private final Transform3D ipToVWorldInverse = new Transform3D();
        private final Transform3D localToVWorld = new Transform3D();
        private final Transform3D localToVWorldInverse = new Transform3D();
        private final Point3d eyePtInVWorld = new Point3d();
        private final Point3d pickPtInVWorld = new Point3d();
        private final Point3d p1 = new Point3d();
        private final Point3d p2 = new Point3d();
        private final Point3d p3 = new Point3d();
        private final Vector3d vec = new Vector3d();

        private Initializer() {
        }

        private void init(Content c, int x, int y) {
            ContentTransformer.this.xLast = x;
            ContentTransformer.this.yLast = y;
            ContentTransformer.this.content = c;
            c.getLocalToVworld(this.localToVWorld);
            this.localToVWorldInverse.invert(this.localToVWorld);
            ContentTransformer.this.canvas.getImagePlateToVworld(this.ipToVWorld);
            this.ipToVWorldInverse.invert(this.ipToVWorld);
            c.getContent().getCenter((Tuple3d)this.centerInVWorld);
            this.localToVWorld.transform(this.centerInVWorld);
            this.ipToVWorldInverse.transform(this.centerInVWorld, this.centerInIp);
            ContentTransformer.this.canvas.getCenterEyeInImagePlate(this.eyePtInVWorld);
            this.ipToVWorld.transform(this.eyePtInVWorld);
            Point3d p = ContentTransformer.this.univ.getPicker().getPickPointGeometry(c, x, y);
            float r = 0.0f;
            float dD = 0.0f;
            if (p != null) {
                this.pickPtInVWorld.set((Tuple3d)p);
                this.localToVWorld.transform(this.pickPtInVWorld);
                r = (float)this.pickPtInVWorld.distance(this.centerInVWorld);
            } else {
                c.getContent().getMin((Tuple3d)this.p1);
                this.localToVWorld.transform(this.p1);
                r = (float)this.p1.distance(this.centerInVWorld);
                this.vec.sub((Tuple3d)this.centerInVWorld, (Tuple3d)this.eyePtInVWorld);
                this.vec.normalize();
                this.vec.scale((double)(-r));
                this.pickPtInVWorld.add((Tuple3d)this.centerInVWorld, (Tuple3d)this.vec);
            }
            dD = (float)this.pickPtInVWorld.distance(this.eyePtInVWorld);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(x, y, this.p1);
            this.ipToVWorld.transform(this.p1);
            float dd = (float)this.p1.distance(this.eyePtInVWorld);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(x + 1, y, this.p2);
            this.ipToVWorld.transform(this.p2);
            float dx = (float)this.p1.distance(this.p2);
            ContentTransformer.this.canvas.getPixelLocationInImagePlate(x, y + 1, this.p3);
            this.ipToVWorld.transform(this.p3);
            float dy = (float)this.p1.distance(this.p3);
            float dX = dD / dd * dx;
            float dY = dD / dd * dy;
            ContentTransformer.this.anglePerPix = Math.atan2(dX, r);
            ContentTransformer.this.univ.getViewPlatformTransformer().getYDir(ContentTransformer.this.axisPerDx, this.ipToVWorld);
            ContentTransformer.this.univ.getViewPlatformTransformer().getXDir(ContentTransformer.this.axisPerDy, this.ipToVWorld);
            ContentTransformer.this.translationPerDx.set((Tuple3d)ContentTransformer.this.axisPerDy);
            ContentTransformer.this.translationPerDx.scale((double)dX);
            ContentTransformer.this.translationPerDy.set((Tuple3d)ContentTransformer.this.axisPerDx);
            ContentTransformer.this.translationPerDy.scale((double)dY);
            ContentTransformer.this.rotateTG = c.getLocalRotate();
            ContentTransformer.this.translateTG = c.getLocalTranslate();
            c.getContent().getCenter((Tuple3d)this.vec);
            ContentTransformer.this.transl_inv.set(this.vec);
            this.vec.set(-this.vec.x, -this.vec.y, -this.vec.z);
            ContentTransformer.this.transl.set(this.vec);
        }
    }
}

