/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import java.awt.image.IndexColorModel;
import org.scijava.vecmath.Point3d;

public class Volume {
    private int[] rLUT = new int[256];
    private int[] gLUT = new int[256];
    private int[] bLUT = new int[256];
    private int[] aLUT = new int[256];
    public static final int INT_DATA = 0;
    public static final int BYTE_DATA = 1;
    protected ImagePlus imp;
    protected InputImage image;
    protected Loader loader;
    protected int dataType;
    protected boolean average = false;
    protected boolean saturatedVolumeRendering = false;
    protected boolean[] channels = new boolean[]{true, true, true};
    public int xDim;
    public int yDim;
    public int zDim;
    public double pw;
    public double ph;
    public double pd;
    public final Point3d minCoord = new Point3d();
    public final Point3d maxCoord = new Point3d();

    protected Volume() {
        this.image = null;
    }

    public Volume(ImagePlus imp) {
        this(imp, new boolean[]{true, true, true});
    }

    public Volume(ImagePlus imp, boolean[] ch) {
        this.setImage(imp, ch);
    }

    private void setLUTsFromImage(ImagePlus imp) {
        switch (imp.getType()) {
            case 0: 
            case 3: {
                IndexColorModel cm = (IndexColorModel)imp.getProcessor().getCurrentColorModel();
                for (int i = 0; i < 256; ++i) {
                    this.rLUT[i] = cm.getRed(i);
                    this.gLUT[i] = cm.getGreen(i);
                    this.bLUT[i] = cm.getBlue(i);
                    this.aLUT[i] = Math.min(254, (this.rLUT[i] + this.gLUT[i] + this.bLUT[i]) / 3);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 256; ++i) {
                    this.gLUT[i] = this.bLUT[i] = i;
                    this.rLUT[i] = this.bLUT[i];
                    this.aLUT[i] = Math.min(254, i);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type");
            }
        }
    }

    public void setImage(ImagePlus imp, boolean[] ch) {
        this.imp = imp;
        this.channels = ch;
        switch (imp.getType()) {
            case 0: 
            case 3: {
                this.image = new ByteImage(imp);
                break;
            }
            case 4: {
                this.image = new IntImage(imp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type");
            }
        }
        this.setLUTsFromImage(this.imp);
        this.xDim = imp.getWidth();
        this.yDim = imp.getHeight();
        this.zDim = imp.getStackSize();
        Calibration c = imp.getCalibration();
        this.pw = c.pixelWidth;
        this.ph = c.pixelHeight;
        this.pd = c.pixelDepth;
        float xSpace = (float)this.pw;
        float ySpace = (float)this.ph;
        float zSpace = (float)this.pd;
        this.minCoord.x = c.xOrigin;
        this.minCoord.y = c.yOrigin;
        this.minCoord.z = c.zOrigin;
        this.maxCoord.x = this.minCoord.x + (double)((float)this.xDim * xSpace);
        this.maxCoord.y = this.minCoord.y + (double)((float)this.yDim * ySpace);
        this.maxCoord.z = this.minCoord.z + (double)((float)this.zDim * zSpace);
        this.initDataType();
        this.initLoader();
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    public void clear() {
        this.imp = null;
        this.image = null;
        this.loader = null;
    }

    public void swap(String path) {
        IJ.save((ImagePlus)this.imp, (String)(path + ".tif"));
        this.imp = null;
        this.image = null;
        this.loader = null;
    }

    public void restore(String path) {
        this.setImage(IJ.openImage((String)(path + ".tif")), this.channels);
    }

    public boolean isDefaultLUT() {
        for (int i = 0; i < 256; ++i) {
            if (!(this.channels[0] && this.rLUT[i] != i || this.channels[1] && this.gLUT[i] != i || this.channels[2] && this.bLUT[i] != i) && this.aLUT[i] == i) continue;
            return false;
        }
        return true;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean setAverage(boolean a) {
        if (this.average != a) {
            this.average = a;
            this.initDataType();
            this.initLoader();
            return true;
        }
        return false;
    }

    public boolean isAverage() {
        return this.average;
    }

    public boolean setSaturatedVolumeRendering(boolean b) {
        if (this.saturatedVolumeRendering != b) {
            this.saturatedVolumeRendering = b;
            this.initLoader();
            return true;
        }
        return false;
    }

    public boolean isSaturatedVolumeRendering() {
        return this.saturatedVolumeRendering;
    }

    public void getRedLUT(int[] lut) {
        System.arraycopy(this.rLUT, 0, lut, 0, this.rLUT.length);
    }

    public void getGreenLUT(int[] lut) {
        System.arraycopy(this.gLUT, 0, lut, 0, this.gLUT.length);
    }

    public void getBlueLUT(int[] lut) {
        System.arraycopy(this.bLUT, 0, lut, 0, this.bLUT.length);
    }

    public void getAlphaLUT(int[] lut) {
        System.arraycopy(this.aLUT, 0, lut, 0, this.aLUT.length);
    }

    public boolean setChannels(boolean[] ch) {
        if (ch[0] == this.channels[0] && ch[1] == this.channels[1] && ch[2] == this.channels[2]) {
            return false;
        }
        this.channels = ch;
        if (this.initDataType()) {
            this.initLoader();
        }
        return true;
    }

    public boolean setLUTs(int[] r, int[] g, int[] b, int[] a) {
        this.rLUT = r;
        this.gLUT = g;
        this.bLUT = b;
        this.aLUT = a;
        if (this.initDataType()) {
            this.initLoader();
            return true;
        }
        return false;
    }

    public boolean setAlphaLUTFullyOpaque() {
        for (int i = 0; i < this.aLUT.length; ++i) {
            this.aLUT[i] = 254;
        }
        if (this.initDataType()) {
            this.initLoader();
            return true;
        }
        return false;
    }

    protected void initLoader() {
        if (this.image == null) {
            throw new RuntimeException("No image. Maybe it is swapped?");
        }
        if (this.dataType == 0) {
            this.loader = this.saturatedVolumeRendering ? new SaturatedIntLoader(this.image) : new IntLoader(this.image);
            return;
        }
        if (this.average) {
            this.loader = new AverageByteLoader(this.image);
            return;
        }
        int channel = 0;
        if (this.image instanceof IntImage) {
            for (int i = 0; i < 3; ++i) {
                if (!this.channels[i]) continue;
                channel = i;
            }
        }
        this.loader = new ByteLoader(this.image, channel);
    }

    protected boolean initDataType() {
        if (this.image == null) {
            throw new RuntimeException("No image. Maybe it is swapped?");
        }
        int noChannels = 0;
        if (this.image instanceof ByteImage) {
            noChannels = 1;
        } else {
            for (int i = 0; i < 3; ++i) {
                if (!this.channels[i]) continue;
                ++noChannels;
            }
        }
        boolean defaultLUT = this.isDefaultLUT();
        int tmp = this.dataType;
        this.dataType = this.average || defaultLUT && noChannels < 2 ? 1 : 0;
        return tmp != this.dataType;
    }

    public void setNoCheck(int x, int y, int z, int v) {
        try {
            this.loader.setNoCheck(x, y, z, v);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No image. Maybe it is swapped");
        }
    }

    public void set(int x, int y, int z, int v) {
        try {
            this.loader.set(x, y, z, v);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No image. Maybe it is swapped");
        }
    }

    public int load(int x, int y, int z) {
        try {
            return this.loader.load(x, y, z);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No image. Maybe it is swapped");
        }
    }

    public int loadWithLUT(int x, int y, int z) {
        try {
            return this.loader.loadWithLUT(x, y, z);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No image. Maybe it is swapped");
        }
    }

    public byte getAverage(int x, int y, int z) {
        try {
            return this.image.getAverage(x, y, z);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No image. Maybe it is swapped");
        }
    }

    protected class AverageByteLoader
    extends ByteLoader {
        private final int[] color;

        protected AverageByteLoader(InputImage imp) {
            super(imp, 0);
            this.color = new int[3];
        }

        @Override
        public final int load(int x, int y, int z) {
            this.image.get(x, y, z, this.color);
            return (this.color[0] + this.color[1] + this.color[2]) / 3;
        }

        @Override
        public final int loadWithLUT(int x, int y, int z) {
            this.image.get(x, y, z, this.color);
            int sum = 0;
            int av = 0;
            if (Volume.this.channels[0]) {
                av += Volume.this.rLUT[this.color[0]];
                ++sum;
            }
            if (Volume.this.channels[1]) {
                av += Volume.this.gLUT[this.color[1]];
                ++sum;
            }
            if (Volume.this.channels[2]) {
                av += Volume.this.bLUT[this.color[2]];
                ++sum;
            }
            return av /= sum;
        }

        @Override
        public void setNoCheck(int x, int y, int z, int v) {
            this.image.set(x, y, z, v);
        }

        @Override
        public void set(int x, int y, int z, int v) {
            if (x >= 0 && x < Volume.this.xDim && y >= 0 && y < Volume.this.yDim && z > 0 && z < Volume.this.zDim) {
                this.setNoCheck(x, y, z, v);
            }
        }
    }

    protected class ByteLoader
    implements Loader {
        protected InputImage image;
        protected int channel;
        private final int[] color = new int[3];

        protected ByteLoader(InputImage imp, int channel) {
            this.image = imp;
            this.channel = channel;
        }

        @Override
        public int load(int x, int y, int z) {
            return this.image.get(x, y, z);
        }

        @Override
        public int loadWithLUT(int x, int y, int z) {
            this.image.get(x, y, z, this.color);
            return this.color[this.channel];
        }

        @Override
        public void setNoCheck(int x, int y, int z, int v) {
            this.image.set(x, y, z, v);
        }

        @Override
        public void set(int x, int y, int z, int v) {
            if (x >= 0 && x < Volume.this.xDim && y >= 0 && y < Volume.this.yDim && z > 0 && z < Volume.this.zDim) {
                this.setNoCheck(x, y, z, v);
            }
        }
    }

    protected class SaturatedIntLoader
    extends IntLoader {
        protected SaturatedIntLoader(InputImage imp) {
            super(imp);
        }

        @Override
        public final int loadWithLUT(int x, int y, int z) {
            int maxC;
            this.image.get(x, y, z, this.color);
            int sum = 0;
            int av = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            if (Volume.this.channels[0]) {
                r = Volume.this.rLUT[this.color[0]];
                ++sum;
                av += this.color[0];
            }
            if (Volume.this.channels[1]) {
                g = Volume.this.gLUT[this.color[1]];
                ++sum;
                av += this.color[1];
            }
            if (Volume.this.channels[2]) {
                b = Volume.this.bLUT[this.color[2]];
                ++sum;
                av += this.color[2];
            }
            float scale = (maxC = Math.max(r, Math.max(g, b))) == 0 ? 0.0f : 255.0f / (float)maxC;
            r = Math.min(255, Math.round(scale * (float)r));
            g = Math.min(255, Math.round(scale * (float)g));
            b = Math.min(255, Math.round(scale * (float)b));
            return Volume.this.aLUT[av /= sum] << 24 | r << 16 | g << 8 | b;
        }
    }

    protected class IntLoader
    implements Loader {
        protected InputImage image;
        protected int[] color = new int[3];

        protected IntLoader(InputImage imp) {
            this.image = imp;
        }

        @Override
        public final int load(int x, int y, int z) {
            return this.image.get(x, y, z);
        }

        @Override
        public int loadWithLUT(int x, int y, int z) {
            this.image.get(x, y, z, this.color);
            int sum = 0;
            int av = 0;
            int v = 0;
            if (Volume.this.channels[0]) {
                int r = Volume.this.rLUT[this.color[0]];
                ++sum;
                av += this.color[0];
                v += r << 16;
            }
            if (Volume.this.channels[1]) {
                int g = Volume.this.gLUT[this.color[1]];
                ++sum;
                av += this.color[1];
                v += g << 8;
            }
            if (Volume.this.channels[2]) {
                int b = Volume.this.bLUT[this.color[2]];
                ++sum;
                av += this.color[2];
                v += b;
            }
            int a = Volume.this.aLUT[av /= sum];
            return (a << 24) + v;
        }

        @Override
        public void setNoCheck(int x, int y, int z, int v) {
            this.image.set(x, y, z, v);
        }

        @Override
        public void set(int x, int y, int z, int v) {
            if (x >= 0 && x < Volume.this.xDim && y >= 0 && y < Volume.this.yDim && z > 0 && z < Volume.this.zDim) {
                this.setNoCheck(x, y, z, v);
            }
        }
    }

    protected final class IntImage
    implements InputImage {
        protected int[][] fData;
        private final int w;

        protected IntImage(ImagePlus imp) {
            ImageStack stack = imp.getStack();
            this.w = imp.getWidth();
            int d = imp.getStackSize();
            this.fData = new int[d][];
            for (int z = 0; z < d; ++z) {
                this.fData[z] = (int[])stack.getPixels(z + 1);
            }
        }

        @Override
        public byte getAverage(int x, int y, int z) {
            int v = this.fData[z][y * this.w + x];
            int r = (v & 0xFF0000) >> 16;
            int g = (v & 0xFF00) >> 8;
            int b = v & 0xFF;
            return (byte)((r + g + b) / 3);
        }

        @Override
        public int get(int x, int y, int z) {
            return this.fData[z][y * this.w + x];
        }

        @Override
        public void get(int x, int y, int z, int[] c) {
            int v = this.get(x, y, z);
            c[0] = (v & 0xFF0000) >> 16;
            c[1] = (v & 0xFF00) >> 8;
            c[2] = v & 0xFF;
        }

        @Override
        public void set(int x, int y, int z, int v) {
            this.fData[z][y * this.w + x] = v;
        }
    }

    protected final class ByteImage
    implements InputImage {
        protected byte[][] fData;
        private final int w;

        protected ByteImage(ImagePlus imp) {
            ImageStack stack = imp.getStack();
            this.w = imp.getWidth();
            int d = imp.getStackSize();
            this.fData = new byte[d][];
            for (int z = 0; z < d; ++z) {
                this.fData[z] = (byte[])stack.getPixels(z + 1);
            }
        }

        @Override
        public byte getAverage(int x, int y, int z) {
            return this.fData[z][y * this.w + x];
        }

        @Override
        public int get(int x, int y, int z) {
            return this.fData[z][y * this.w + x] & 0xFF;
        }

        @Override
        public void get(int x, int y, int z, int[] c) {
            int v;
            c[1] = c[2] = (v = this.get(x, y, z));
            c[0] = c[2];
        }

        @Override
        public void set(int x, int y, int z, int v) {
            this.fData[z][y * this.w + x] = (byte)v;
        }
    }

    protected static interface InputImage {
        public int get(int var1, int var2, int var3);

        public void get(int var1, int var2, int var3, int[] var4);

        public byte getAverage(int var1, int var2, int var3);

        public void set(int var1, int var2, int var3, int var4);
    }

    protected static interface Loader {
        public int load(int var1, int var2, int var3);

        public int loadWithLUT(int var1, int var2, int var3);

        public void set(int var1, int var2, int var3, int var4);

        public void setNoCheck(int var1, int var2, int var3, int var4);
    }
}

