/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij3d.Content;
import ij3d.Image3DUniverse;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;

public class ViewAdjuster {
    public static final int ADJUST_HORIZONTAL = 0;
    public static final int ADJUST_VERTICAL = 1;
    public static final int ADJUST_BOTH = 2;
    private final Canvas3D canvas;
    private final Image3DUniverse univ;
    private final Point3d eye = new Point3d();
    private final Point3d oldEye = new Point3d();
    private final Transform3D toCamera = new Transform3D();
    private final Transform3D toCameraInverse = new Transform3D();
    private boolean firstPoint = true;
    private double e = 1.0;
    private double w = 2.0 * Math.tan(0.39269908169872414);
    private double h = 2.0 * Math.tan(0.39269908169872414);
    private final Adjuster adjuster;

    public ViewAdjuster(Image3DUniverse univ, int dir) {
        this.univ = univ;
        this.canvas = univ.getCanvas();
        switch (dir) {
            case 0: {
                this.adjuster = new HorizontalAdjuster();
                break;
            }
            case 1: {
                this.adjuster = new VerticalAdjuster();
                break;
            }
            case 2: {
                this.adjuster = new BothAdjuster();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.canvas.getCenterEyeInImagePlate(this.eye);
        this.canvas.getImagePlateToVworld(this.toCamera);
        this.toCamera.transform(this.eye);
        univ.getVworldToCamera(this.toCamera);
        this.toCamera.transform(this.eye);
        this.oldEye.set((Tuple3d)this.eye);
        Transform3D toIpInverse = new Transform3D();
        this.canvas.getImagePlateToVworld(toIpInverse);
        Point3d lu = new Point3d();
        this.canvas.getPixelLocationInImagePlate(0, 0, lu);
        toIpInverse.transform(lu);
        this.toCamera.transform(lu);
        Point3d rl = new Point3d();
        this.canvas.getPixelLocationInImagePlate(this.canvas.getWidth(), this.canvas.getHeight(), rl);
        toIpInverse.transform(rl);
        this.toCamera.transform(rl);
        this.w = rl.x - lu.x;
        this.h = rl.y - lu.y;
        this.e = -rl.z;
        univ.getVworldToCameraInverse(this.toCameraInverse);
    }

    public void apply() {
        Transform3D t3d = new Transform3D();
        Vector3d transl = new Vector3d();
        this.univ.getZoomTG().getTransform(t3d);
        t3d.get(transl);
        transl.z += this.eye.z - this.oldEye.z;
        t3d.set(transl);
        this.univ.getZoomTG().setTransform(t3d);
        Transform3D tmp = new Transform3D();
        this.univ.getCenterTG().getTransform(t3d);
        this.univ.getTranslateTG().getTransform(tmp);
        t3d.mul(tmp);
        this.univ.getRotationTG().getTransform(tmp);
        t3d.mul(tmp);
        transl.set(this.eye.x - this.oldEye.x, this.eye.y - this.oldEye.y, 0.0);
        tmp.set(transl);
        t3d.mul(tmp);
        this.univ.getRotationTG().getTransform(tmp);
        t3d.mulInverse(tmp);
        this.univ.getTranslateTG().getTransform(tmp);
        t3d.mulInverse(tmp);
        this.univ.getCenterTG().setTransform(t3d);
    }

    public void addCenterOf(Iterable<Content> contents) {
        Point3d center = new Point3d();
        Point3d tmp = new Point3d();
        int counter = 0;
        for (Content c : contents) {
            Transform3D localToVworld = new Transform3D();
            c.getContent().getLocalToVworld(localToVworld);
            c.getContent().getMin((Tuple3d)tmp);
            center.add((Tuple3d)tmp);
            c.getContent().getMax((Tuple3d)tmp);
            center.add((Tuple3d)tmp);
            counter += 2;
        }
        center.x /= (double)counter;
        center.y /= (double)counter;
        center.z /= (double)counter;
        this.add(center);
    }

    public void add(Content c) {
        Transform3D localToVworld = new Transform3D();
        c.getContent().getLocalToVworld(localToVworld);
        Point3d min = new Point3d();
        c.getContent().getMin((Tuple3d)min);
        Point3d max = new Point3d();
        c.getContent().getMax((Tuple3d)max);
        Point3d tmp = new Point3d();
        this.add(localToVworld, new Point3d(min.x, min.y, min.z));
        this.add(localToVworld, new Point3d(max.x, min.y, min.z));
        this.add(localToVworld, new Point3d(min.x, max.y, min.z));
        this.add(localToVworld, new Point3d(max.x, max.y, min.z));
        this.add(localToVworld, new Point3d(min.x, min.y, max.z));
        this.add(localToVworld, new Point3d(max.x, min.y, max.z));
        this.add(localToVworld, new Point3d(min.x, max.y, max.z));
        this.add(localToVworld, new Point3d(max.x, max.y, max.z));
    }

    public void add(Transform3D localToVworld, Point3d local) {
        localToVworld.transform(local);
        this.add(local);
    }

    public void add(Point3d p) {
        this.adjuster.add(p);
    }

    private final class VerticalAdjuster
    implements Adjuster {
        private VerticalAdjuster() {
        }

        @Override
        public void add(Point3d point) {
            double m2;
            double s2;
            Point3d p = new Point3d(point);
            ViewAdjuster.this.toCamera.transform(p);
            if (ViewAdjuster.this.firstPoint) {
                ViewAdjuster.this.eye.set(((ViewAdjuster)ViewAdjuster.this).eye.x, p.y, p.z);
                ViewAdjuster.this.firstPoint = false;
                return;
            }
            double s1 = (p.y - ((ViewAdjuster)ViewAdjuster.this).eye.y) / ViewAdjuster.this.h;
            double m1 = s1 - (s2 = (((ViewAdjuster)ViewAdjuster.this).eye.z - p.z) / (2.0 * ViewAdjuster.this.e));
            if (m1 > (m2 = -s1 - s2)) {
                if (m1 > 0.0) {
                    ((ViewAdjuster)ViewAdjuster.this).eye.y += m1 * ViewAdjuster.this.h / 2.0;
                    ((ViewAdjuster)ViewAdjuster.this).eye.z += m1 * ViewAdjuster.this.e;
                }
            } else if (m2 > 0.0) {
                ((ViewAdjuster)ViewAdjuster.this).eye.y -= m2 * ViewAdjuster.this.h / 2.0;
                ((ViewAdjuster)ViewAdjuster.this).eye.z += m2 * ViewAdjuster.this.e;
            }
        }
    }

    private final class HorizontalAdjuster
    implements Adjuster {
        private HorizontalAdjuster() {
        }

        @Override
        public void add(Point3d point) {
            double m2;
            double s2;
            Point3d p = new Point3d(point);
            ViewAdjuster.this.toCamera.transform(p);
            if (ViewAdjuster.this.firstPoint) {
                ViewAdjuster.this.eye.set(p.x, ((ViewAdjuster)ViewAdjuster.this).eye.y, p.z);
                ViewAdjuster.this.firstPoint = false;
                return;
            }
            double s1 = (p.x - ((ViewAdjuster)ViewAdjuster.this).eye.x) / ViewAdjuster.this.w;
            double m1 = s1 - (s2 = (((ViewAdjuster)ViewAdjuster.this).eye.z - p.z) / (2.0 * ViewAdjuster.this.e));
            if (m1 > (m2 = -s1 - s2)) {
                if (m1 > 0.0) {
                    ((ViewAdjuster)ViewAdjuster.this).eye.x += m1 * ViewAdjuster.this.w / 2.0;
                    ((ViewAdjuster)ViewAdjuster.this).eye.z += m1 * ViewAdjuster.this.e;
                }
            } else if (m2 > 0.0) {
                ((ViewAdjuster)ViewAdjuster.this).eye.x -= m2 * ViewAdjuster.this.w / 2.0;
                ((ViewAdjuster)ViewAdjuster.this).eye.z += m2 * ViewAdjuster.this.e;
            }
        }
    }

    private final class BothAdjuster
    implements Adjuster {
        private final Adjuster hAdj;
        private final Adjuster vAdj;

        public BothAdjuster() {
            this.hAdj = new HorizontalAdjuster();
            this.vAdj = new VerticalAdjuster();
        }

        @Override
        public void add(Point3d point) {
            Point3d p = new Point3d(point);
            ViewAdjuster.this.toCamera.transform(p);
            if (ViewAdjuster.this.firstPoint) {
                ViewAdjuster.this.eye.set(p.x, p.y, p.z);
                ViewAdjuster.this.firstPoint = false;
                return;
            }
            this.vAdj.add(point);
            this.hAdj.add(point);
        }
    }

    private static interface Adjuster {
        public void add(Point3d var1);
    }
}

