/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.UniverseListener;
import java.util.HashMap;
import org.scijava.java3d.View;
import org.scijava.java3d.utils.universe.MultiTransformGroup;

public class UniverseSynchronizer {
    private final HashMap<Image3DUniverse, UniverseListener> universes = new HashMap();
    private static final DefaultUniverse.GlobalTransform old = new DefaultUniverse.GlobalTransform();

    void addUniverse(final Image3DUniverse u) {
        UniverseAdapter l = new UniverseAdapter(){

            @Override
            public void transformationUpdated(View view) {
                DefaultUniverse.GlobalTransform xform = new DefaultUniverse.GlobalTransform();
                u.getGlobalTransform(xform);
                for (Image3DUniverse o : UniverseSynchronizer.this.universes.keySet()) {
                    if (o.equals(u)) continue;
                    UniverseSynchronizer.setGlobalTransform(o, xform);
                }
            }

            @Override
            public void universeClosed() {
                UniverseSynchronizer.this.removeUniverse(u);
            }
        };
        u.addUniverseListener(l);
        this.universes.put(u, l);
    }

    void removeUniverse(Image3DUniverse u) {
        if (!this.universes.containsKey(u)) {
            return;
        }
        UniverseListener l = this.universes.get(u);
        u.removeUniverseListener(l);
        this.universes.remove(u);
    }

    private static final void setGlobalTransform(Image3DUniverse u, DefaultUniverse.GlobalTransform transform) {
        u.getGlobalTransform(old);
        if (UniverseSynchronizer.equals(old, transform)) {
            return;
        }
        MultiTransformGroup group = u.getViewingPlatform().getMultiTransformGroup();
        int num = group.getNumTransforms();
        for (int i = 0; i < num; ++i) {
            group.getTransformGroup(i).setTransform(transform.transforms[i]);
        }
        u.fireTransformationUpdated();
    }

    private static final boolean equals(DefaultUniverse.GlobalTransform t1, DefaultUniverse.GlobalTransform t2) {
        int num = t1.transforms.length;
        for (int i = 0; i < num; ++i) {
            if (t1.transforms[i].equals(t2.transforms[i])) continue;
            return false;
        }
        return true;
    }

    private class UniverseAdapter
    implements UniverseListener {
        private UniverseAdapter() {
        }

        @Override
        public void transformationStarted(View view) {
        }

        @Override
        public void transformationUpdated(View view) {
        }

        @Override
        public void transformationFinished(View view) {
        }

        @Override
        public void contentAdded(Content c) {
        }

        @Override
        public void contentRemoved(Content c) {
        }

        @Override
        public void contentChanged(Content c) {
        }

        @Override
        public void contentSelected(Content c) {
        }

        @Override
        public void canvasResized() {
        }

        @Override
        public void universeClosed() {
        }
    }
}

