/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import customnode.CustomMultiMesh;
import customnode.MeshLoader;
import customnode.WavefrontExporter;
import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij3d.Content;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Color3f;
import orthoslice.OrthoGroup;
import surfaceplot.SurfacePlotGroup;

public class SaveSession {
    public static void saveView(Image3DUniverse univ, String path) throws IOException {
        SaveSession sase = new SaveSession();
        PrintWriter out = new PrintWriter(new FileWriter(path));
        sase.saveView(out, univ);
        out.close();
    }

    public static void loadView(Image3DUniverse univ, String path) throws IOException {
        SaveSession sase = new SaveSession();
        BufferedReader in = new BufferedReader(new FileReader(path));
        HashMap<String, String> view = sase.readView(in, univ);
        in.close();
        sase.apply(view, univ);
    }

    public static void saveScene(Image3DUniverse univ, String path) throws IOException {
        SaveSession sase = new SaveSession();
        if (!sase.ensureAllSaved(univ.getContents())) {
            IJ.error((String)"Could not save session");
            return;
        }
        PrintWriter out = new PrintWriter(new FileWriter(path));
        sase.saveView(out, univ);
        for (Object c : univ.getContents()) {
            sase.saveContent(out, (Content)c);
        }
        out.close();
    }

    public static void loadScene(Image3DUniverse univ, String path) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(path));
        SaveSession sase = new SaveSession();
        univ.removeAllContents();
        HashMap<String, String> view = sase.readView(in, univ);
        boolean b = univ.getAutoAdjustView();
        Content c = null;
        while ((c = sase.readContent(in)) != null) {
            c.setPointListDialog(univ.getPointListDialog());
            univ.addContent(c);
        }
        in.close();
        sase.apply(view, univ);
    }

    boolean ensureAllSaved(Collection<Content> contents) throws IOException {
        StringBuilder sb;
        HashMap custommeshes = new HashMap();
        ArrayList<String> unsavedImages = new ArrayList<String>();
        for (Content content : contents) {
            for (ContentInstant contentInstant : content.getInstants().values()) {
                int t = contentInstant.getType();
                if (t != 5) {
                    FileInfo fi = contentInstant.getImage().getOriginalFileInfo();
                    if (fi != null && !contentInstant.image.changes) continue;
                    unsavedImages.add(contentInstant.image.getTitle());
                    continue;
                }
                CustomMeshNode cn = (CustomMeshNode)contentInstant.getContent();
                ArrayList<CustomMesh> meshes = SaveSession.getMeshes(cn);
                int i = -1;
                for (CustomMesh cm : meshes) {
                    String name;
                    ++i;
                    String file = cm.getFile();
                    boolean changed = file == null || cm.hasChanged();
                    if (!changed) continue;
                    if (!custommeshes.containsKey(file)) {
                        custommeshes.put(file, new ArrayList());
                    }
                    if ((name = cm.getName()) == null) {
                        name = contentInstant.getName();
                    }
                    if (meshes.size() > 1) {
                        name = name + "-multimesh" + i;
                    }
                    ((ArrayList)custommeshes.get(file)).add(new CMesh(cm, name));
                }
            }
        }
        if (!unsavedImages.isEmpty()) {
            sb = new StringBuilder();
            sb.append("Error.\n").append("The following images have unsaved ").append("changes:\n  \n");
            for (String s : unsavedImages) {
                sb.append("  ").append(s).append("\n");
            }
            sb.append("  \nPlease save them separately ").append("before calling 'Save session' again");
            IJ.error((String)sb.toString());
            return false;
        }
        if (custommeshes.containsKey(null)) {
            ArrayList meshes = (ArrayList)custommeshes.get(null);
            if (meshes != null && !SaveSession.saveObj(meshes)) {
                IJ.error((String)"Error saving session");
                return false;
            }
            custommeshes.remove(null);
        }
        if (custommeshes.isEmpty()) {
            return true;
        }
        sb = new StringBuilder();
        sb.append("The following mesh(es) were loaded from file \n");
        sb.append("but changed. Save them to their original\n");
        sb.append("file(s)?\n  \n");
        for (String file : custommeshes.keySet()) {
            for (CMesh m : (ArrayList)custommeshes.get(file)) {
                sb.append("  " + m.name + "\n");
            }
        }
        sb.append("  \n");
        GenericDialog genericDialog = new GenericDialog("");
        genericDialog.addMessage(sb.toString());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        for (String string : custommeshes.keySet()) {
            ArrayList meshes = (ArrayList)custommeshes.get(string);
            if (meshes == null || SaveSession.updateObj(meshes, string)) continue;
            return false;
        }
        return true;
    }

    static boolean updateObj(ArrayList<CMesh> meshes, String path) throws IOException {
        Map<String, CustomMesh> prev = MeshLoader.load(path);
        for (CMesh m : meshes) {
            prev.put(m.name, m.mesh);
        }
        try {
            WavefrontExporter.save(prev, path);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            IJ.error((String)e.getMessage());
            return false;
        }
    }

    static boolean saveObj(ArrayList<CMesh> meshes) {
        StringBuilder sb = new StringBuilder();
        sb.append("The following surfaces are not saved:\n");
        for (CMesh m : meshes) {
            sb.append("  " + m.name + "\n");
        }
        sb.append("Select a path below to save them");
        String path = SaveSession.showPathDialog("Save meshes", sb.toString());
        if (path == null) {
            return false;
        }
        HashMap<String, CustomMesh> m2w = new HashMap<String, CustomMesh>();
        for (CMesh m : meshes) {
            m2w.put(m.name, m.mesh);
        }
        try {
            WavefrontExporter.save(m2w, path);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            IJ.error((String)e.getMessage());
            return false;
        }
    }

    static String showPathDialog(String title, String msg) {
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        Panel p = new Panel(new FlowLayout());
        final TextField tf = new TextField(30);
        p.add(tf);
        Button b = new Button("...");
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveDialog sd = new SaveDialog("Select path", "untitled", ".obj");
                String dir = sd.getDirectory();
                String file = sd.getFileName();
                File f = new File(dir, file);
                tf.setText(f.getAbsolutePath());
            }
        });
        gd.addPanel(p);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        return new File(tf.getText()).getAbsolutePath();
    }

    void saveView(PrintWriter out, Image3DUniverse univ) throws IOException {
        out.println("BeginView");
        Transform3D t3d = new Transform3D();
        univ.getCenterTG().getTransform(t3d);
        out.println("center = " + SaveSession.toString(t3d));
        univ.getTranslateTG().getTransform(t3d);
        out.println("translate = " + SaveSession.toString(t3d));
        univ.getRotationTG().getTransform(t3d);
        out.println("rotate = " + SaveSession.toString(t3d));
        univ.getZoomTG().getTransform(t3d);
        out.println("zoom = " + SaveSession.toString(t3d));
        univ.getAnimationTG().getTransform(t3d);
        out.println("animate = " + SaveSession.toString(t3d));
        out.println("EndView");
    }

    HashMap<String, String> readView(BufferedReader in, Image3DUniverse univ) throws IOException {
        String line;
        boolean foundNext = false;
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("BeginView")) continue;
            foundNext = true;
            break;
        }
        if (!foundNext) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        while ((line = in.readLine()) != null && !line.startsWith("EndView")) {
            if (line.startsWith("#")) continue;
            String[] keyval = line.split("=");
            props.put(keyval[0].trim(), keyval[1].trim());
        }
        return props;
    }

    public void apply(HashMap<String, String> props, Image3DUniverse univ) {
        String tmp = props.get("center");
        if (tmp != null) {
            univ.getCenterTG().setTransform(SaveSession.t(tmp));
        }
        if ((tmp = props.get("translate")) != null) {
            univ.getTranslateTG().setTransform(SaveSession.t(tmp));
        }
        if ((tmp = props.get("rotate")) != null) {
            univ.getRotationTG().setTransform(SaveSession.t(tmp));
        }
        if ((tmp = props.get("zoom")) != null) {
            univ.getZoomTG().setTransform(SaveSession.t(tmp));
        }
        if ((tmp = props.get("animate")) != null) {
            univ.getAnimationTG().setTransform(SaveSession.t(tmp));
        }
        univ.getViewPlatformTransformer().updateFrontBackClip();
    }

    void saveContent(PrintWriter out, Content c) {
        out.println("BeginContent");
        out.println("name = " + c.getName());
        for (ContentInstant ci : c.getInstants().values()) {
            this.saveContentInstant(out, ci);
        }
        out.println("EndContent");
    }

    void saveContentInstant(PrintWriter out, ContentInstant c) {
        String col = c.color == null ? null : Integer.toString(c.color.get().getRGB());
        String chan = c.channels[0] + "%%%" + c.channels[1] + "%%%" + c.channels[2];
        Transform3D t = new Transform3D();
        c.getLocalRotate(t);
        String rot = SaveSession.toString(t);
        c.getLocalTranslate(t);
        String trans = SaveSession.toString(t);
        out.println("BeginContentInstant");
        out.println("name = " + c.getName());
        if (col != null) {
            out.println("color = " + col);
        }
        out.println("timepoint = " + c.timepoint);
        out.println("channels = " + chan);
        out.println("transparency = " + c.transparency);
        out.println("threshold = " + c.threshold);
        out.println("resampling = " + c.resamplingF);
        out.println("type = " + c.type);
        out.println("locked = " + c.isLocked());
        out.println("shaded = " + c.shaded);
        out.println("visible = " + c.isVisible());
        out.println("coordVisible = " + c.hasCoord());
        out.println("plVisible = " + c.isPLVisible());
        out.println("rotation = " + rot);
        out.println("translation = " + trans);
        if (c.image != null) {
            out.println("imgfile = " + SaveSession.getImageFile(c));
        }
        int type = c.getType();
        ContentNode cn = c.getContent();
        if (type == 3) {
            out.println("surfplt = " + ((SurfacePlotGroup)cn).getSlice());
        } else if (type == 1) {
            out.println("ortho = " + SaveSession.getOrthoString(cn));
        } else if (type == 5) {
            out.println("surffiles = " + SaveSession.getMeshString(c));
        }
        out.println("EndContentInstant");
    }

    public Content readContent(BufferedReader in) throws IOException {
        String line;
        String name = null;
        boolean foundNext = false;
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("BeginContent")) continue;
            foundNext = true;
            break;
        }
        if (!foundNext) {
            return null;
        }
        while ((line = in.readLine()) != null) {
            if (!line.startsWith("name")) continue;
            name = line.split("=")[1].trim();
            break;
        }
        TreeMap<Integer, ContentInstant> cis = new TreeMap<Integer, ContentInstant>();
        ContentInstant ci = null;
        while ((ci = this.readContentInstant(in)) != null) {
            cis.put(ci.timepoint, ci);
        }
        if (name == null) {
            throw new RuntimeException("no name for content");
        }
        return new Content(name, cis);
    }

    public ContentInstant readContentInstant(BufferedReader in) throws IOException {
        int type;
        String[] sp;
        String line;
        boolean foundNext = false;
        while ((line = in.readLine()) != null && !line.startsWith("EndContent")) {
            if (!line.startsWith("BeginContentInstant")) continue;
            foundNext = true;
            break;
        }
        if (!foundNext) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        while ((line = in.readLine()) != null && !line.startsWith("EndContentInstant")) {
            if (line.startsWith("#")) continue;
            String[] keyval = line.split("=");
            props.put(keyval[0].trim(), keyval[1].trim());
        }
        ContentInstant c = new ContentInstant((String)props.get("name"));
        String tmp = (String)props.get("channels");
        if (tmp != null) {
            sp = tmp.split("%%%");
            c.channels = new boolean[]{SaveSession.b(sp[0]), SaveSession.b(sp[1]), SaveSession.b(sp[2])};
        }
        if ((tmp = (String)props.get("timepoint")) != null) {
            c.timepoint = SaveSession.i(tmp);
        }
        if ((tmp = (String)props.get("resampling")) != null) {
            c.resamplingF = SaveSession.i(tmp);
        }
        if ((tmp = (String)props.get("rotation")) != null) {
            c.getLocalRotate().setTransform(SaveSession.t(tmp));
        }
        if ((tmp = (String)props.get("translation")) != null) {
            c.getLocalTranslate().setTransform(SaveSession.t(tmp));
        }
        if ((type = SaveSession.i((String)props.get("type"))) != 5) {
            c.image = IJ.openImage((String)((String)props.get("imgfile")));
            if (c.image == null) {
                throw new RuntimeException("Cannot load image: " + (String)props.get("imgfile"));
            }
            c.displayAs(type);
            if (type == 3 && (tmp = (String)props.get("surfplt")) != null) {
                ((SurfacePlotGroup)c.getContent()).setSlice(SaveSession.i(tmp));
            } else if (type == 1 && (tmp = (String)props.get("ortho")) != null) {
                OrthoGroup og = (OrthoGroup)c.getContent();
                sp = tmp.split("%%%");
                int slice = SaveSession.i(sp[0]);
                if (slice == -1) {
                    og.setVisible(0, false);
                } else {
                    og.setSlice(0, slice);
                }
                slice = SaveSession.i(sp[1]);
                if (slice == -1) {
                    og.setVisible(1, false);
                } else {
                    og.setSlice(1, slice);
                }
                slice = SaveSession.i(sp[2]);
                if (slice == -1) {
                    og.setVisible(2, false);
                } else {
                    og.setSlice(2, slice);
                }
            }
        } else {
            tmp = (String)props.get("surffiles");
            c.display(this.createCustomNode(tmp));
        }
        tmp = (String)props.get("color");
        if (tmp != null) {
            c.setColor(new Color3f(new Color(SaveSession.i(tmp))));
        }
        if ((tmp = (String)props.get("transparency")) != null) {
            c.setTransparency(SaveSession.f(tmp));
        }
        if ((tmp = (String)props.get("threshold")) != null) {
            c.setThreshold(SaveSession.i(tmp));
        }
        if ((tmp = (String)props.get("shaded")) != null) {
            c.setShaded(SaveSession.b(tmp));
        }
        if ((tmp = (String)props.get("visible")) != null) {
            c.setVisible(SaveSession.b(tmp));
        }
        if ((tmp = (String)props.get("coordVisible")) != null) {
            c.showCoordinateSystem(SaveSession.b(tmp));
        }
        if ((tmp = (String)props.get("plVisible")) != null) {
            c.showPointList(SaveSession.b(tmp));
        }
        if ((tmp = (String)props.get("locked")) != null) {
            c.setLocked(SaveSession.b(tmp));
        }
        return c;
    }

    private CustomMeshNode createCustomNode(String s) {
        String[] sp = s.split("%%%");
        if (sp.length == 2) {
            Map<String, CustomMesh> meshes = MeshLoader.load(sp[0]);
            if (meshes == null) {
                IJ.error((String)("Could not load " + sp[0]));
                return null;
            }
            return new CustomMeshNode(meshes.get(sp[1]));
        }
        HashMap file2name = new HashMap();
        for (int i = 0; i < sp.length; i += 2) {
            if (!file2name.containsKey(sp[i])) {
                file2name.put(sp[i], new ArrayList());
            }
            ((ArrayList)file2name.get(sp[i])).add(sp[i + 1]);
        }
        ArrayList<CustomMesh> cms = new ArrayList<CustomMesh>();
        for (String file : file2name.keySet()) {
            ArrayList names = (ArrayList)file2name.get(file);
            Map<String, CustomMesh> meshes = MeshLoader.load(file);
            if (meshes == null) {
                IJ.error((String)("Could not load " + file));
                continue;
            }
            for (String name : names) {
                cms.add(meshes.get(name));
            }
        }
        return new CustomMultiMesh(cms);
    }

    private static final int i(String s) {
        return Integer.parseInt(s);
    }

    private static final boolean b(String s) {
        return Boolean.parseBoolean(s);
    }

    private static final float f(String s) {
        return Float.parseFloat(s);
    }

    private static final Transform3D t(String s) {
        String[] sp = s.split(" ");
        float[] f = new float[16];
        for (int i = 0; i < sp.length; ++i) {
            f[i] = SaveSession.f(sp[i]);
        }
        return new Transform3D(f);
    }

    private static final String toString(Transform3D t3d) {
        float[] xf = new float[16];
        t3d.get(xf);
        String ret = "";
        for (int i = 0; i < 16; ++i) {
            ret = ret + " " + xf[i];
        }
        return ret;
    }

    private static ArrayList<CustomMesh> getMeshes(CustomMeshNode cn) {
        ArrayList<CustomMesh> meshes = new ArrayList<CustomMesh>();
        if (cn instanceof CustomMultiMesh) {
            CustomMultiMesh cmm = (CustomMultiMesh)cn;
            for (int i = 0; i < cmm.size(); ++i) {
                meshes.add(cmm.getMesh(i));
            }
        } else {
            meshes.add(cn.getMesh());
        }
        return meshes;
    }

    private static final String getMeshString(ContentInstant c) {
        ArrayList<CustomMesh> meshes = SaveSession.getMeshes((CustomMeshNode)c.getContent());
        String ret = "";
        for (CustomMesh cm : meshes) {
            String name = cm.getName();
            if (name == null) {
                name = c.getName();
            }
            name.replaceAll(" ", "_").replaceAll("#", "--");
            ret = ret + "%%%" + cm.getFile() + "%%%" + name;
        }
        return ret.substring(3, ret.length());
    }

    private static final String getOrthoString(ContentNode c) {
        OrthoGroup og = (OrthoGroup)c;
        int xSlide = og.isVisible(0) ? og.getSlice(0) : -1;
        int ySlide = og.isVisible(1) ? og.getSlice(1) : -1;
        int zSlide = og.isVisible(2) ? og.getSlice(2) : -1;
        return xSlide + "%%%" + ySlide + "%%%" + zSlide;
    }

    private static final String getImageFile(ContentInstant c) {
        if (c.image == null) {
            return null;
        }
        FileInfo fi = c.image.getOriginalFileInfo();
        if (fi == null || c.image.changes) {
            throw new RuntimeException("Image not saved");
        }
        return fi.directory + fi.fileName;
    }

    private class CMesh {
        private final CustomMesh mesh;
        private final String name;

        CMesh(CustomMesh mesh, String name) {
            this.mesh = mesh;
            this.name = name;
        }
    }
}

