/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;
import ij3d.Vector3;
import ij3d.VectorString3D;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class Pipe {
    public static List<Point3f> generateTriangles(double[][][] all_points, double scale) {
        return Pipe.generateTriangles(all_points, scale, null, null);
    }

    public static List<Point3f> generateTriangles(double[][][] all_points, double scale, List<Color3f> pointColorList, List<Color3f> vertexColorList) {
        boolean outputColors;
        boolean bl = outputColors = pointColorList != null && vertexColorList != null;
        if (outputColors && vertexColorList.size() > 0) {
            throw new RuntimeException("vertexColorList in Pipe.generateTriangles() is only for output: should be empty");
        }
        int n = all_points.length;
        int parallels = all_points[0].length - 1;
        ArrayList<Point3f> list = new ArrayList<Point3f>();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < parallels; ++j) {
                list.add(new Point3f((float)(all_points[i][j][0] * scale), (float)(all_points[i][j][1] * scale), (float)(all_points[i][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i][j + 1][0] * scale), (float)(all_points[i][j + 1][1] * scale), (float)(all_points[i][j + 1][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j][0] * scale), (float)(all_points[i + 1][j][1] * scale), (float)(all_points[i + 1][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j][0] * scale), (float)(all_points[i + 1][j][1] * scale), (float)(all_points[i + 1][j][2] * scale)));
                list.add(new Point3f((float)(all_points[i][j + 1][0] * scale), (float)(all_points[i][j + 1][1] * scale), (float)(all_points[i][j + 1][2] * scale)));
                list.add(new Point3f((float)(all_points[i + 1][j + 1][0] * scale), (float)(all_points[i + 1][j + 1][1] * scale), (float)(all_points[i + 1][j + 1][2] * scale)));
                if (!outputColors) continue;
                vertexColorList.add(pointColorList.get(i));
                vertexColorList.add(pointColorList.get(i));
                vertexColorList.add(pointColorList.get(i + 1));
                vertexColorList.add(pointColorList.get(i + 1));
                vertexColorList.add(pointColorList.get(i));
                vertexColorList.add(pointColorList.get(i + 1));
            }
        }
        return list;
    }

    public static double[][][] makeTube(double[] px, double[] py, double[] pz, double[] p_width_i, int resample, int parallels, boolean do_resample, Color3f flatColor, ImagePlus colorImage, List<Color3f> outputColors) {
        boolean colorsSpecified;
        boolean bl = colorsSpecified = flatColor != null || colorImage != null;
        if (colorsSpecified) {
            if (outputColors == null) {
                throw new RuntimeException("If you specify flatColor or colorImage in a call to makeTube(), then outputColors must be non-null");
            }
            if (outputColors.size() > 0) {
                throw new RuntimeException("The outputColors list in makeTube should be empty; it's for output, not input");
            }
        }
        int n = px.length;
        assert (n >= 2);
        if (do_resample) {
            try {
                VectorString3D vs = new VectorString3D(px, py, pz);
                vs.addDependent(p_width_i);
                vs.resample(vs.getAverageDelta() * (double)resample);
                px = vs.getPoints(0);
                py = vs.getPoints(1);
                pz = vs.getPoints(2);
                p_width_i = vs.getDependent(0);
                n = vs.length();
            }
            catch (Exception e) {
                IJ.error((String)("" + e));
            }
            assert (n >= 2);
        }
        if (colorsSpecified) {
            Color3f[] finalColors = Pipe.getPointColors(px, py, pz, flatColor, colorImage);
            outputColors.add(finalColors[0]);
            for (int i = 0; i < n; ++i) {
                outputColors.add(finalColors[i]);
            }
            outputColors.add(finalColors[n - 1]);
        }
        double[][][] all_points = new double[n + 2][parallels + 1][3];
        boolean extra = true;
        for (int cap = 0; cap < parallels + 1; ++cap) {
            all_points[0][cap][0] = px[0];
            all_points[0][cap][1] = py[0];
            all_points[0][cap][2] = pz[0];
            all_points[all_points.length - 1][cap][0] = px[n - 1];
            all_points[all_points.length - 1][cap][1] = py[n - 1];
            all_points[all_points.length - 1][cap][2] = pz[n - 1];
        }
        double angle = Math.PI * 2 / (double)parallels;
        Vector3 betweenPoints = new Vector3();
        Vector3 lastFirstSpoke = null;
        Vector3[] circle = new Vector3[parallels + 1];
        Vector3 intersection = new Vector3();
        Vector3 crossForOffset = new Vector3();
        double[] sinn = new double[parallels];
        double[] cosn = new double[parallels];
        for (int q = 0; q < parallels; ++q) {
            sinn[q] = Math.sin(angle * (double)q);
            cosn[q] = Math.cos(angle * (double)q);
        }
        double epsilon = 1.0E-10;
        Vector3 unit_y = new Vector3(0.0, 1.0, 0.0);
        Vector3 unit_z = new Vector3(0.0, 0.0, 1.0);
        for (int i = 0; i < n; ++i) {
            int offset;
            if (i < n - 1) {
                betweenPoints.set(px[i + 1] - px[i], py[i + 1] - py[i], pz[i + 1] - pz[i]);
            }
            if (betweenPoints.isZero(1.0E-10)) {
                throw new RuntimeException("Two points on the path were the same");
            }
            if (lastFirstSpoke == null) {
                lastFirstSpoke = new Vector3();
                betweenPoints.crossWith(unit_z, lastFirstSpoke);
                if (lastFirstSpoke.isZero(1.0E-10)) {
                    betweenPoints.crossWith(unit_y, lastFirstSpoke);
                }
            }
            lastFirstSpoke.normalize(lastFirstSpoke);
            int t1_a = Math.max(0, i - 1);
            int t1_b = Math.min(n - 1, i + 1);
            int t2_a = Math.min(n - 2, i);
            int t2_b = Math.min(n - 1, i + 2);
            Vector3 tangent1 = new Vector3(px[t1_b] - px[t1_a], py[t1_b] - py[t1_a], pz[t1_b] - pz[t1_a]);
            Vector3 tangent2 = new Vector3(px[t2_b] - px[t2_a], py[t2_b] - py[t2_a], pz[t2_b] - pz[t2_a]);
            tangent1.crossWith(tangent2, intersection);
            if (intersection.isZero(1.0E-10)) {
                offset = 0;
                intersection.setFrom(lastFirstSpoke);
            } else {
                intersection.normalize(intersection);
                double offsetAngle = Math.acos(intersection.dotWith(lastFirstSpoke));
                intersection.crossWith(lastFirstSpoke, crossForOffset);
                if (crossForOffset.dotWith(tangent1) < 0.0) {
                    offsetAngle = Math.PI * 2 - offsetAngle;
                }
                offset = (int)Math.round(offsetAngle / angle);
                offset %= parallels;
            }
            intersection.scale(p_width_i[i], intersection);
            for (int q = 0; q < parallels; ++q) {
                int a = (q + offset) % parallels;
                circle[q] = Pipe.rotate_v_around_axis(intersection, tangent1, sinn[a], cosn[a]);
            }
            circle[parallels] = circle[0];
            lastFirstSpoke.setFrom(circle[0]);
            for (int j = 0; j < parallels + 1; ++j) {
                all_points[i + 1][j][0] = px[i] + circle[j].x;
                all_points[i + 1][j][1] = py[i] + circle[j].y;
                all_points[i + 1][j][2] = pz[i] + circle[j].z;
            }
        }
        return all_points;
    }

    private static Vector3 rotate_v_around_axis(Vector3 v, Vector3 axis, double sin, double cos) {
        Vector3 result = new Vector3();
        Vector3 r = axis.normalize(axis);
        result.set((cos + (1.0 - cos) * r.x * r.x) * v.x + ((1.0 - cos) * r.x * r.y - r.z * sin) * v.y + ((1.0 - cos) * r.x * r.z + r.y * sin) * v.z, ((1.0 - cos) * r.x * r.y + r.z * sin) * v.x + (cos + (1.0 - cos) * r.y * r.y) * v.y + ((1.0 - cos) * r.y * r.z - r.x * sin) * v.z, ((1.0 - cos) * r.y * r.z - r.y * sin) * v.x + ((1.0 - cos) * r.y * r.z + r.x * sin) * v.y + (cos + (1.0 - cos) * r.z * r.z) * v.z);
        return result;
    }

    public static final int enrangeInteger(float value, int mininum, int maximum) {
        return Math.max(mininum, Math.min(maximum, Math.round(value)));
    }

    public static final int enrangeInteger(double value, int mininum, int maximum) {
        return Math.max(mininum, Math.min(maximum, (int)Math.round(value)));
    }

    public static Color3f[] getPointColors(double[] x_points, double[] y_points, double[] z_points, Color3f flatColor, ImagePlus colorImage) {
        int n = x_points.length;
        Object[] result = new Color3f[x_points.length];
        Arrays.fill(result, flatColor);
        if (colorImage != null) {
            ImageStack stack = colorImage.getStack();
            int width = colorImage.getWidth();
            int height = colorImage.getHeight();
            int depth = colorImage.getStackSize();
            int type = colorImage.getType();
            double x_spacing = 1.0;
            double y_spacing = 1.0;
            double z_spacing = 1.0;
            Calibration calibration = colorImage.getCalibration();
            if (calibration != null) {
                x_spacing = calibration.pixelWidth;
                y_spacing = calibration.pixelHeight;
                z_spacing = calibration.pixelDepth;
            }
            ColorModel cm = colorImage.getProcessor().getCurrentColorModel();
            byte[] reds = null;
            byte[] greens = null;
            byte[] blues = null;
            int mapSize = -1;
            if (cm != null && cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                mapSize = icm.getMapSize();
                reds = new byte[mapSize];
                greens = new byte[mapSize];
                blues = new byte[mapSize];
                icm.getReds(reds);
                icm.getGreens(greens);
                icm.getBlues(blues);
            }
            block7: for (int i = 0; i < n; ++i) {
                int x = (int)Math.round(x_points[i] / x_spacing);
                int y = (int)Math.round(y_points[i] / y_spacing);
                int z = (int)Math.round(z_points[i] / z_spacing);
                if (x < 0) {
                    x = 0;
                } else if (x >= width) {
                    x = width - 1;
                }
                if (y < 0) {
                    y = 0;
                } else if (y >= height) {
                    y = height - 1;
                }
                if (z < 0) {
                    z = 0;
                } else if (z >= depth) {
                    z = depth - 1;
                }
                switch (type) {
                    case 4: {
                        ColorProcessor cp = (ColorProcessor)stack.getProcessor(z + 1);
                        Color c = cp.getColor(x, y);
                        result[i] = new Color3f(c);
                        continue block7;
                    }
                    case 0: {
                        ByteProcessor bp = (ByteProcessor)stack.getProcessor(z + 1);
                        int v = bp.getPixel(x, y);
                        if (cm == null) {
                            float fv = (float)v / 255.0f;
                            result[i] = new Color3f(fv, fv, fv);
                            continue block7;
                        }
                        result[i] = new Color3f((float)(reds[v] & 0xFF) / 255.0f, (float)(greens[v] & 0xFF) / 255.0f, (float)(blues[v] & 0xFF) / 255.0f);
                        continue block7;
                    }
                    case 3: {
                        ByteProcessor bp = (ByteProcessor)stack.getProcessor(z + 1);
                        int v = bp.getPixel(x, y);
                        result[i] = new Color3f((float)(reds[v] & 0xFF) / 255.0f, (float)(greens[v] & 0xFF) / 255.0f, (float)(blues[v] & 0xFF) / 255.0f);
                        continue block7;
                    }
                    case 1: {
                        ShortProcessor sp = (ShortProcessor)stack.getProcessor(z + 1);
                        int s = sp.getPixel(x, y);
                        int v = Pipe.enrangeInteger(((double)s - sp.getMin()) * 255.0 / (sp.getMax() - sp.getMin()), 0, 255);
                        result[i] = new Color3f((float)(reds[v] & 0xFF) / 255.0f, (float)(greens[v] & 0xFF) / 255.0f, (float)(blues[v] & 0xFF) / 255.0f);
                        continue block7;
                    }
                    case 2: {
                        FloatProcessor fp = (FloatProcessor)stack.getProcessor(z + 1);
                        float f = fp.getf(x, y);
                        int v = Pipe.enrangeInteger(((double)f - fp.getMin()) * 255.0 / (fp.getMax() - fp.getMin()), 0, 255);
                        result[i] = new Color3f((float)(reds[v] & 0xFF) / 255.0f, (float)(greens[v] & 0xFF) / 255.0f, (float)(blues[v] & 0xFF) / 255.0f);
                        continue block7;
                    }
                    default: {
                        throw new RuntimeException("colorImage type: " + type + " is not supported yet");
                    }
                }
            }
        }
        return result;
    }
}

