/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij3d.Content;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import ij3d.UniverseListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.scijava.java3d.View;

public class Image3DMenubar
extends JMenuBar
implements ActionListener,
ItemListener,
UniverseListener {
    private final Image3DUniverse univ;
    private final Executer executer;
    private JMenuItem open;
    private JMenuItem addContentFromImage;
    private JMenuItem saveView;
    private JMenuItem loadView;
    private JMenuItem saveSession;
    private JMenuItem loadSession;
    private JMenuItem importObj;
    private JMenuItem importStl;
    private JMenuItem color;
    private JMenuItem bgColor;
    private JCheckBoxMenuItem fullscreen;
    private JMenuItem channels;
    private JMenuItem luts;
    private JMenuItem transparency;
    private JMenuItem threshold;
    private JMenuItem delete;
    private JMenuItem properties;
    private JMenuItem resetView;
    private JMenuItem snapshot;
    private JMenuItem record360;
    private JMenuItem startRecord;
    private JMenuItem stopRecord;
    private JMenuItem startAnimation;
    private JMenuItem stopAnimation;
    private JMenuItem animationOptions;
    private JMenuItem light;
    private JMenuItem viewPreferences;
    private JMenuItem shortcuts;
    private JMenuItem close;
    private JMenuItem setTransform;
    private JMenuItem resetTransform;
    private JMenuItem applyTransform;
    private JMenuItem saveTransform;
    private JMenuItem exportTransformed;
    private JMenuItem exportObj;
    private JMenuItem exportDXF;
    private JMenuItem exportAsciiSTL;
    private JMenuItem exportBinarySTL;
    private JMenuItem exportU3D;
    private JMenuItem scalebar;
    private JMenuItem displayAsVolume;
    private JMenuItem displayAsOrtho;
    private JMenuItem displayAsMultiOrtho;
    private JMenuItem displayAsSurface;
    private JMenuItem displayAsSurfacePlot;
    private JMenuItem centerSelected;
    private JMenuItem centerOrigin;
    private JMenuItem centerUniverse;
    private JCheckBoxMenuItem sync;
    private JMenuItem fitViewToUniverse;
    private JMenuItem fitViewToContent;
    private JMenuItem regist;
    private JMenuItem pl_load;
    private JMenuItem pl_save;
    private JMenuItem pl_size;
    private JMenuItem pl_color;
    private JCheckBoxMenuItem pl_show;
    private JMenuItem j3dproperties;
    private JCheckBoxMenuItem coordinateSystem;
    private JCheckBoxMenuItem boundingBox;
    private JCheckBoxMenuItem allCoordinateSystems;
    private JCheckBoxMenuItem lock;
    private JCheckBoxMenuItem show;
    private JMenuItem viewposXY;
    private JMenuItem viewposXZ;
    private JMenuItem viewposYZ;
    private JMenuItem viewnegXY;
    private JMenuItem viewnegXZ;
    private JMenuItem viewnegYZ;
    private JMenuItem sphere;
    private JMenuItem box;
    private JMenuItem cone;
    private JMenuItem tube;
    private JMenu transformMenu;
    private final JMenu landmarksMenu;
    private final JMenu editMenu;
    private JMenu selectMenu;
    private final JMenu viewMenu;
    private final JMenu fileMenu;
    private final JMenu helpMenu;
    private final JMenu addMenu;

    public Image3DMenubar(Image3DUniverse univ) {
        this.univ = univ;
        this.executer = univ.getExecuter();
        univ.addUniverseListener(this);
        this.fileMenu = this.createFileMenu();
        this.add(this.fileMenu);
        this.editMenu = this.createEditMenu();
        this.add(this.editMenu);
        this.viewMenu = this.createViewMenu();
        this.add(this.viewMenu);
        this.addMenu = this.createAddMenu();
        this.add(this.addMenu);
        this.landmarksMenu = this.createLandmarkMenu();
        this.add(this.landmarksMenu);
        this.helpMenu = this.createHelpMenu();
        this.add(this.helpMenu);
        this.contentSelected(null);
    }

    public JMenu createFileMenu() {
        JMenu file = new JMenu("File");
        this.open = new JMenuItem("Open...");
        this.open.addActionListener(this);
        file.add(this.open);
        JMenu importt = new JMenu("Import surfaces");
        this.importObj = new JMenuItem("WaveFront");
        this.importObj.addActionListener(this);
        importt.add(this.importObj);
        this.importStl = new JMenuItem("STL");
        this.importStl.addActionListener(this);
        importt.add(this.importStl);
        file.add(importt);
        JMenu subMenu = new JMenu("Export surfaces");
        file.add(subMenu);
        this.exportObj = new JMenuItem("WaveFront");
        this.exportObj.addActionListener(this);
        subMenu.add(this.exportObj);
        this.exportDXF = new JMenuItem("DXF");
        this.exportDXF.addActionListener(this);
        subMenu.add(this.exportDXF);
        this.exportAsciiSTL = new JMenuItem("STL (ASCII)");
        this.exportAsciiSTL.addActionListener(this);
        subMenu.add(this.exportAsciiSTL);
        this.exportBinarySTL = new JMenuItem("STL (binary)");
        this.exportBinarySTL.addActionListener(this);
        subMenu.add(this.exportBinarySTL);
        this.exportU3D = new JMenuItem("U3D");
        this.exportU3D.addActionListener(this);
        subMenu.add(this.exportU3D);
        file.addSeparator();
        this.saveView = new JMenuItem("Save View");
        this.saveView.addActionListener(this);
        file.add(this.saveView);
        this.loadView = new JMenuItem("Load View");
        this.loadView.addActionListener(this);
        file.add(this.loadView);
        file.addSeparator();
        this.saveSession = new JMenuItem("Save Session");
        this.saveSession.addActionListener(this);
        file.add(this.saveSession);
        this.loadSession = new JMenuItem("Load Session");
        this.loadSession.addActionListener(this);
        file.add(this.loadSession);
        file.addSeparator();
        this.close = new JMenuItem("Quit");
        this.close.addActionListener(this);
        file.add(this.close);
        return file;
    }

    public JMenu createAddMenu() {
        JMenu add = new JMenu("Add");
        this.addContentFromImage = new JMenuItem("From image");
        this.addContentFromImage.addActionListener(this);
        add.add(this.addContentFromImage);
        add.addSeparator();
        this.sphere = new JMenuItem("Sphere");
        this.sphere.addActionListener(this);
        add.add(this.sphere);
        this.box = new JMenuItem("Box");
        this.box.addActionListener(this);
        add.add(this.box);
        this.cone = new JMenuItem("Cone");
        this.cone.addActionListener(this);
        add.add(this.cone);
        this.tube = new JMenuItem("Tube");
        this.tube.addActionListener(this);
        add.add(this.tube);
        return add;
    }

    public JMenu createEditMenu() {
        JMenu edit = new JMenu("Edit");
        edit.add(this.createDisplayAsSubMenu());
        this.selectMenu = this.createSelectMenu();
        edit.add(this.selectMenu);
        edit.addSeparator();
        this.luts = new JMenuItem("Transfer function");
        this.luts.addActionListener(this);
        edit.add(this.luts);
        this.channels = new JMenuItem("Change channels");
        this.channels.addActionListener(this);
        edit.add(this.channels);
        this.color = new JMenuItem("Change color");
        this.color.addActionListener(this);
        edit.add(this.color);
        this.transparency = new JMenuItem("Change transparency");
        this.transparency.addActionListener(this);
        edit.add(this.transparency);
        this.threshold = new JMenuItem("Adjust threshold");
        this.threshold.addActionListener(this);
        edit.add(this.threshold);
        edit.addSeparator();
        this.show = new JCheckBoxMenuItem("Show content");
        this.show.setState(true);
        this.show.addItemListener(this);
        edit.add(this.show);
        this.coordinateSystem = new JCheckBoxMenuItem("Show coordinate system", true);
        this.coordinateSystem.addItemListener(this);
        edit.add(this.coordinateSystem);
        this.boundingBox = new JCheckBoxMenuItem("Show bounding box", false);
        this.boundingBox.addItemListener(this);
        edit.add(this.boundingBox);
        this.allCoordinateSystems = new JCheckBoxMenuItem("Show all coordinate systems", true);
        this.allCoordinateSystems.addItemListener(this);
        edit.add(this.allCoordinateSystems);
        edit.addSeparator();
        this.delete = new JMenuItem("Delete");
        this.delete.setEnabled(false);
        this.delete.addActionListener(this);
        edit.add(this.delete);
        edit.addSeparator();
        this.properties = new JMenuItem("Object Properties");
        this.properties.addActionListener(this);
        edit.add(this.properties);
        edit.addSeparator();
        this.transformMenu = this.createTransformMenu();
        edit.add(this.transformMenu);
        edit.addSeparator();
        this.shortcuts = new JMenuItem("Keyboard shortcuts");
        this.shortcuts.addActionListener(this);
        edit.add(this.shortcuts);
        this.viewPreferences = new JMenuItem("View Preferences");
        this.viewPreferences.addActionListener(this);
        edit.add(this.viewPreferences);
        return edit;
    }

    private JMenu createLandmarkMenu() {
        JMenu pl = new JMenu("Landmarks");
        this.pl_load = new JMenuItem("Load Point List");
        this.pl_load.addActionListener(this);
        pl.add(this.pl_load);
        this.pl_save = new JMenuItem("Save Point List");
        this.pl_save.addActionListener(this);
        pl.add(this.pl_save);
        this.pl_show = new JCheckBoxMenuItem("Show Point List");
        this.pl_show.addItemListener(this);
        pl.add(this.pl_show);
        pl.addSeparator();
        this.pl_size = new JMenuItem("Point size");
        this.pl_size.addActionListener(this);
        pl.add(this.pl_size);
        this.pl_color = new JMenuItem("Point color");
        this.pl_color.addActionListener(this);
        pl.add(this.pl_color);
        pl.addSeparator();
        this.regist = new JMenuItem("Register");
        this.regist.addActionListener(this);
        pl.add(this.regist);
        return pl;
    }

    public JMenu createSelectMenu() {
        return new JMenu("Select");
    }

    public JMenu createTransformMenu() {
        JMenu transform = new JMenu("Transformation");
        this.lock = new JCheckBoxMenuItem("Lock");
        this.lock.addItemListener(this);
        transform.add(this.lock);
        this.setTransform = new JMenuItem("Set Transform");
        this.setTransform.addActionListener(this);
        transform.add(this.setTransform);
        this.resetTransform = new JMenuItem("Reset Transform");
        this.resetTransform.addActionListener(this);
        transform.add(this.resetTransform);
        this.applyTransform = new JMenuItem("Apply Transform");
        this.applyTransform.addActionListener(this);
        transform.add(this.applyTransform);
        this.saveTransform = new JMenuItem("Save Transform");
        this.saveTransform.addActionListener(this);
        transform.add(this.saveTransform);
        transform.addSeparator();
        this.exportTransformed = new JMenuItem("Export transformed image");
        this.exportTransformed.addActionListener(this);
        transform.add(this.exportTransformed);
        return transform;
    }

    public JMenu createViewMenu() {
        JMenu view = new JMenu("View");
        this.resetView = new JMenuItem("Reset view");
        this.resetView.addActionListener(this);
        view.add(this.resetView);
        JMenu menu = new JMenu("Center");
        this.centerSelected = new JMenuItem("Selected content");
        this.centerSelected.addActionListener(this);
        menu.add(this.centerSelected);
        this.centerOrigin = new JMenuItem("Origin");
        this.centerOrigin.addActionListener(this);
        menu.add(this.centerOrigin);
        this.centerUniverse = new JMenuItem("Universe");
        this.centerUniverse.addActionListener(this);
        menu.add(this.centerUniverse);
        view.add(menu);
        menu = new JMenu("Fit view to");
        this.fitViewToUniverse = new JMenuItem("Universe");
        this.fitViewToUniverse.addActionListener(this);
        menu.add(this.fitViewToUniverse);
        this.fitViewToContent = new JMenuItem("Selected content");
        this.fitViewToContent.addActionListener(this);
        menu.add(this.fitViewToContent);
        view.add(menu);
        menu = new JMenu("Set view");
        this.viewposXY = new JMenuItem("+ XY");
        this.viewposXY.addActionListener(this);
        menu.add(this.viewposXY);
        this.viewposXZ = new JMenuItem("+ XZ");
        this.viewposXZ.addActionListener(this);
        menu.add(this.viewposXZ);
        this.viewposYZ = new JMenuItem("+ YZ");
        this.viewposYZ.addActionListener(this);
        menu.add(this.viewposYZ);
        this.viewnegXY = new JMenuItem("- XY");
        this.viewnegXY.addActionListener(this);
        menu.add(this.viewnegXY);
        this.viewnegXZ = new JMenuItem("- XZ");
        this.viewnegXZ.addActionListener(this);
        menu.add(this.viewnegXZ);
        this.viewnegYZ = new JMenuItem("- YZ");
        this.viewnegYZ.addActionListener(this);
        menu.add(this.viewnegYZ);
        view.add(menu);
        view.addSeparator();
        this.snapshot = new JMenuItem("Take snapshot");
        this.snapshot.addActionListener(this);
        view.add(this.snapshot);
        view.addSeparator();
        this.record360 = new JMenuItem("Record 360 deg rotation");
        this.record360.addActionListener(this);
        view.add(this.record360);
        this.startRecord = new JMenuItem("Start freehand recording");
        this.startRecord.addActionListener(this);
        view.add(this.startRecord);
        this.stopRecord = new JMenuItem("Stop freehand recording");
        this.stopRecord.addActionListener(this);
        view.add(this.stopRecord);
        view.addSeparator();
        this.startAnimation = new JMenuItem("Start animation");
        this.startAnimation.addActionListener(this);
        view.add(this.startAnimation);
        this.stopAnimation = new JMenuItem("Stop animation");
        this.stopAnimation.addActionListener(this);
        view.add(this.stopAnimation);
        this.animationOptions = new JMenuItem("Change animation options");
        this.animationOptions.addActionListener(this);
        view.add(this.animationOptions);
        view.addSeparator();
        this.sync = new JCheckBoxMenuItem("Sync view");
        this.sync.addItemListener(this);
        view.add(this.sync);
        view.addSeparator();
        this.scalebar = new JMenuItem("Edit Scalebar");
        this.scalebar.addActionListener(this);
        view.add(this.scalebar);
        view.addSeparator();
        this.light = new JMenuItem("Adjust light");
        this.light.addActionListener(this);
        view.add(this.light);
        this.bgColor = new JMenuItem("Change background color");
        this.bgColor.addActionListener(this);
        view.add(this.bgColor);
        this.fullscreen = new JCheckBoxMenuItem("Fullscreen");
        this.fullscreen.setState(this.univ.isFullScreen());
        this.fullscreen.addItemListener(this);
        view.add(this.fullscreen);
        return view;
    }

    public JMenu createHelpMenu() {
        JMenu help = new JMenu("Help");
        this.j3dproperties = new JMenuItem("Java 3D Properties");
        this.j3dproperties.addActionListener(this);
        help.add(this.j3dproperties);
        return help;
    }

    public JMenu createAttributesSubMenu() {
        JMenu attributes = new JMenu("Attributes");
        return attributes;
    }

    public JMenu createDisplayAsSubMenu() {
        JMenu display = new JMenu("Display as");
        this.displayAsVolume = new JMenuItem("Volume");
        this.displayAsVolume.addActionListener(this);
        display.add(this.displayAsVolume);
        this.displayAsOrtho = new JMenuItem("Orthoslice");
        this.displayAsOrtho.addActionListener(this);
        display.add(this.displayAsOrtho);
        this.displayAsMultiOrtho = new JMenuItem("Multi-orthoslice");
        this.displayAsMultiOrtho.addActionListener(this);
        display.add(this.displayAsMultiOrtho);
        this.displayAsSurface = new JMenuItem("Surface");
        this.displayAsSurface.addActionListener(this);
        display.add(this.displayAsSurface);
        this.displayAsSurfacePlot = new JMenuItem("Surface Plot 2D");
        this.displayAsSurfacePlot.addActionListener(this);
        display.add(this.displayAsSurfacePlot);
        return display;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.color) {
            this.executer.changeColor(this.getSelected());
        } else if (src == this.bgColor) {
            this.executer.changeBackgroundColor();
        } else if (src == this.scalebar) {
            this.executer.editScalebar();
        } else if (src == this.luts) {
            this.executer.adjustLUTs(this.getSelected());
        } else if (src == this.channels) {
            this.executer.changeChannels(this.getSelected());
        } else if (src == this.transparency) {
            this.executer.changeTransparency(this.getSelected());
        } else if (src == this.open) {
            this.executer.addContentFromFile();
        } else if (src == this.addContentFromImage) {
            this.executer.addContentFromImage(null);
        } else if (src == this.regist) {
            this.executer.register();
        } else if (src == this.delete) {
            this.executer.delete(this.getSelected());
        } else if (src == this.resetView) {
            this.executer.resetView();
        } else if (src == this.centerSelected) {
            this.executer.centerSelected(this.getSelected());
        } else if (src == this.centerOrigin) {
            this.executer.centerOrigin();
        } else if (src == this.centerUniverse) {
            this.executer.centerUniverse();
        } else if (src == this.fitViewToUniverse) {
            this.executer.fitViewToUniverse();
        } else if (src == this.fitViewToContent) {
            this.executer.fitViewToContent(this.getSelected());
        } else if (src == this.snapshot) {
            this.executer.snapshot();
        } else if (src == this.record360) {
            this.executer.record360();
        } else if (src == this.startRecord) {
            this.executer.startFreehandRecording();
        } else if (src == this.stopRecord) {
            this.executer.stopFreehandRecording();
        } else if (src == this.startAnimation) {
            this.executer.startAnimation();
        } else if (src == this.stopAnimation) {
            this.executer.stopAnimation();
        } else if (src == this.animationOptions) {
            this.executer.changeAnimationOptions();
        } else if (src == this.threshold) {
            this.executer.changeThreshold(this.getSelected());
        } else if (src == this.displayAsVolume) {
            this.executer.displayAs(this.getSelected(), 0);
            this.updateMenus();
        } else if (src == this.displayAsOrtho) {
            this.executer.displayAs(this.getSelected(), 1);
            this.updateMenus();
        } else if (src == this.displayAsMultiOrtho) {
            this.executer.displayAs(this.getSelected(), 4);
            this.updateMenus();
        } else if (src == this.displayAsSurface) {
            this.executer.displayAs(this.getSelected(), 2);
            this.updateMenus();
        } else if (src == this.displayAsSurfacePlot) {
            this.executer.displayAs(this.getSelected(), 3);
            this.updateMenus();
        } else if (src == this.close) {
            this.executer.close();
        } else if (src == this.resetTransform) {
            this.executer.resetTransform(this.getSelected());
        } else if (src == this.setTransform) {
            this.executer.setTransform(this.getSelected());
        } else if (src == this.properties) {
            this.executer.contentProperties(this.getSelected());
        } else if (src == this.applyTransform) {
            this.executer.applyTransform(this.getSelected());
        } else if (src == this.saveTransform) {
            this.executer.saveTransform(this.getSelected());
        } else if (src == this.exportTransformed) {
            this.executer.exportTransformed(this.getSelected());
        } else if (src == this.pl_load) {
            this.executer.loadPointList(this.getSelected());
        } else if (src == this.pl_save) {
            this.executer.savePointList(this.getSelected());
        } else if (src == this.pl_size) {
            this.executer.changePointSize(this.getSelected());
        } else if (src == this.pl_color) {
            this.executer.changePointColor(this.getSelected());
        } else if (src == this.saveView) {
            this.executer.saveView();
        } else if (src == this.loadView) {
            this.executer.loadView();
        } else if (src == this.saveSession) {
            this.executer.saveSession();
        } else if (src == this.loadSession) {
            this.executer.loadSession();
        } else if (src == this.importObj) {
            this.executer.importWaveFront();
        } else if (src == this.importStl) {
            this.executer.importSTL();
        } else if (src == this.exportDXF) {
            this.executer.saveAsDXF();
        } else if (src == this.exportObj) {
            this.executer.saveAsWaveFront();
        } else if (src == this.exportU3D) {
            this.executer.saveAsU3D();
        } else if (src == this.exportAsciiSTL) {
            this.executer.saveAsAsciiSTL();
        } else if (src == this.exportBinarySTL) {
            this.executer.saveAsBinarySTL();
        } else if (src == this.light) {
            this.executer.adjustLight();
        } else if (src == this.viewPreferences) {
            this.executer.viewPreferences();
        } else if (src == this.shortcuts) {
            this.executer.editShortcuts();
        } else if (src == this.j3dproperties) {
            this.executer.j3dproperties();
        } else if (this.viewposXY == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToPositiveXY();
                }
            });
        } else if (this.viewposXZ == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToPositiveXZ();
                }
            });
        } else if (this.viewposYZ == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToPositiveYZ();
                }
            });
        } else if (this.viewnegXY == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToNegativeXY();
                }
            });
        } else if (this.viewnegXZ == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToNegativeXZ();
                }
            });
        } else if (this.viewnegYZ == src) {
            this.executer.execute(new Runnable(){

                @Override
                public void run() {
                    Image3DMenubar.this.univ.rotateToNegativeYZ();
                }
            });
        } else if (src == this.sphere) {
            this.executer.addSphere();
        } else if (src == this.box) {
            this.executer.addBox();
        } else if (src == this.cone) {
            this.executer.addCone();
        } else if (src == this.tube) {
            this.executer.addTube();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        Content c = this.getSelected();
        if (src == this.coordinateSystem) {
            this.executer.showCoordinateSystem(c, this.coordinateSystem.getState());
        } else if (src == this.allCoordinateSystems) {
            this.executer.showAllCoordinateSystems(this.allCoordinateSystems.getState());
        } else if (src == this.boundingBox) {
            this.executer.showBoundingBox(c, this.boundingBox.getState());
        } else if (src == this.show) {
            this.executer.showContent(c, this.show.getState());
        } else if (src == this.lock) {
            this.executer.setLocked(c, this.lock.getState());
        } else if (src == this.pl_show) {
            this.executer.showPointList(c, this.pl_show.getState());
        } else if (src == this.sync) {
            this.executer.sync(this.sync.getState());
        } else if (src == this.fullscreen) {
            this.executer.setFullScreen(this.fullscreen.getState());
        }
    }

    private Content getSelected() {
        Content c = this.univ.getSelected();
        if (c != null) {
            return c;
        }
        if (this.univ.getContents().size() == 1) {
            return (Content)this.univ.contents().next();
        }
        return null;
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void transformationFinished(View view) {
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void transformationUpdated(View view) {
    }

    @Override
    public void contentChanged(Content c) {
    }

    @Override
    public void universeClosed() {
    }

    @Override
    public void contentAdded(Content c) {
        this.updateMenus();
        if (c == null) {
            return;
        }
        final String name = c.getName();
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem(name);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (item.getState()) {
                    Image3DMenubar.this.executer.select(name);
                } else {
                    Image3DMenubar.this.executer.select(null);
                }
            }
        });
        this.selectMenu.add(item);
    }

    @Override
    public void contentRemoved(Content c) {
        this.updateMenus();
        if (c == null) {
            return;
        }
        for (int i = 0; i < this.selectMenu.getItemCount(); ++i) {
            JMenuItem item = this.selectMenu.getItem(i);
            if (!item.getText().equals(c.getName())) continue;
            this.selectMenu.remove(i);
            return;
        }
    }

    @Override
    public void contentSelected(Content c) {
        this.updateMenus();
    }

    public void updateMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Image3DMenubar.this.doUpdateMenus();
            }
        });
    }

    private void doUpdateMenus() {
        this.fullscreen.setState(this.univ.isFullScreen());
        Content c = this.getSelected();
        this.delete.setEnabled(c != null);
        this.centerSelected.setEnabled(c != null);
        this.displayAsVolume.setEnabled(c != null);
        this.displayAsSurface.setEnabled(c != null);
        this.displayAsSurfacePlot.setEnabled(c != null);
        this.displayAsOrtho.setEnabled(c != null);
        this.properties.setEnabled(c != null);
        this.color.setEnabled(c != null);
        this.transparency.setEnabled(c != null);
        this.threshold.setEnabled(c != null);
        this.channels.setEnabled(c != null);
        this.show.setEnabled(c != null);
        this.coordinateSystem.setEnabled(c != null);
        this.pl_load.setEnabled(c != null);
        this.pl_save.setEnabled(c != null);
        this.pl_show.setEnabled(c != null);
        this.pl_size.setEnabled(c != null);
        this.pl_color.setEnabled(c != null);
        this.lock.setEnabled(c != null);
        this.setTransform.setEnabled(c != null);
        this.applyTransform.setEnabled(c != null);
        this.resetTransform.setEnabled(c != null);
        this.saveTransform.setEnabled(c != null);
        this.exportTransformed.setEnabled(c != null);
        Content sel = this.univ.getSelected();
        for (int i = 0; i < this.selectMenu.getItemCount(); ++i) {
            JMenuItem item = this.selectMenu.getItem(i);
            ((JCheckBoxMenuItem)item).setState(sel != null && sel.getName().equals(item.getText()));
        }
        if (c == null) {
            return;
        }
        int t = c.getType();
        this.coordinateSystem.setState(c.hasCoord());
        this.lock.setState(c.isLocked());
        this.show.setState(c.isVisible());
        this.pl_show.setState(c.isPLVisible());
        ImagePlus i = c.getImage();
        this.displayAsVolume.setEnabled(t != 0 && i != null);
        this.displayAsOrtho.setEnabled(t != 1 && i != null);
        this.displayAsSurface.setEnabled(t != 2 && i != null);
        this.displayAsSurfacePlot.setEnabled(t != 3 && i != null);
        this.displayAsMultiOrtho.setEnabled(t != 4 && i != null);
    }
}

