/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.ContentConstants;
import ij3d.ContentNode;
import ij3d.Executer;
import ij3d.UniverseListener;
import ij3d.UniverseSettings;
import ij3d.pointlist.PointListDialog;
import ij3d.pointlist.PointListPanel;
import ij3d.pointlist.PointListShape;
import ij3d.shapes.BoundingBox;
import ij3d.shapes.CoordinateSystem;
import isosurface.MeshGroup;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Node;
import org.scijava.java3d.OrderedGroup;
import org.scijava.java3d.Switch;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Matrix3f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3d;
import orthoslice.MultiOrthoGroup;
import orthoslice.OrthoGroup;
import surfaceplot.SurfacePlotGroup;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.PointList;
import voltex.VoltexGroup;

public class ContentInstant
extends BranchGroup
implements UniverseListener,
ContentConstants {
    int timepoint = 0;
    private final String name;
    protected Color3f color = null;
    protected ImagePlus image;
    protected boolean[] channels = new boolean[]{true, true, true};
    protected int[] rLUT = ContentInstant.createDefaultLUT();
    protected int[] gLUT = ContentInstant.createDefaultLUT();
    protected int[] bLUT = ContentInstant.createDefaultLUT();
    protected int[] aLUT = ContentInstant.createDefaultLUT();
    protected float transparency = 0.0f;
    protected int resamplingF = 1;
    protected int threshold = 0;
    protected boolean shaded = true;
    protected int type = 0;
    private boolean locked = false;
    private boolean visible = true;
    private boolean bbVisible = false;
    private boolean coordVisible = UniverseSettings.showLocalCoordinateSystemsByDefault;
    private boolean showPL = false;
    protected boolean selected = false;
    private ContentNode contentNode = null;
    private PointListShape plShape = null;
    private PointListDialog plDialog = null;
    private PointListPanel plPanel = null;
    private PointList points;
    private final OrderedGroup ordered;
    protected TransformGroup localRotate;
    protected TransformGroup localTranslate;
    private boolean available = true;
    private String displayedDataSwapfile = null;
    private String originalDataSwapfile = null;

    public ContentInstant(String name) {
        this.name = name;
        this.setCapability(17);
        this.setCapability(1);
        this.localTranslate = new TransformGroup();
        this.localTranslate.setCapability(17);
        this.localTranslate.setCapability(18);
        this.addChild((Node)this.localTranslate);
        this.localRotate = new TransformGroup();
        this.localRotate.setCapability(17);
        this.localRotate.setCapability(18);
        this.localTranslate.addChild((Node)this.localRotate);
        this.ordered = new OrderedGroup();
        for (int i = 0; i < 5; ++i) {
            Switch s = new Switch();
            s.setCapability(18);
            s.setCapability(17);
            s.setCapability(13);
            s.setCapability(14);
            this.ordered.addChild((Node)s);
        }
        this.localRotate.addChild((Node)this.ordered);
        this.points = new PointList();
        this.plShape = new PointListShape(this.points);
        this.plShape.setPickable(true);
        this.plPanel = new PointListPanel(name, this.points);
    }

    public void displayAs(int type) {
        if (this.image == null) {
            return;
        }
        switch (type) {
            case 0: {
                this.contentNode = new VoltexGroup(this);
                break;
            }
            case 1: {
                this.contentNode = new OrthoGroup(this);
                break;
            }
            case 2: {
                this.contentNode = new MeshGroup(this);
                break;
            }
            case 3: {
                this.contentNode = new SurfacePlotGroup(this);
                break;
            }
            case 4: {
                this.contentNode = new MultiOrthoGroup(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified type is neither VOLUME, ORTHO,SURFACE or SURFACEPLOT2D");
            }
        }
        this.display(this.contentNode);
        this.type = type;
    }

    private static int[] createDefaultLUT() {
        int[] lut = new int[256];
        for (int i = 0; i < lut.length; ++i) {
            lut[i] = i;
        }
        return lut;
    }

    public static int getDefaultThreshold(ImagePlus imp, int type) {
        if (type != 2) {
            return 0;
        }
        ImageStack stack = imp.getStack();
        int d = imp.getStackSize();
        int[] h = stack.getProcessor(1).getHistogram();
        for (int z = 1; z < d; ++z) {
            int[] tmp = stack.getProcessor(z + 1).getHistogram();
            for (int i = 0; i < h.length; ++i) {
                int n = i;
                h[n] = h[n] + tmp[i];
            }
        }
        return imp.getProcessor().getAutoThreshold(h);
    }

    public static int getDefaultResamplingFactor(ImagePlus imp, int type) {
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        int max = Math.max(w, Math.max(h, d));
        switch (type) {
            case 2: {
                return (int)Math.ceil((float)max / 128.0f);
            }
            case 0: {
                return (int)Math.ceil((float)max / 256.0f);
            }
            case 1: {
                return (int)Math.ceil((float)max / 256.0f);
            }
            case 3: {
                return (int)Math.ceil((float)max / 128.0f);
            }
        }
        return 1;
    }

    public void display(ContentNode node) {
        Enumeration e = this.ordered.getAllChildren();
        while (e.hasMoreElements()) {
            Switch s = (Switch)e.nextElement();
            s.removeAllChildren();
        }
        this.contentNode = node;
        ((Switch)this.ordered.getChild(0)).addChild((Node)this.contentNode);
        Point3d min = new Point3d();
        this.contentNode.getMin((Tuple3d)min);
        Point3d max = new Point3d();
        this.contentNode.getMax((Tuple3d)max);
        BoundingBox bb = new BoundingBox(min, max);
        bb.setPickable(false);
        ((Switch)this.ordered.getChild(1)).addChild((Node)bb);
        bb = new BoundingBox(min, max, new Color3f(0.0f, 1.0f, 0.0f));
        bb.setPickable(false);
        ((Switch)this.ordered.getChild(2)).addChild((Node)bb);
        float cl = (float)Math.abs(max.x - min.x) / 5.0f;
        CoordinateSystem cs = new CoordinateSystem(cl, new Color3f(0.0f, 1.0f, 0.0f));
        cs.setPickable(false);
        ((Switch)this.ordered.getChild(3)).addChild((Node)cs);
        ((Switch)this.ordered.getChild(4)).addChild((Node)this.plShape);
        this.plShape.setRadius((float)min.distance(max) / 100.0f);
        this.setSwitch(1, this.selected);
        this.setSwitch(3, this.coordVisible);
        this.setSwitch(0, this.visible);
        this.setSwitch(4, this.showPL);
        this.type = 5;
    }

    private void setSwitch(int which, boolean on) {
        ((Switch)this.ordered.getChild(which)).setWhichChild(on ? -2 : -1);
    }

    public ImagePlus exportTransformed() {
        ImagePlus orig = this.getImage();
        if (orig == null) {
            throw new RuntimeException("No greyscale image exists for " + this.getName());
        }
        Transform3D t1 = new Transform3D();
        this.getLocalTranslate().getTransform(t1);
        Transform3D t2 = new Transform3D();
        this.getLocalRotate().getTransform(t2);
        t1.mul(t2);
        FastMatrix fc = FastMatrix.fromCalibration((ImagePlus)orig);
        FastMatrix fm = fc.inverse().times(Executer.toFastMatrix(t1).inverse()).times(fc);
        InterpolatedImage in = new InterpolatedImage(orig);
        InterpolatedImage out = in.cloneDimensionsOnly();
        int w = orig.getWidth();
        int h = orig.getHeight();
        int d = orig.getStackSize();
        for (int k = 0; k < d; ++k) {
            ImageProcessor ip = out.getImage().getStack().getProcessor(k + 1);
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    fm.apply((double)i, (double)j, (double)k);
                    ip.set(i, j, (int)in.interpol.get(fm.x, fm.y, fm.z));
                }
                IJ.showProgress((int)(k + 1), (int)d);
            }
        }
        out.getImage().setTitle(orig.getTitle() + "_transformed");
        out.getImage().getProcessor().setColorModel(orig.getProcessor().getColorModel());
        return out.getImage();
    }

    public void clearOriginalData() {
        if (this.image != null) {
            this.image.close();
        }
        this.image = null;
    }

    public void swapDisplayedData() {
        if (!this.available) {
            return;
        }
        this.contentNode.swapDisplayedData(this.getDisplayedDataSwapfile(), this.getName());
        this.available = false;
    }

    public void restoreDisplayedData() {
        System.out.println("restoreDisplayedData " + this.getName());
        if (this.available) {
            System.out.println("not restoring because it is not swapped");
            return;
        }
        this.contentNode.restoreDisplayedData(this.getDisplayedDataSwapfile(), this.getName());
        this.available = true;
    }

    public void clearDisplayedData() {
        if (!this.available) {
            return;
        }
        this.contentNode.clearDisplayedData();
        this.available = false;
    }

    public boolean isAvailable() {
        return this.available;
    }

    private String getOriginalDataSwapfile() {
        if (this.originalDataSwapfile != null) {
            return this.originalDataSwapfile;
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"), "3D_Viewer");
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        if (!(tmp = new File(tmp, "original")).exists()) {
            tmp.mkdirs();
        }
        this.originalDataSwapfile = new File(tmp, this.getName()).getAbsolutePath();
        return this.originalDataSwapfile;
    }

    private String getDisplayedDataSwapfile() {
        if (this.displayedDataSwapfile != null) {
            return this.displayedDataSwapfile;
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"), "3D_Viewer");
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        if (!(tmp = new File(tmp, "displayed")).exists()) {
            tmp.mkdirs();
        }
        this.displayedDataSwapfile = new File(tmp, this.getName()).getAbsolutePath();
        return this.displayedDataSwapfile;
    }

    public void setVisible(boolean b) {
        this.visible = b;
        this.setSwitch(0, b);
        this.setSwitch(3, b & this.coordVisible);
        if (!b) {
            this.showPointList(false);
        }
    }

    public void showBoundingBox(boolean b) {
        this.bbVisible = b;
        this.setSwitch(2, b);
    }

    public void showCoordinateSystem(boolean b) {
        this.coordVisible = b;
        this.setSwitch(3, b);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        boolean sb = selected && UniverseSettings.showSelectionBox;
        this.setSwitch(1, sb);
    }

    public void setPointListDialog(PointListDialog p) {
        this.plDialog = p;
    }

    public void showPointList(boolean b) {
        if (this.plShape == null) {
            return;
        }
        this.setSwitch(4, b);
        this.showPL = b;
        if (b && this.plDialog != null) {
            this.plDialog.addPointList(this.getName(), this.plPanel);
        } else if (!b && this.plDialog != null) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    public void loadPointList() {
        PointList points = PointList.load((ImagePlus)this.image);
        if (points != null) {
            this.setPointList(points);
        }
    }

    public void setPointList(PointList points) {
        this.points = points;
        this.plPanel.setPointList(points);
        this.plShape.setPointList(points);
    }

    public void savePointList() {
        String dir = OpenDialog.getDefaultDirectory();
        String n = this.getName();
        if (this.image != null) {
            FileInfo fi = this.image.getFileInfo();
            dir = fi.directory;
            n = fi.fileName;
        }
        this.points.save(dir, n);
    }

    public void savePointList(PrintStream out) throws IOException {
        this.points.save(out, false);
    }

    @Deprecated
    public void addPointListPoint(Point3d p) {
        this.points.add(p.x, p.y, p.z);
        if (this.plDialog != null) {
            this.plDialog.update();
        }
    }

    @Deprecated
    public void setListPointPos(int i, Point3d pos) {
        this.points.placePoint(this.points.get(i), pos.x, pos.y, pos.z);
    }

    public float getLandmarkPointSize() {
        return this.plShape.getRadius();
    }

    public void setLandmarkPointSize(float r) {
        this.plShape.setRadius(r);
    }

    public Color3f getLandmarkColor() {
        return this.plShape.getColor();
    }

    public void setLandmarkColor(Color3f color) {
        this.plShape.setColor(color);
    }

    public PointList getPointList() {
        return this.points;
    }

    @Deprecated
    public void deletePointListPoint(int i) {
        this.points.remove(i);
        if (this.plDialog != null) {
            this.plDialog.update();
        }
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    public void applyTransform(double[] matrix) {
        this.applyTransform(new Transform3D(matrix));
    }

    public void applyTransform(Transform3D transform) {
        Transform3D t1 = new Transform3D();
        this.localTranslate.getTransform(t1);
        Transform3D t2 = new Transform3D();
        this.localRotate.getTransform(t2);
        t1.mul(t2);
        t1.mul(transform, t1);
        this.setTransform(t1);
    }

    public void setTransform(double[] matrix) {
        if (this.contentNode == null) {
            return;
        }
        this.setTransform(new Transform3D(matrix));
    }

    public void setTransform(Transform3D transform) {
        if (this.contentNode == null) {
            return;
        }
        Transform3D t = new Transform3D();
        Point3d c = new Point3d();
        this.contentNode.getCenter((Tuple3d)c);
        Matrix3f m = new Matrix3f();
        transform.getRotationScale(m);
        t.setRotationScale(m);
        Vector3d v = new Vector3d();
        v.x = (double)(-m.m00) * c.x - (double)m.m01 * c.y - (double)m.m02 * c.z + c.x;
        v.y = (double)(-m.m10) * c.x - (double)m.m11 * c.y - (double)m.m12 * c.z + c.y;
        v.z = (double)(-m.m20) * c.x - (double)m.m21 * c.y - (double)m.m22 * c.z + c.z;
        t.setTranslation(v);
        this.localRotate.setTransform(t);
        Vector3d v2 = new Vector3d();
        transform.get(v2);
        v2.sub((Tuple3d)v);
        t.set(v2);
        this.localTranslate.setTransform(t);
    }

    public void setLUT(int[] rLUT, int[] gLUT, int[] bLUT, int[] aLUT) {
        this.rLUT = rLUT;
        this.gLUT = gLUT;
        this.bLUT = bLUT;
        this.aLUT = aLUT;
        if (this.contentNode != null) {
            this.contentNode.lutUpdated(rLUT, gLUT, bLUT, aLUT);
        }
    }

    public void setChannels(boolean[] channels) {
        boolean channelsChanged;
        boolean bl = channelsChanged = channels[0] != this.channels[0] || channels[1] != this.channels[1] || channels[2] != this.channels[2];
        if (!channelsChanged) {
            return;
        }
        this.channels = channels;
        if (this.contentNode != null) {
            this.contentNode.channelsUpdated(channels);
        }
    }

    public void setThreshold(int th) {
        if (th != this.threshold) {
            this.threshold = th;
            if (this.contentNode != null) {
                this.contentNode.thresholdUpdated(this.threshold);
            }
        }
    }

    public void setShaded(boolean b) {
        if (b != this.shaded) {
            this.shaded = b;
            if (this.contentNode != null) {
                this.contentNode.shadeUpdated(this.shaded);
            }
        }
    }

    public boolean isShaded() {
        return this.shaded;
    }

    public void setSaturatedVolumeRendering(boolean b) {
        if (this.contentNode != null && this.type == 0) {
            ((VoltexGroup)this.contentNode).getRenderer().getVolume().setSaturatedVolumeRendering(b);
        }
    }

    public boolean isSaturatedVolumeRendering() {
        return this.contentNode != null && this.type == 0 && ((VoltexGroup)this.contentNode).getRenderer().getVolume().isSaturatedVolumeRendering();
    }

    public void applySurfaceColors(ImagePlus imp) {
        if (this.contentNode == null) {
            return;
        }
        CustomMesh mesh = null;
        switch (this.type) {
            case 2: {
                mesh = ((MeshGroup)this.contentNode).getMesh();
                break;
            }
            case 5: {
                mesh = ((CustomMeshNode)this.contentNode).getMesh();
            }
        }
        if (mesh == null) {
            return;
        }
        mesh.loadSurfaceColorsFromImage(imp);
    }

    public void setColor(Color3f color) {
        if (this.color == null && color == null || this.color != null && color != null && this.color.equals((Tuple3f)color)) {
            return;
        }
        this.color = color;
        this.plShape.setColor(color);
        if (this.contentNode != null) {
            this.contentNode.colorUpdated(this.color);
        }
    }

    public synchronized void setTransparency(float transparency) {
        transparency = transparency < 0.0f ? 0.0f : transparency;
        float f = transparency = transparency > 1.0f ? 1.0f : transparency;
        if ((double)Math.abs(transparency - this.transparency) < 0.01) {
            return;
        }
        this.transparency = transparency;
        if (this.contentNode != null) {
            this.contentNode.transparencyUpdated(this.transparency);
        }
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void contentAdded(Content c) {
    }

    @Override
    public void contentRemoved(Content c) {
        if (this.plDialog != null) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void contentSelected(Content c) {
    }

    @Override
    public void contentChanged(Content c) {
    }

    @Override
    public void universeClosed() {
        if (this.plDialog != null) {
            this.plDialog.removePointList(this.plPanel);
        }
    }

    @Override
    public void transformationUpdated(View view) {
        this.eyePtChanged(view);
    }

    @Override
    public void transformationFinished(View view) {
        this.eyePtChanged(view);
    }

    public void eyePtChanged(View view) {
        if (this.contentNode != null) {
            this.contentNode.eyePtChanged(view);
        }
    }

    public String getName() {
        return this.name + "_#" + this.timepoint;
    }

    public int getTimepoint() {
        return this.timepoint;
    }

    public int getType() {
        return this.type;
    }

    public ContentNode getContent() {
        return this.contentNode;
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public boolean[] getChannels() {
        return this.channels;
    }

    public void getRedLUT(int[] l) {
        System.arraycopy(this.rLUT, 0, l, 0, this.rLUT.length);
    }

    public void getGreenLUT(int[] l) {
        System.arraycopy(this.gLUT, 0, l, 0, this.gLUT.length);
    }

    public void getBlueLUT(int[] l) {
        System.arraycopy(this.bLUT, 0, l, 0, this.bLUT.length);
    }

    public void getAlphaLUT(int[] l) {
        System.arraycopy(this.aLUT, 0, l, 0, this.aLUT.length);
    }

    public Color3f getColor() {
        return this.color;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public int getResamplingFactor() {
        return this.resamplingF;
    }

    public TransformGroup getLocalRotate() {
        return this.localRotate;
    }

    public TransformGroup getLocalTranslate() {
        return this.localTranslate;
    }

    public void getLocalRotate(Transform3D t) {
        this.localRotate.getTransform(t);
    }

    public void getLocalTranslate(Transform3D t) {
        this.localTranslate.getTransform(t);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean hasCoord() {
        return this.coordVisible;
    }

    public boolean hasBoundingBox() {
        return this.bbVisible;
    }

    public boolean isPLVisible() {
        return this.showPL;
    }
}

