/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij3d.AxisConstants;
import ij3d.ContentConstants;
import ij3d.ContentInstant;
import ij3d.ContentNode;
import ij3d.UniverseListener;
import ij3d.pointlist.PointListDialog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Node;
import org.scijava.java3d.Switch;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3f;
import vib.PointList;

public class Content
extends BranchGroup
implements UniverseListener,
ContentConstants,
AxisConstants {
    private final HashMap<Integer, Integer> timepointToSwitchIndex;
    private final TreeMap<Integer, ContentInstant> contents;
    private int currentTimePoint;
    private final Switch contentSwitch;
    private boolean showAllTimepoints = false;
    private final String name;
    private boolean showPointList = false;
    private final boolean swapTimelapseData;
    protected static final Pattern startFramePattern = Pattern.compile("(?s)(?m).*?^(# frame:? (\\d+)\n).*");

    public Content(String name) {
        this(name, 0);
    }

    public Content(String name, int tp) {
        this.name = name;
        this.swapTimelapseData = false;
        this.setCapability(17);
        this.setCapability(1);
        this.timepointToSwitchIndex = new HashMap();
        this.contents = new TreeMap();
        ContentInstant ci = new ContentInstant(name + "_#" + tp);
        ci.timepoint = tp;
        this.contents.put(tp, ci);
        this.timepointToSwitchIndex.put(tp, 0);
        this.contentSwitch = new Switch();
        this.contentSwitch.setCapability(18);
        this.contentSwitch.setCapability(13);
        this.contentSwitch.setCapability(14);
        this.contentSwitch.addChild((Node)ci);
        this.addChild((Node)this.contentSwitch);
    }

    public Content(String name, TreeMap<Integer, ContentInstant> contents) {
        this(name, contents, false);
    }

    public Content(String name, TreeMap<Integer, ContentInstant> contents, boolean swapTimelapseData) {
        this.name = name;
        this.swapTimelapseData = swapTimelapseData;
        this.setCapability(17);
        this.setCapability(1);
        this.contents = contents;
        this.timepointToSwitchIndex = new HashMap();
        this.contentSwitch = new Switch();
        this.contentSwitch.setCapability(18);
        this.contentSwitch.setCapability(13);
        this.contentSwitch.setCapability(14);
        for (int i : contents.keySet()) {
            ContentInstant c = contents.get(i);
            c.timepoint = i;
            this.timepointToSwitchIndex.put(i, this.contentSwitch.numChildren());
            this.contentSwitch.addChild((Node)c);
        }
        this.addChild((Node)this.contentSwitch);
    }

    public void addInstant(ContentInstant ci) {
        int timepoint = ci.timepoint;
        this.contents.put(timepoint, ci);
        if (!this.contents.containsKey(timepoint)) {
            this.timepointToSwitchIndex.put(timepoint, this.contentSwitch.numChildren());
            this.contentSwitch.addChild((Node)ci);
        } else {
            int switchIdx = this.timepointToSwitchIndex.get(timepoint);
            this.contentSwitch.setChild((Node)ci, switchIdx);
        }
    }

    public void removeInstant(int timepoint) {
        if (!this.contents.containsKey(timepoint)) {
            return;
        }
        int sIdx = this.timepointToSwitchIndex.get(timepoint);
        this.contentSwitch.removeChild(sIdx);
        this.contents.remove(timepoint);
        this.timepointToSwitchIndex.remove(timepoint);
        for (int i = sIdx; i < this.contentSwitch.numChildren(); ++i) {
            ContentInstant ci = (ContentInstant)this.contentSwitch.getChild(i);
            int tp = ci.getTimepoint();
            this.timepointToSwitchIndex.put(tp, i);
        }
    }

    public ContentInstant getCurrent() {
        return this.contents.get(this.currentTimePoint);
    }

    public ContentInstant getInstant(int i) {
        return this.contents.get(i);
    }

    public TreeMap<Integer, ContentInstant> getInstants() {
        return this.contents;
    }

    public void showTimepoint(int tp) {
        this.showTimepoint(tp, false);
    }

    public void showTimepoint(int tp, boolean force) {
        Integer idx;
        ContentInstant next;
        if (tp == this.currentTimePoint && !force) {
            return;
        }
        ContentInstant old = this.getCurrent();
        if (old != null && !this.showAllTimepoints) {
            if (this.swapTimelapseData) {
                old.swapDisplayedData();
            }
            if (!this.showAllTimepoints && (next = this.contents.get(tp)) != null) {
                next.showPointList(this.showPointList);
            }
            this.getCurrent().showPointList(false);
        }
        this.currentTimePoint = tp;
        if (this.showAllTimepoints) {
            return;
        }
        next = this.getCurrent();
        if (next != null && this.swapTimelapseData) {
            next.restoreDisplayedData();
        }
        if ((idx = this.timepointToSwitchIndex.get(tp)) == null) {
            this.contentSwitch.setWhichChild(-1);
        } else {
            this.contentSwitch.setWhichChild(idx.intValue());
        }
    }

    public void setShowAllTimepoints(boolean b) {
        this.showAllTimepoints = b;
        if (b) {
            this.contentSwitch.setWhichChild(-2);
            return;
        }
        Integer idx = this.timepointToSwitchIndex.get(this.currentTimePoint);
        if (idx == null) {
            this.contentSwitch.setWhichChild(-1);
        } else {
            this.contentSwitch.setWhichChild(idx.intValue());
        }
    }

    public boolean getShowAllTimepoints() {
        return this.showAllTimepoints;
    }

    public int getNumberOfInstants() {
        return this.contents.size();
    }

    public boolean isVisibleAt(int tp) {
        return this.contents.containsKey(tp);
    }

    public int getStartTime() {
        return this.contents.firstKey();
    }

    public int getEndTime() {
        return this.contents.lastKey();
    }

    public void displayAs(int type) {
        for (ContentInstant c : this.contents.values()) {
            c.displayAs(type);
        }
    }

    public static int getDefaultThreshold(ImagePlus imp, int type) {
        return ContentInstant.getDefaultThreshold(imp, type);
    }

    public static int getDefaultResamplingFactor(ImagePlus imp, int type) {
        return ContentInstant.getDefaultResamplingFactor(imp, type);
    }

    public void display(ContentNode node) {
        for (ContentInstant c : this.contents.values()) {
            c.display(node);
        }
    }

    public ImagePlus exportTransformed() {
        return this.getCurrent().exportTransformed();
    }

    public void setVisible(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.setVisible(b);
        }
    }

    public void showBoundingBox(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.showBoundingBox(b);
        }
    }

    public void showCoordinateSystem(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.showCoordinateSystem(b);
        }
    }

    public void setSelected(boolean selected) {
        for (ContentInstant c : this.contents.values()) {
            c.setSelected(selected);
        }
    }

    public void setPointListDialog(PointListDialog p) {
        for (ContentInstant c : this.contents.values()) {
            c.setPointListDialog(p);
        }
    }

    public void showPointList(boolean b) {
        this.getCurrent().showPointList(b);
        this.showPointList = b;
    }

    public void loadPointList() {
        OpenDialog od;
        String dir = null;
        String fileName = null;
        ImagePlus image = this.contents.firstEntry().getValue().image;
        if (image != null) {
            FileInfo fi = image.getFileInfo();
            dir = fi.directory;
            fileName = fi.fileName + ".points";
        }
        if ((od = new OpenDialog("Open points annotation file", dir, fileName)).getFileName() == null) {
            return;
        }
        File file = new File(od.getDirectory(), od.getFileName());
        try {
            String fileContents = this.readFile(new FileInputStream(file));
            Matcher matcher = startFramePattern.matcher(fileContents);
            if (matcher.matches()) {
                for (Integer frame : this.contents.keySet()) {
                    this.contents.get(frame).setPointList(new PointList());
                }
                while (matcher.matches()) {
                    String pointsForFrame;
                    PointList points;
                    int frame = Integer.parseInt(matcher.group(2));
                    fileContents = fileContents.substring(matcher.end(1));
                    matcher = startFramePattern.matcher(fileContents);
                    ContentInstant ci = this.contents.get(frame);
                    if (ci == null || (points = PointList.parseString((String)(pointsForFrame = matcher.matches() ? fileContents.substring(0, matcher.start(1)) : fileContents))) == null) continue;
                    ci.setPointList(points);
                }
            } else {
                PointList points = PointList.parseString((String)fileContents);
                if (points != null) {
                    this.getCurrent().setPointList(points);
                }
            }
            this.showPointList(true);
        }
        catch (IOException e) {
            IJ.error((String)("Could not read point list from " + file));
        }
    }

    String readFile(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        out.close();
        return out.toString("UTF-8");
    }

    public void savePointList() {
        SaveDialog sd;
        String dir = OpenDialog.getDefaultDirectory();
        String fileName = this.getName();
        ImagePlus image = this.contents.firstEntry().getValue().image;
        if (image != null) {
            FileInfo fi = image.getFileInfo();
            dir = fi.directory;
            fileName = fi.fileName;
        }
        if ((sd = new SaveDialog("Save points annotation file as...", dir, fileName, ".points")).getFileName() == null) {
            return;
        }
        File file = new File(sd.getDirectory(), sd.getFileName());
        if (file.exists() && !IJ.showMessageWithCancel((String)"File exists", (String)("Overwrite " + file + "?"))) {
            return;
        }
        try {
            PrintStream out = new PrintStream(file);
            for (Integer frame : this.contents.keySet()) {
                ContentInstant ci = this.contents.get(frame);
                if (ci.getPointList().size() == 0) continue;
                out.println("# frame " + frame);
                ci.savePointList(out);
            }
            out.close();
        }
        catch (IOException e) {
            IJ.error((String)("Could not save points to " + file));
        }
    }

    @Deprecated
    public void addPointListPoint(Point3d p) {
        this.getCurrent().addPointListPoint(p);
    }

    @Deprecated
    public void setListPointPos(int i, Point3d pos) {
        this.getCurrent().setListPointPos(i, pos);
    }

    public float getLandmarkPointSize() {
        return this.getCurrent().getLandmarkPointSize();
    }

    public void setLandmarkPointSize(float r) {
        for (ContentInstant c : this.contents.values()) {
            c.setLandmarkPointSize(r);
        }
    }

    public Color3f getLandmarkColor() {
        return this.getCurrent().getLandmarkColor();
    }

    public void setLandmarkColor(Color3f color) {
        for (ContentInstant c : this.contents.values()) {
            c.setLandmarkColor(color);
        }
    }

    public PointList getPointList() {
        return this.getCurrent().getPointList();
    }

    @Deprecated
    public void deletePointListPoint(int i) {
        this.getCurrent().deletePointListPoint(i);
    }

    public void toggleLock() {
        for (ContentInstant c : this.contents.values()) {
            c.toggleLock();
        }
    }

    public void setLocked(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.setLocked(b);
        }
    }

    public void applyTransform(double[] matrix) {
        this.applyTransform(new Transform3D(matrix));
    }

    public void applyTransform(Transform3D transform) {
        for (ContentInstant c : this.contents.values()) {
            c.applyTransform(transform);
        }
    }

    public void applyRotation(int axis, double degree) {
        Transform3D t = new Transform3D();
        switch (axis) {
            case 0: {
                t.rotX(this.deg2rad(degree));
                break;
            }
            case 1: {
                t.rotY(this.deg2rad(degree));
                break;
            }
            case 2: {
                t.rotZ(this.deg2rad(degree));
            }
        }
        this.applyTransform(t);
    }

    public void applyTranslation(float dx, float dy, float dz) {
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(dx, dy, dz));
        this.applyTransform(t);
    }

    public void setTransform(double[] matrix) {
        this.setTransform(new Transform3D(matrix));
    }

    public void setTransform(Transform3D transform) {
        for (ContentInstant c : this.contents.values()) {
            c.setTransform(transform);
        }
    }

    public void setRotation(int axis, double degree) {
        Transform3D t = new Transform3D();
        switch (axis) {
            case 0: {
                t.rotX(this.deg2rad(degree));
                break;
            }
            case 1: {
                t.rotY(this.deg2rad(degree));
                break;
            }
            case 2: {
                t.rotZ(this.deg2rad(degree));
            }
        }
        this.setTransform(t);
    }

    public void setTranslation(float dx, float dy, float dz) {
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(dx, dy, dz));
        this.setTransform(t);
    }

    private double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public void setChannels(boolean[] channels) {
        for (ContentInstant c : this.contents.values()) {
            c.setChannels(channels);
        }
    }

    public void setLUT(int[] r, int[] g, int[] b, int[] a) {
        for (ContentInstant c : this.contents.values()) {
            c.setLUT(r, g, b, a);
        }
    }

    public void setThreshold(int th) {
        for (ContentInstant c : this.contents.values()) {
            c.setThreshold(th);
        }
    }

    public void setShaded(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.setShaded(b);
        }
    }

    public void setSaturatedVolumeRendering(boolean b) {
        for (ContentInstant c : this.contents.values()) {
            c.setSaturatedVolumeRendering(b);
        }
    }

    public void applySurfaceColors(ImagePlus img) {
        for (ContentInstant c : this.contents.values()) {
            c.applySurfaceColors(img);
        }
    }

    public void setColor(Color3f color) {
        for (ContentInstant c : this.contents.values()) {
            c.setColor(color);
        }
    }

    public synchronized void setTransparency(float transparency) {
        for (ContentInstant c : this.contents.values()) {
            c.setTransparency(transparency);
        }
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void contentAdded(Content c) {
    }

    @Override
    public void contentRemoved(Content c) {
        for (ContentInstant co : this.contents.values()) {
            co.contentRemoved(c);
        }
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void contentSelected(Content c) {
    }

    @Override
    public void contentChanged(Content c) {
    }

    @Override
    public void universeClosed() {
        for (ContentInstant c : this.contents.values()) {
            c.universeClosed();
        }
    }

    @Override
    public void transformationUpdated(View view) {
        this.eyePtChanged(view);
    }

    @Override
    public void transformationFinished(View view) {
        this.eyePtChanged(view);
        ContentInstant curr = this.getCurrent();
        if (curr == null || !curr.selected) {
            return;
        }
        Transform3D t = new Transform3D();
        Transform3D r = new Transform3D();
        curr.getLocalTranslate(t);
        curr.getLocalRotate(r);
        for (ContentInstant c : this.contents.values()) {
            if (c == this.getCurrent()) continue;
            c.getLocalRotate().setTransform(r);
            c.getLocalTranslate().setTransform(t);
            c.transformationFinished(view);
        }
    }

    public void eyePtChanged(View view) {
        for (ContentInstant c : this.contents.values()) {
            c.eyePtChanged(view);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.getCurrent().getType();
    }

    public ContentNode getContent() {
        return this.getCurrent().getContent();
    }

    public void getMin(Point3d min) {
        min.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Point3d tmp = new Point3d();
        for (ContentInstant c : this.contents.values()) {
            c.getContent().getMin((Tuple3d)tmp);
            if (tmp.x < min.x) {
                min.x = tmp.x;
            }
            if (tmp.y < min.y) {
                min.y = tmp.y;
            }
            if (!(tmp.z < min.z)) continue;
            min.z = tmp.z;
        }
    }

    public void getMax(Point3d max) {
        max.set(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        Point3d tmp = new Point3d();
        for (ContentInstant c : this.contents.values()) {
            c.getContent().getMax((Tuple3d)tmp);
            if (tmp.x > max.x) {
                max.x = tmp.x;
            }
            if (tmp.y > max.y) {
                max.y = tmp.y;
            }
            if (!(tmp.z > max.z)) continue;
            max.z = tmp.z;
        }
    }

    public ImagePlus getImage() {
        return this.getCurrent().getImage();
    }

    public boolean[] getChannels() {
        return this.getCurrent().getChannels();
    }

    public void getRedLUT(int[] l) {
        this.getCurrent().getRedLUT(l);
    }

    public void getGreenLUT(int[] l) {
        this.getCurrent().getGreenLUT(l);
    }

    public void getBlueLUT(int[] l) {
        this.getCurrent().getBlueLUT(l);
    }

    public void getAlphaLUT(int[] l) {
        this.getCurrent().getAlphaLUT(l);
    }

    public Color3f getColor() {
        return this.getCurrent().getColor();
    }

    public boolean isShaded() {
        return this.getCurrent().isShaded();
    }

    public boolean isSaturatedVolumeRendering() {
        return this.getCurrent().isSaturatedVolumeRendering();
    }

    public int getThreshold() {
        return this.getCurrent().getThreshold();
    }

    public float getTransparency() {
        return this.getCurrent().getTransparency();
    }

    public int getResamplingFactor() {
        return this.getCurrent().getResamplingFactor();
    }

    public TransformGroup getLocalRotate() {
        return this.getCurrent().getLocalRotate();
    }

    public TransformGroup getLocalTranslate() {
        return this.getCurrent().getLocalTranslate();
    }

    public void getLocalRotate(Transform3D t) {
        this.getCurrent().getLocalRotate(t);
    }

    public void getLocalTranslate(Transform3D t) {
        this.getCurrent().getLocalTranslate(t);
    }

    public boolean isLocked() {
        return this.getCurrent().isLocked();
    }

    public boolean isVisible() {
        return this.getCurrent().isVisible();
    }

    public boolean hasCoord() {
        return this.getCurrent().hasCoord();
    }

    public boolean hasBoundingBox() {
        return this.getCurrent().hasBoundingBox();
    }

    public boolean isPLVisible() {
        return this.getCurrent().isPLVisible();
    }
}

