/*
 * Decompiled with CFR 0.152.
 */
package customnode.u3d;

import customnode.CustomMeshNode;
import customnode.CustomTriangleMesh;
import customnode.MeshMaker;
import customnode.u3d.BitStreamWrite;
import customnode.u3d.DataBlock;
import ij3d.Content;
import ij3d.ContentNode;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import isosurface.MeshGroup;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.scijava.java3d.TriangleArray;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class U3DExporter {
    private static final int uACContextBaseShadingID = 1;
    private static final int uACStaticFull = 1024;
    private static final int uACMaxRange = 17407;

    public static void main(String[] args) throws IOException {
        Image3DUniverse univ = new Image3DUniverse();
        univ.show();
        List<Point3f> l = MeshMaker.createIcosahedron(1, 1.0f);
        CustomTriangleMesh ctm = new CustomTriangleMesh(l);
        ctm.setColor(new Color3f(0.0f, 1.0f, 0.0f));
        univ.addCustomMesh(ctm, "icosahedron");
        l = MeshMaker.createSphere(1.0, 0.0, 0.0, 0.5);
        ctm = new CustomTriangleMesh(l);
        ctm.setColor(new Color3f(1.0f, 0.0f, 0.0f));
        univ.addCustomMesh(ctm, "sphere");
        U3DExporter.export(univ, "/tmp/sphere.u3d");
    }

    public static String getTexStub(Image3DUniverse univ, String path) {
        Color3f bg = new Color3f();
        ((ImageCanvas3D)univ.getCanvas()).getBG().getColor(bg);
        return "\\documentclass[a4paper]{article}\n\\usepackage[english]{babel}\n\\usepackage{hyperref}\n\\usepackage[3D]{movie15}\n\n\\begin{document}\n\\includemovie[poster,label=my_label,3Dlights=Headlamp,3Dbg=" + bg.x + " " + bg.y + " " + bg.z + ",3Dcoo=0 0 0,3Droo=2.4]{.8\\linewidth}{.8\\linewidth}{%\n" + path + "%\n}\\ \n% \\movieref[3Dcalculate]{my_label}{Click here!}\n\\end{document}";
    }

    public static void export(Image3DUniverse univ, String path) throws IOException {
        Point3f min = new Point3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Point3f max = new Point3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        for (Object content : univ.getContents()) {
            ContentNode cn = ((Content)content).getContent();
            CustomTriangleMesh ctm = null;
            if (cn instanceof CustomMeshNode) {
                ctm = (CustomTriangleMesh)((CustomMeshNode)cn).getMesh();
            } else if (cn instanceof MeshGroup && ((MeshGroup)cn).getMesh() instanceof CustomTriangleMesh) {
                ctm = ((MeshGroup)cn).getMesh();
            }
            if (ctm == null) continue;
            Content c = (Content)content;
            Mesh m = new Mesh(ctm, c.getName(), c.getColor(), c.getTransparency());
            m.getMinMax(min, max);
            meshes.add(m);
        }
        ByteArrayOutputStream bOutDecl = new ByteArrayOutputStream();
        ByteArrayOutputStream bOutCont = new ByteArrayOutputStream();
        WritableByteChannel oDecl = Channels.newChannel(bOutDecl);
        WritableByteChannel oCont = Channels.newChannel(bOutCont);
        int ds = 0;
        int cs = 0;
        ByteBuffer buffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);
        DataBlock b = U3DExporter.getViewModifierChain("DefaultView", "SceneViewResource");
        ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
        for (Mesh mesh : meshes) {
            String n = mesh.name;
            mesh.normalizeCoords(min, max);
            float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            String nodeModifierChainName = n;
            String modelNodeName = n;
            String modelResourceName = n;
            String shadingName = n;
            String shaderName = n;
            b = U3DExporter.getNodeModifierChain(nodeModifierChainName, modelNodeName, modelResourceName, shadingName, shaderName, matrix);
            ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
            String modelModifierChainName = n;
            String meshname = n;
            b = U3DExporter.getModelResourceModifierChain(modelModifierChainName, mesh, meshname);
            ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
            String materialName = n;
            b = U3DExporter.getLitTextureShaderBlock(shaderName, materialName);
            ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
            b = U3DExporter.getMaterialResourceBlock(materialName, mesh.color.x, mesh.color.y, mesh.color.z, mesh.color.w);
            ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
            b = U3DExporter.getMeshContinuationBlock(mesh, meshname);
            cs += U3DExporter.writeDataBlock(b, oCont, buffer);
        }
        String lightModifierChainName = "Omni01";
        String lightResourceName = "DefaultPointLight";
        b = U3DExporter.getLightModifierChain("Omni01", "DefaultPointLight");
        ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
        b = U3DExporter.getViewResourceBlock("SceneViewResource");
        ds += U3DExporter.writeDataBlock(b, oDecl, buffer);
        b = U3DExporter.getLightResourceBlock("DefaultPointLight");
        FileOutputStream out = new FileOutputStream(path);
        WritableByteChannel o = Channels.newChannel(out);
        U3DExporter.writeDataBlock(U3DExporter.getHeaderBlock(ds += U3DExporter.writeDataBlock(b, oDecl, buffer), cs), o, buffer);
        bOutDecl.writeTo(out);
        bOutCont.writeTo(out);
        ((OutputStream)out).close();
    }

    private static int writeDataBlock(DataBlock b, WritableByteChannel o, ByteBuffer buffer) throws IOException {
        int i;
        int dataSize = (int)Math.ceil((double)b.getDataSize() / 4.0);
        int metaDataSize = (int)Math.ceil((double)b.getMetaDataSize() / 4.0);
        int blockLength = 12 + 4 * (dataSize + metaDataSize);
        if (buffer.capacity() < blockLength) {
            buffer = ByteBuffer.allocate(blockLength);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        buffer.position(0);
        buffer.limit(blockLength);
        buffer.putInt((int)b.getBlockType());
        buffer.putInt((int)b.getDataSize());
        buffer.putInt((int)b.getMetaDataSize());
        for (i = 0; i < dataSize; ++i) {
            buffer.putInt((int)b.getData()[i]);
        }
        for (i = 0; i < metaDataSize; ++i) {
            buffer.putInt((int)b.getMetaData()[i]);
        }
        buffer.rewind();
        o.write(buffer);
        return blockLength;
    }

    private static DataBlock getHeaderBlock(int declSize, long contSize) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteI16((short)256);
        w.WriteI16((short)0);
        w.WriteU32(0L);
        w.WriteU32(36 + declSize);
        w.WriteU64((long)(36 + declSize) + contSize);
        w.WriteU32(106L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(0x443355L);
        return b;
    }

    private static void WriteMatrix(BitStreamWrite w, float[] mat) {
        for (int i = 0; i < mat.length; ++i) {
            w.WriteF32(mat[i]);
        }
    }

    private static DataBlock getModelNodeBlock(String modelNodeName, String modelResourceName, float[] matrix) {
        BitStreamWrite w = new BitStreamWrite();
        long type = -222L;
        w.WriteString(modelNodeName);
        w.WriteU32(1L);
        w.WriteString("");
        U3DExporter.WriteMatrix(w, matrix);
        w.WriteString(modelResourceName);
        w.WriteU32(3L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-222L);
        return b;
    }

    private static DataBlock getShadingModifierBlock(String shadingModName, String shaderName) {
        BitStreamWrite w = new BitStreamWrite();
        long type = -187L;
        w.WriteString(shadingModName);
        w.WriteU32(1L);
        w.WriteU32(15L);
        w.WriteU32(1L);
        w.WriteU32(1L);
        w.WriteString(shaderName);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-187L);
        return b;
    }

    public static DataBlock getLitTextureShaderBlock(String shaderName, String materialName) {
        BitStreamWrite w = new BitStreamWrite();
        long type = -173L;
        w.WriteString(shaderName);
        w.WriteU32(5L);
        w.WriteF32(0.0f);
        w.WriteU32(1559L);
        w.WriteU32(1542L);
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteString(materialName);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-173L);
        return b;
    }

    public static DataBlock getMaterialResourceBlock(String materialName, float r, float g, float b, float a) {
        BitStreamWrite w = new BitStreamWrite();
        long type = -172L;
        w.WriteString(materialName);
        w.WriteU32(63L);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(r);
        w.WriteF32(g);
        w.WriteF32(b);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.1f);
        w.WriteF32(0.0f);
        w.WriteF32(a);
        DataBlock bl = w.GetDataBlock();
        bl.setBlockType(-172L);
        return bl;
    }

    private static DataBlock getViewModifierChain(String viewname, String viewResourceName) {
        long type = -236L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(viewname);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(U3DExporter.getViewNodeBlock(viewname, viewResourceName));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    private static DataBlock getViewNodeBlock(String viewname, String viewResourceName) {
        long type = -220L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(viewname);
        w.WriteU32(1L);
        w.WriteString("");
        U3DExporter.WriteMatrix(w, new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        w.WriteString(viewResourceName);
        w.WriteU32(0L);
        w.WriteF32(1.0f);
        w.WriteF32(Float.MAX_VALUE);
        w.WriteF32(34.5f);
        w.WriteF32(500.0f);
        w.WriteF32(500.0f);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteU32(0L);
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-220L);
        return b;
    }

    private static DataBlock getViewResourceBlock(String viewResourceName) {
        long type = -174L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(viewResourceName);
        w.WriteU32(1L);
        w.WriteString("");
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteF32(1000.0f);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-174L);
        return b;
    }

    private static DataBlock getNodeModifierChain(String modifierChainName, String modelNodeName, String modelResourceName, String shadingName, String shaderName, float[] matrix) {
        long type = -236L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(modifierChainName);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(2L);
        w.WriteDataBlock(U3DExporter.getModelNodeBlock(modelNodeName, modelResourceName, matrix));
        w.WriteDataBlock(U3DExporter.getShadingModifierBlock(shadingName, shaderName));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    private static DataBlock getLightModifierChain(String modifierChainName, String lightResourceName) {
        long type = -236L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(modifierChainName);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(U3DExporter.getLightNodeBlock(modifierChainName, lightResourceName));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    public static DataBlock getLightNodeBlock(String lightNodeName, String lightResourceName) {
        float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 6.0f, -20.0f, 4.0f, 1.0f};
        long type = -221L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(lightNodeName);
        w.WriteU32(1L);
        w.WriteString("");
        U3DExporter.WriteMatrix(w, matrix);
        w.WriteString(lightResourceName);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-221L);
        return b;
    }

    public static DataBlock getLightResourceBlock(String lightResourceName) {
        long type = -175L;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(lightResourceName);
        w.WriteU32(1L);
        w.WriteU8((short)2);
        w.WriteF32(0.5f);
        w.WriteF32(0.5f);
        w.WriteF32(0.5f);
        w.WriteF32(1.0f);
        w.WriteF32(0.1f);
        w.WriteF32(0.0f);
        w.WriteF32(0.0f);
        w.WriteF32(180.0f);
        w.WriteF32(0.5f);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-175L);
        return b;
    }

    private static DataBlock getMeshDeclarationBlock(Mesh mesh, String meshname) {
        Point3f[] coords = mesh.coords;
        Vector3f[] normals = mesh.normals;
        Color3f[] colors = mesh.colors;
        int[] coordIndices = mesh.coordIndices;
        int[] normalIndices = mesh.normalIndices;
        int[] colorIndices = mesh.colorIndices;
        BitStreamWrite w = new BitStreamWrite();
        long type = -207L;
        w.WriteString(meshname);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(coordIndices.length / 3);
        w.WriteU32(coords.length);
        w.WriteU32(normals.length);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(coords.length);
        w.WriteU32(coords.length);
        w.WriteU32(300L);
        w.WriteU32(300L);
        w.WriteU32(300L);
        w.WriteF32(0.01f);
        w.WriteF32(0.01f);
        w.WriteF32(0.01f);
        w.WriteF32(0.01f);
        w.WriteF32(0.01f);
        w.WriteF32(0.9f);
        w.WriteF32(0.5f);
        w.WriteF32(0.985f);
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-207L);
        return b;
    }

    private static DataBlock getModelResourceModifierChain(String modifierChainName, Mesh mesh, String meshname) {
        BitStreamWrite w = new BitStreamWrite();
        long type = -236L;
        w.WriteString(modifierChainName);
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(U3DExporter.getMeshDeclarationBlock(mesh, meshname));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    private static DataBlock getMeshContinuationBlock(Mesh mesh, String meshname) {
        int i;
        Point3f[] coords = mesh.coords;
        Vector3f[] normals = mesh.normals;
        Color3f[] colors = mesh.colors;
        int[] coordIndices = mesh.coordIndices;
        int[] normalIndices = mesh.normalIndices;
        int[] colorIndices = mesh.colorIndices;
        BitStreamWrite w = new BitStreamWrite();
        long type = -197L;
        w.WriteString(meshname);
        w.WriteU32(0L);
        w.WriteU32(coordIndices.length / 3);
        w.WriteU32(coords.length);
        w.WriteU32(normals.length);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        for (i = 0; i < coords.length; ++i) {
            w.WriteF32(coords[i].x);
            w.WriteF32(coords[i].y);
            w.WriteF32(coords[i].z);
        }
        for (i = 0; i < normals.length; ++i) {
            w.WriteF32(normals[i].x);
            w.WriteF32(normals[i].y);
            w.WriteF32(normals[i].z);
        }
        for (i = 0; i < coordIndices.length; i += 3) {
            w.WriteCompressedU32(1L, 0L);
            for (int j = 0; j < 3; ++j) {
                w.WriteCompressedU32(1024 + coords.length, coordIndices[i + j]);
                w.WriteCompressedU32(1024 + normals.length, normalIndices[i + j]);
            }
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-197L);
        return b;
    }

    public static class Mesh {
        Point3f[] coords;
        Vector3f[] normals;
        Color3f[] colors;
        int[] coordIndices;
        int[] normalIndices;
        int[] colorIndices;
        CustomTriangleMesh ctm;
        String name;
        Color4f color;

        public void getMinMax(Point3f min, Point3f max) {
            for (Point3f p : this.coords) {
                if (p.x > max.x) {
                    max.x = p.x;
                }
                if (p.y > max.y) {
                    max.y = p.y;
                }
                if (p.z > max.z) {
                    max.z = p.z;
                }
                if (p.x < min.x) {
                    min.x = p.x;
                }
                if (p.y < min.y) {
                    min.y = p.y;
                }
                if (!(p.z < min.z)) continue;
                min.z = p.z;
            }
        }

        public void normalizeCoords(Point3f min, Point3f max) {
            float dx = max.x - min.x;
            float dy = max.y - min.y;
            float dz = max.z - min.z;
            float maxd = Math.max(dx, Math.max(dy, dz));
            Point3f center = new Point3f();
            center.add((Tuple3f)min, (Tuple3f)max);
            center.scale(0.5f);
            for (Point3f p : this.coords) {
                p.sub((Tuple3f)center);
                p.scale(1.0f / maxd);
            }
        }

        public Mesh(CustomTriangleMesh mesh, String name, Color3f color, float transparency) {
            this.name = name;
            this.ctm = mesh;
            this.color = new Color4f(color.x, color.y, color.z, 1.0f - transparency);
            TriangleArray g = (TriangleArray)mesh.getGeometry();
            int N = g.getValidVertexCount();
            this.coords = new Point3f[N];
            this.colors = new Color3f[N];
            this.normals = new Vector3f[N];
            for (int i = 0; i < N; ++i) {
                this.coords[i] = new Point3f();
                this.colors[i] = new Color3f();
                this.normals[i] = new Vector3f();
            }
            g.getCoordinates(0, this.coords);
            g.getColors(0, this.colors);
            g.getNormals(0, this.normals);
            HashMap<Point3f, Integer> vertexToIndex = new HashMap<Point3f, Integer>();
            HashMap<Color3f, Integer> colorToIndex = new HashMap<Color3f, Integer>();
            HashMap<Vector3f, Integer> normalToIndex = new HashMap<Vector3f, Integer>();
            int nFaces = N;
            this.coordIndices = new int[nFaces];
            this.colorIndices = new int[nFaces];
            this.normalIndices = new int[nFaces];
            ArrayList<Point3f> vList = new ArrayList<Point3f>();
            ArrayList<Color3f> cList = new ArrayList<Color3f>();
            ArrayList<Vector3f> nList = new ArrayList<Vector3f>();
            for (int i = 0; i < N; ++i) {
                Point3f v = this.coords[i];
                Color3f c = this.colors[i];
                Vector3f n = this.normals[i];
                if (!vertexToIndex.containsKey(v)) {
                    Point3f newp = new Point3f(v);
                    vertexToIndex.put(newp, vList.size());
                    vList.add(newp);
                }
                this.coordIndices[i] = (Integer)vertexToIndex.get(v);
                if (!colorToIndex.containsKey(c)) {
                    Color3f newc = new Color3f(c);
                    colorToIndex.put(newc, cList.size());
                    cList.add(newc);
                }
                this.colorIndices[i] = (Integer)colorToIndex.get(c);
                if (!normalToIndex.containsKey(n)) {
                    Vector3f newn = new Vector3f(n);
                    normalToIndex.put(newn, nList.size());
                    nList.add(newn);
                }
                this.normalIndices[i] = (Integer)normalToIndex.get(n);
            }
            this.coords = new Point3f[vList.size()];
            vList.toArray(this.coords);
            this.normals = new Vector3f[nList.size()];
            nList.toArray(this.normals);
            this.colors = new Color3f[cList.size()];
            cList.toArray(this.colors);
        }
    }
}

