/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.Primitive;
import java.util.List;
import org.scijava.vecmath.Matrix4f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class Tube
extends Primitive {
    public static final int DEFAULT_PARALLELS = 12;

    public Tube(List<Point3f> points, float r) {
        this(points, r, 12);
    }

    public Tube(List<Point3f> points, float r, int parallels) {
        super(Tube.makeVertices(points, r, parallels), Tube.makeFaces(points.size(), parallels));
    }

    private static Point3f[] makeVertices(List<Point3f> points, float r, int parallels) {
        int i;
        Point3f[] p = new Point3f[points.size() * parallels];
        Point3f p0 = points.get(0);
        Point3f p1 = points.get(1);
        for (int i2 = 0; i2 < parallels; ++i2) {
            double a = (double)(i2 - 6) * (Math.PI * 2) / 12.0;
            double c = (double)r * Math.cos(a);
            double s = (double)r * Math.sin(a);
            p[i2] = new Point3f((float)c, (float)s, 0.0f);
        }
        Matrix4f ry = new Matrix4f();
        float ay = (float)Math.atan2(p1.x - p0.x, p1.z - p0.z);
        ry.rotY(ay);
        Matrix4f rx = new Matrix4f();
        float ax = -((float)Math.asin((p1.y - p0.y) / p1.distance(p0)));
        rx.rotX(ax);
        rx.mul(ry, rx);
        for (int i3 = 0; i3 < parallels; ++i3) {
            Point3f pi = p[i3];
            rx.transform(pi);
            pi.add((Tuple3f)p0);
        }
        for (int pi = 1; pi < points.size() - 1; ++pi) {
            p0 = points.get(pi - 1);
            p1 = points.get(pi);
            Point3f p2 = points.get(pi + 1);
            Vector3f p0p1 = new Vector3f();
            p0p1.sub((Tuple3f)p1, (Tuple3f)p0);
            Vector3f p1p2 = new Vector3f();
            p1p2.sub((Tuple3f)p2, (Tuple3f)p1);
            p0p1.normalize();
            p1p2.normalize();
            Vector3f plane = new Vector3f();
            plane.add((Tuple3f)p0p1);
            plane.add((Tuple3f)p1p2);
            plane.normalize();
            Vector3f transl = new Vector3f();
            transl.sub((Tuple3f)p1, (Tuple3f)p0);
            for (int i4 = 0; i4 < parallels; ++i4) {
                int idx0 = (pi - 1) * parallels + i4;
                int idx1 = pi * parallels + i4;
                p[idx1] = new Point3f(p[idx0]);
                p[idx1].add((Tuple3f)transl);
                p[idx1] = Tube.intersect(p[idx0], p[idx1], plane, p1);
            }
        }
        p0 = points.get(points.size() - 2);
        p1 = points.get(points.size() - 1);
        int offset = (points.size() - 1) * parallels;
        for (i = 0; i < parallels; ++i) {
            double a = (double)(i - 6) * (Math.PI * 2) / 12.0;
            double c = (double)r * Math.cos(a);
            double s = (double)r * Math.sin(a);
            p[offset + i] = new Point3f((float)c, (float)s, 0.0f);
        }
        ry = new Matrix4f();
        ay = (float)Math.atan2(p1.x - p0.x, p1.z - p0.z);
        ry.rotY(ay);
        rx = new Matrix4f();
        ax = -((float)Math.asin((p1.y - p0.y) / p1.distance(p0)));
        rx.rotX(ax);
        rx.mul(ry, rx);
        for (i = 0; i < parallels; ++i) {
            Point3f pi = p[offset + i];
            rx.transform(pi);
            pi.add((Tuple3f)p1);
        }
        return p;
    }

    private static int[] makeFaces(int nPts, int parallels) {
        int idx = 0;
        int[] faces = new int[6 * parallels * (nPts - 1)];
        for (int pi = 0; pi < nPts - 1; ++pi) {
            int offs0 = pi * parallels;
            int offs1 = (pi + 1) * parallels;
            for (int i = 0; i < parallels; ++i) {
                faces[idx++] = offs0 + i;
                faces[idx++] = offs1 + i;
                faces[idx++] = offs1 + (i + 1) % parallels;
                faces[idx++] = offs0 + i;
                faces[idx++] = offs1 + (i + 1) % parallels;
                faces[idx++] = offs0 + (i + 1) % parallels;
            }
        }
        return faces;
    }

    private static Point3f intersect(Point3f p1, Point3f p2, Vector3f n, Point3f p3) {
        Vector3f v1 = new Vector3f();
        v1.sub((Tuple3f)p3, (Tuple3f)p1);
        Vector3f v2 = new Vector3f();
        v2.sub((Tuple3f)p2, (Tuple3f)p1);
        float u = n.dot(v1) / n.dot(v2);
        Point3f res = new Point3f();
        res.scaleAdd(u, (Tuple3f)v2, (Tuple3f)p1);
        return res;
    }
}

