/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.Primitive;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;

public class Sphere
extends Primitive {
    public static final int DEFAULT_MERIDIANS = 12;
    public static final int DEFAULT_PARALLELS = 12;

    public Sphere(Point3f center, float radius) {
        this(center, radius, 12, 12);
    }

    public Sphere(Point3f center, float radius, int meridians, int parallels) {
        super(Sphere.makeVertices(center, radius, meridians, parallels), Sphere.makeFaces(meridians, parallels));
    }

    private static int[] makeFaces(int meridians, int parallels) {
        int lv = (parallels - 2) * meridians + 2;
        int N = 3 * (meridians + meridians + 2 * (parallels - 1) * meridians);
        int[] faces = new int[N];
        int i = 0;
        int offs = 1;
        for (int m = 0; m < meridians; ++m) {
            faces[i++] = 0;
            faces[i++] = offs + m;
            faces[i++] = offs + (m + 1) % meridians;
        }
        for (int p = 1; p < parallels - 2; ++p) {
            offs = 1 + (p - 1) * meridians;
            for (int m = 0; m < meridians; ++m) {
                int f1 = offs + m;
                int f2 = offs + (m + 1) % meridians;
                int f3 = offs + parallels + m;
                int f4 = offs + parallels + (m + 1) % meridians;
                if (f1 >= lv) {
                    throw new RuntimeException("p = " + p + " m = " + m + " f1 + " + f1);
                }
                if (f2 >= lv) {
                    throw new RuntimeException("p = " + p + " m = " + m + " f2 + " + f2);
                }
                if (f3 >= lv) {
                    throw new RuntimeException("p = " + p + " m = " + m + " f3 + " + f3);
                }
                if (f4 >= lv) {
                    throw new RuntimeException("p = " + p + " m = " + m + " f4 + " + f4);
                }
                faces[i++] = f1;
                faces[i++] = f3;
                faces[i++] = f4;
                faces[i++] = f1;
                faces[i++] = f4;
                faces[i++] = f2;
            }
        }
        int last = parallels * (meridians - 2) + 1;
        int p = parallels - 2;
        offs = 1 + (p - 1) * meridians;
        for (int m = 0; m < meridians; ++m) {
            faces[i++] = offs + m;
            faces[i++] = last;
            faces[i++] = offs + (m + 1) % meridians;
        }
        return faces;
    }

    private static Point3f[] makeVertices(Point3f center, float radius, int meridians, int parallels) {
        if (meridians < 3) {
            meridians = 3;
        }
        if (parallels < 3) {
            parallels = 3;
        }
        double da = Math.PI * 2 / (double)meridians;
        double[][] xy_points = new double[meridians + 1][2];
        xy_points[0][0] = 1.0;
        xy_points[0][1] = 0.0;
        for (int m = 1; m < meridians; ++m) {
            double angle = da * (double)m;
            xy_points[m][0] = Math.cos(angle);
            xy_points[m][1] = Math.sin(angle);
        }
        xy_points[xy_points.length - 1][0] = 1.0;
        xy_points[xy_points.length - 1][1] = 0.0;
        da = Math.PI / (double)parallels;
        Point3f[] xyz = new Point3f[(parallels - 2) * meridians + 2];
        int i = 0;
        xyz[i++] = new Point3f(0.0f, 0.0f, 1.0f);
        for (int p = 1; p < parallels - 1; ++p) {
            double r = Math.sin(da * (double)p);
            double Z = Math.cos(da * (double)p);
            for (int mm = 0; mm < meridians; ++mm) {
                xyz[i++] = new Point3f((float)(xy_points[mm][0] * r), (float)(xy_points[mm][1] * r), (float)Z);
            }
        }
        xyz[i++] = new Point3f(0.0f, 0.0f, -1.0f);
        for (Point3f p : xyz) {
            p.scaleAdd(radius, (Tuple3f)p, (Tuple3f)center);
        }
        return xyz;
    }
}

