/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class FullInfoMesh {
    ArrayList<Integer> faces;
    ArrayList<Vertex> vertices;
    HashMap<Point3f, Integer> vertexToIndex;
    HashMap<Edge, Edge> edges;
    HashSet<Triangle> triangles;
    private final Vector3f tmpv1 = new Vector3f();
    private final Vector3f tmpv2 = new Vector3f();

    public FullInfoMesh() {
        this.faces = new ArrayList();
        this.vertices = new ArrayList();
        this.vertexToIndex = new HashMap();
        this.triangles = new HashSet();
        this.edges = new HashMap();
    }

    public FullInfoMesh(List<Point3f> mesh) {
        this();
        for (int i = 0; i < mesh.size(); i += 3) {
            int f1 = this.addVertex(mesh.get(i));
            int f2 = this.addVertex(mesh.get(i + 1));
            int f3 = this.addVertex(mesh.get(i + 2));
            this.addFace(f1, f2, f3);
        }
    }

    public List<Point3f> getMesh() {
        ArrayList<Point3f> ret = new ArrayList<Point3f>();
        for (int i = 0; i < this.faces.size(); ++i) {
            int f = this.getFace(i);
            if (f == -1) continue;
            ret.add(new Point3f((Point3f)this.getVertex(f)));
        }
        return ret;
    }

    public Set<Point3f> getVertices() {
        return this.vertexToIndex.keySet();
    }

    public void moveVertex(int vIdx, Vector3f displacement) {
        Point3f p = this.vertices.get(vIdx);
        this.vertexToIndex.remove(p);
        p.add((Tuple3f)displacement);
        this.vertexToIndex.put(p, vIdx);
    }

    public int getIndex(Point3f v) {
        if (this.vertexToIndex.containsKey(v)) {
            return this.vertexToIndex.get(v);
        }
        return -1;
    }

    public int getVertexCount() {
        return this.vertexToIndex.size();
    }

    public Vertex getVertex(int i) {
        return this.vertices.get(i);
    }

    public int getFaceCount() {
        return this.faces.size();
    }

    public int getFace(int i) {
        return this.faces.get(i);
    }

    public int addVertex(Point3f p) {
        if (this.vertexToIndex.containsKey(p)) {
            return this.vertexToIndex.get(p);
        }
        Vertex v = new Vertex(p);
        this.vertices.add(v);
        int idx = this.vertices.size() - 1;
        this.vertexToIndex.put(v, idx);
        return idx;
    }

    public void removeVertex(Point3f p) {
        this.removeVertex(this.vertexToIndex.get(p));
    }

    public void removeVertex(int vIdx) {
        Vertex v = this.getVertex(vIdx);
        ArrayList<Integer> toRemove = new ArrayList<Integer>(v.triangles);
        for (int f : toRemove) {
            this.removeFace(f);
        }
        v = this.vertices.get(vIdx);
    }

    public void removeFace(int fIdx) {
        int f1 = this.getFace(3 * fIdx);
        int f2 = this.getFace(3 * fIdx + 1);
        int f3 = this.getFace(3 * fIdx + 2);
        if (f1 == -1 && f2 == -1 && f3 == -1) {
            return;
        }
        boolean b = this.triangles.remove(new Triangle(f1, f2, f3));
        assert (b);
        this.faces.set(3 * fIdx, -1);
        this.faces.set(3 * fIdx + 1, -1);
        this.faces.set(3 * fIdx + 2, -1);
        Vertex v1 = this.getVertex(f1);
        Vertex v2 = this.getVertex(f2);
        Vertex v3 = this.getVertex(f3);
        Edge etmp = new Edge(f1, f2);
        etmp = this.edges.get(etmp);
        etmp.removeTriangle(fIdx);
        if (etmp.nTriangles() == 0) {
            v1.removeEdge(etmp);
            v2.removeEdge(etmp);
            this.edges.remove(etmp);
        }
        etmp = new Edge(f2, f3);
        etmp = this.edges.get(etmp);
        etmp.removeTriangle(fIdx);
        if (etmp.nTriangles() == 0) {
            v2.removeEdge(etmp);
            v3.removeEdge(etmp);
            this.edges.remove(etmp);
        }
        etmp = new Edge(f3, f1);
        etmp = this.edges.get(etmp);
        etmp.removeTriangle(fIdx);
        if (etmp.nTriangles() == 0) {
            v3.removeEdge(etmp);
            v1.removeEdge(etmp);
            this.edges.remove(etmp);
        }
        v1.removeTriangle(fIdx);
        v2.removeTriangle(fIdx);
        v3.removeTriangle(fIdx);
        if (v1.triangles.size() == 0) {
            this.vertexToIndex.remove((Object)v1);
            this.vertices.set(f1, null);
        }
        if (v2.triangles.size() == 0) {
            this.vertexToIndex.remove((Object)v2);
            this.vertices.set(f2, null);
        }
        if (v3.triangles.size() == 0) {
            this.vertexToIndex.remove((Object)v3);
            this.vertices.set(f3, null);
        }
    }

    public void addFace(int f1, int f2, int f3) {
        Triangle tri = new Triangle(f1, f2, f3);
        if (this.triangles.contains(tri)) {
            return;
        }
        this.triangles.add(tri);
        Vertex v1 = this.getVertex(f1);
        Vertex v2 = this.getVertex(f2);
        Vertex v3 = this.getVertex(f3);
        Edge e1 = new Edge(f2, f3);
        Edge e2 = new Edge(f3, f1);
        Edge e3 = new Edge(f1, f2);
        Edge etmp = this.edges.get(e1);
        if (etmp != null) {
            e1 = etmp;
        } else {
            this.edges.put(e1, e1);
        }
        etmp = this.edges.get(e2);
        if (etmp != null) {
            e2 = etmp;
        } else {
            this.edges.put(e2, e2);
        }
        etmp = this.edges.get(e3);
        if (etmp != null) {
            e3 = etmp;
        } else {
            this.edges.put(e3, e3);
        }
        v1.addEdges(e2, e3);
        v2.addEdges(e1, e3);
        v3.addEdges(e1, e2);
        int fIdx = this.faces.size() / 3;
        this.faces.add(f1);
        this.faces.add(f2);
        this.faces.add(f3);
        e1.addTriangle(fIdx);
        e2.addTriangle(fIdx);
        e3.addTriangle(fIdx);
        v1.addTriangle(fIdx);
        v2.addTriangle(fIdx);
        v3.addTriangle(fIdx);
    }

    public void getFaceNormal(int fIdx, Vector3f ret) {
        int f1 = this.getFace(3 * fIdx);
        int f2 = this.getFace(3 * fIdx + 1);
        int f3 = this.getFace(3 * fIdx + 2);
        Vertex v1 = this.getVertex(f1);
        Vertex v2 = this.getVertex(f2);
        Vertex v3 = this.getVertex(f3);
        this.tmpv1.sub((Tuple3f)v2, (Tuple3f)v1);
        this.tmpv2.sub((Tuple3f)v3, (Tuple3f)v1);
        ret.cross(this.tmpv1, this.tmpv2);
    }

    public void getVertexNormal(Vertex v, Vector3f ret) {
        ret.set(0.0f, 0.0f, 0.0f);
        Vector3f tn = new Vector3f();
        for (int fIdx : v.triangles) {
            this.getFaceNormal(fIdx, tn);
            ret.add((Tuple3f)tn);
        }
        ret.normalize();
    }

    public void getVertexNormal(int vIdx, Vector3f ret) {
        Vertex v = this.getVertex(vIdx);
        this.getVertexNormal(v, ret);
    }

    public int contractEdge(Edge e, Point3f p) {
        if (!this.edges.containsKey(e)) {
            throw new IllegalArgumentException("no edge " + e);
        }
        Vertex v1 = this.getVertex(e.p1);
        HashSet<Integer> remainingTri = new HashSet<Integer>();
        remainingTri.addAll(v1.triangles);
        remainingTri.removeAll(e.triangles);
        ArrayList<Integer> remainingFaces = new ArrayList<Integer>();
        Iterator iterator = remainingTri.iterator();
        while (iterator.hasNext()) {
            int fIdx = (Integer)iterator.next();
            remainingFaces.add(this.getFace(3 * fIdx));
            remainingFaces.add(this.getFace(3 * fIdx + 1));
            remainingFaces.add(this.getFace(3 * fIdx + 2));
        }
        this.removeVertex(e.p1);
        int vIdx = -1;
        if (this.vertexToIndex.containsKey(p)) {
            vIdx = this.vertexToIndex.get(p);
        } else {
            Vertex v = new Vertex(p);
            vIdx = e.p1;
            this.vertices.set(vIdx, v);
            this.vertexToIndex.put(v, vIdx);
        }
        for (int i = 0; i < remainingFaces.size(); i += 3) {
            int f1 = (Integer)remainingFaces.get(i);
            int f2 = (Integer)remainingFaces.get(i + 1);
            int f3 = (Integer)remainingFaces.get(i + 2);
            if (f1 == e.p1) {
                this.addFace(vIdx, f2, f3);
            }
            if (f2 == e.p1) {
                this.addFace(f1, vIdx, f3);
            }
            if (f3 != e.p1) continue;
            this.addFace(f1, f2, vIdx);
        }
        Vertex v2 = this.getVertex(e.p2);
        remainingTri = new HashSet();
        remainingTri.addAll(v2.triangles);
        remainingTri.removeAll(e.triangles);
        remainingFaces = new ArrayList();
        Iterator f1 = remainingTri.iterator();
        while (f1.hasNext()) {
            int fIdx = (Integer)f1.next();
            remainingFaces.add(this.getFace(3 * fIdx));
            remainingFaces.add(this.getFace(3 * fIdx + 1));
            remainingFaces.add(this.getFace(3 * fIdx + 2));
        }
        this.removeVertex(e.p2);
        for (int i = 0; i < remainingFaces.size(); i += 3) {
            int f12 = (Integer)remainingFaces.get(i);
            int f2 = (Integer)remainingFaces.get(i + 1);
            int f3 = (Integer)remainingFaces.get(i + 2);
            if (f12 == e.p2) {
                this.addFace(vIdx, f2, f3);
            }
            if (f2 == e.p2) {
                this.addFace(f12, vIdx, f3);
            }
            if (f3 != e.p2) continue;
            this.addFace(f12, f2, vIdx);
        }
        return vIdx;
    }

    public ArrayList<ArrayList<Point3f>> getSubmeshes() {
        HashSet<Vertex> open = new HashSet<Vertex>();
        open.addAll(this.vertices);
        open.remove(null);
        ArrayList<ArrayList<Point3f>> ret = new ArrayList<ArrayList<Point3f>>();
        while (!open.isEmpty()) {
            HashSet<Integer> meshSet = new HashSet<Integer>();
            LinkedList<Integer> queue = new LinkedList<Integer>();
            Vertex start = (Vertex)((Object)open.iterator().next());
            open.remove((Object)start);
            queue.add(this.vertexToIndex.get((Object)start));
            while (!queue.isEmpty()) {
                Integer vIdx = (Integer)queue.poll();
                meshSet.add(vIdx);
                Vertex v = this.getVertex(vIdx);
                for (Edge e : v.edges) {
                    int nIdx = e.p1 == vIdx ? e.p2 : e.p1;
                    Vertex n = this.getVertex(nIdx);
                    if (!open.contains((Object)n)) continue;
                    open.remove((Object)n);
                    queue.offer(nIdx);
                }
            }
            ArrayList<Vertex> tris = new ArrayList<Vertex>();
            for (int f : this.faces) {
                if (f == -1 || !meshSet.contains(f)) continue;
                tris.add(this.getVertex(f));
            }
            ret.add(tris);
        }
        return ret;
    }

    protected static final class Edge {
        public final int p1;
        public final int p2;
        final HashSet<Integer> triangles;

        Edge(int p1, int p2) {
            this.p1 = p1;
            this.p2 = p2;
            this.triangles = new HashSet();
        }

        public boolean equals(Object o) {
            Edge e = (Edge)o;
            return this.p1 == e.p1 && this.p2 == e.p2 || this.p1 == e.p2 && this.p2 == e.p1;
        }

        public int hashCode() {
            return this.p1 * this.p2;
        }

        private void addTriangle(int i) {
            this.triangles.add(i);
        }

        private void removeTriangle(int i) {
            this.triangles.remove(i);
        }

        public int nTriangles() {
            return this.triangles.size();
        }
    }

    protected static final class Triangle {
        public final int f1;
        public final int f2;
        public final int f3;

        private Triangle(int f1, int f2, int f3) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        public int hashCode() {
            return this.f1 * this.f2 * this.f3;
        }

        public boolean equals(Object o) {
            int tmp;
            Triangle r = (Triangle)o;
            int tf1 = this.f1;
            int tf2 = this.f2;
            int tf3 = this.f3;
            if (tf2 < tf1) {
                tmp = tf1;
                tf1 = tf2;
                tf2 = tmp;
            }
            if (tf3 < tf2) {
                tmp = tf2;
                tf2 = tf3;
                tf3 = tmp;
            }
            if (tf2 < tf1) {
                tmp = tf1;
                tf1 = tf2;
                tf2 = tmp;
            }
            int rf1 = r.f1;
            int rf2 = r.f2;
            int rf3 = r.f3;
            if (rf2 < rf1) {
                tmp = rf1;
                rf1 = rf2;
                rf2 = tmp;
            }
            if (rf3 < rf2) {
                tmp = rf2;
                rf2 = rf3;
                rf3 = tmp;
            }
            if (rf2 < rf1) {
                tmp = rf1;
                rf1 = rf2;
                rf2 = tmp;
            }
            return tf1 == rf1 && tf2 == rf2 && tf3 == rf3;
        }
    }

    protected static final class Vertex
    extends Point3f {
        final HashSet<Edge> edges = new HashSet();
        final HashSet<Integer> triangles = new HashSet();

        public Set<Edge> getEdges() {
            return this.edges;
        }

        public Set<Integer> getTriangles() {
            return this.triangles;
        }

        private Vertex(Point3f p) {
            super(p);
        }

        private void addEdge(Edge e) {
            this.edges.add(e);
        }

        private void addEdges(Edge e1, Edge e2) {
            this.addEdge(e1);
            this.addEdge(e2);
        }

        private void removeEdge(Edge e) {
            this.edges.remove(e);
        }

        private void addTriangle(int i) {
            this.triangles.add(i);
        }

        private void removeTriangle(int i) {
            this.triangles.remove(i);
        }
    }
}

