/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomTriangleMesh;
import ij3d.Image3DUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Material;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.java3d.TriangleArray;
import org.scijava.java3d.utils.geometry.GeometryInfo;
import org.scijava.java3d.utils.geometry.NormalGenerator;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3f;

public class CustomTransparentTriangleMesh
extends CustomTriangleMesh {
    private final double volume = 0.0;

    public CustomTransparentTriangleMesh(List<Point3f> mesh) {
        this(mesh, DEFAULT_COLOR, 0.0f);
    }

    public CustomTransparentTriangleMesh(List<Point3f> mesh, Color3f col, float trans) {
        super(mesh, col, trans);
    }

    @Override
    public float getVolume() {
        return 0.0f;
    }

    @Override
    public void setColor(Color3f color) {
        this.color = color != null ? color : DEFAULT_COLOR;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        int N = ga.getVertexCount();
        Color4f[] colors = new Color4f[N];
        for (int i = 0; i < N; ++i) {
            colors[i] = new Color4f(this.color.x, this.color.y, this.color.z, 1.0f);
        }
        ga.setColors(0, colors);
        this.changed = true;
    }

    @Override
    public void setTransparency(float t) {
    }

    public void setTransparentColor(List<Color4f> color) {
        this.color = null;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        int N = ga.getValidVertexCount();
        if (color.size() != N) {
            throw new IllegalArgumentException("list of size " + N + " expected");
        }
        Color4f[] colors = new Color4f[N];
        color.toArray(colors);
        ga.setColors(0, colors);
        this.changed = true;
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.mesh == null || this.mesh.size() < 3) {
            return null;
        }
        List tri = this.mesh;
        int nValid = tri.size();
        int nAll = 2 * nValid;
        Point3f[] coords = new Point3f[nValid];
        tri.toArray(coords);
        Object[] colors = new Color4f[nValid];
        if (null == this.color) {
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color4f(CustomTransparentTriangleMesh.DEFAULT_COLOR.x, CustomTransparentTriangleMesh.DEFAULT_COLOR.y, CustomTransparentTriangleMesh.DEFAULT_COLOR.z, 1.0f);
            }
            GeometryArray gaOld = (GeometryArray)this.getGeometry();
            if (null != gaOld) {
                gaOld.getColors(0, (Color4f[])colors);
            }
        } else {
            Arrays.fill(colors, new Color4f(this.color.x, this.color.y, this.color.z, 1.0f));
        }
        TriangleArray ta = new TriangleArray(nAll, 15);
        ta.setCoordinates(0, coords);
        ta.setColors(0, (Color4f[])colors);
        GeometryInfo gi = new GeometryInfo((GeometryArray)ta);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray result = gi.getGeometryArray();
        result.setCapability(5);
        result.setCapability(3);
        result.setCapability(1);
        result.setCapability(20);
        result.setCapability(8);
        result.setCapability(17);
        result.setCapability(18);
        result.setValidVertexCount(nValid);
        return result;
    }

    @Override
    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        if (this.shaded) {
            polyAttrib.setPolygonMode(2);
        } else {
            polyAttrib.setPolygonMode(1);
        }
        polyAttrib.setCullFace(0);
        polyAttrib.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        if (null != this.color) {
            colorAttrib.setColor(this.color);
        }
        appearance.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        boolean mode = false;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(0);
        tr.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    public static void main(String[] args) {
        Image3DUniverse u = new Image3DUniverse();
        u.show();
        ArrayList<Point3f> pts = new ArrayList<Point3f>();
        pts.add(new Point3f(0.0f, 0.0f, 0.0f));
        pts.add(new Point3f(1.0f, 0.0f, 0.0f));
        pts.add(new Point3f(1.0f, 1.0f, 0.0f));
        CustomTransparentTriangleMesh m = new CustomTransparentTriangleMesh(pts);
        ArrayList<Color4f> cols = new ArrayList<Color4f>();
        cols.add(new Color4f(0.0f, 1.0f, 1.0f, 0.0f));
        cols.add(new Color4f(1.0f, 0.0f, 1.0f, 0.5f));
        cols.add(new Color4f(1.0f, 1.0f, 0.0f, 1.0f));
        m.setTransparentColor(cols);
        u.addCustomMesh(m, "lkjl");
    }
}

