/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomTriangleMesh;
import java.util.Arrays;
import java.util.List;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.QuadArray;
import org.scijava.java3d.utils.geometry.GeometryInfo;
import org.scijava.java3d.utils.geometry.NormalGenerator;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class CustomQuadMesh
extends CustomTriangleMesh {
    private final Point3f[] fourPoints = new Point3f[4];

    public CustomQuadMesh(List<Point3f> mesh) {
        super(mesh);
    }

    public CustomQuadMesh(List<Point3f> mesh, Color3f color, float trans) {
        super(mesh, color, trans);
    }

    public void addQuads(Point3f[] v) {
        if (v.length % 4 != 0) {
            throw new IllegalArgumentException("Number must be a multiple of 4");
        }
        this.addVertices(v);
    }

    public void addQuad(Point3f p1, Point3f p2, Point3f p3, Point3f p4) {
        this.fourPoints[0] = p1;
        this.fourPoints[1] = p2;
        this.fourPoints[2] = p3;
        this.fourPoints[3] = p4;
        this.addVertices(this.fourPoints);
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.mesh == null || this.mesh.size() < 4) {
            return null;
        }
        List tri = this.mesh;
        int nValid = tri.size();
        int nAll = 2 * nValid;
        Point3f[] coords = new Point3f[nValid];
        tri.toArray(coords);
        Object[] colors = new Color3f[nValid];
        Arrays.fill(colors, this.color);
        QuadArray ta = new QuadArray(nAll, 7);
        ta.setCoordinates(0, coords);
        ta.setColors(0, (Color3f[])colors);
        GeometryInfo gi = new GeometryInfo((GeometryArray)ta);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray result = gi.getGeometryArray();
        result.setValidVertexCount(nValid);
        result.setCapability(5);
        result.setCapability(3);
        result.setCapability(1);
        result.setCapability(20);
        result.setCapability(8);
        result.setCapability(17);
        result.setCapability(18);
        return result;
    }
}

