/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import java.util.Arrays;
import java.util.List;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Material;
import org.scijava.java3d.PointArray;
import org.scijava.java3d.PointAttributes;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class CustomPointMesh
extends CustomMesh {
    public static final float DEFAULT_POINT_SIZE = 1.0f;
    private float pointsize = 1.0f;
    private final Point3f[] onePoint = new Point3f[1];

    public CustomPointMesh(List<Point3f> mesh) {
        super(mesh);
    }

    public CustomPointMesh(List<Point3f> mesh, Color3f color, float transparency) {
        super(mesh, color, transparency);
    }

    public float getPointSize() {
        return this.pointsize;
    }

    public void setPointSize(float pointsize) {
        this.pointsize = pointsize;
        this.getAppearance().getPointAttributes().setPointSize(pointsize);
    }

    public void setAntiAliasing(boolean b) {
        this.getAppearance().getPointAttributes().setPointAntialiasingEnable(b);
    }

    public void addPoints(Point3f[] v) {
        this.addVertices(v);
    }

    public void addPoint(Point3f p) {
        this.onePoint[0] = p;
        this.addVertices(this.onePoint);
    }

    @Override
    public float getVolume() {
        return 0.0f;
    }

    @Override
    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        appearance.setCapability(16);
        PointAttributes pointAttrib = new PointAttributes();
        pointAttrib.setCapability(3);
        pointAttrib.setCapability(1);
        pointAttrib.setPointSize(this.pointsize);
        appearance.setPointAttributes(pointAttrib);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        polyAttrib.setPolygonMode(2);
        polyAttrib.setCullFace(1);
        polyAttrib.setBackFaceNormalFlip(false);
        appearance.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        colorAttrib.setColor(this.color);
        appearance.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        int mode = this.transparency == 0.0f ? 4 : 0;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(mode);
        tr.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.mesh == null || this.mesh.size() == 0) {
            return null;
        }
        List tri = this.mesh;
        int nValid = tri.size();
        int nAll = 2 * nValid;
        Point3f[] coords = new Point3f[nValid];
        tri.toArray(coords);
        Object[] colors = new Color3f[nValid];
        Arrays.fill(colors, this.color);
        PointArray ta = null;
        ta = new PointArray(nAll, 5);
        ta.setValidVertexCount(nValid);
        ta.setCoordinates(0, coords);
        ta.setColors(0, (Color3f[])colors);
        ta.setCapability(3);
        ta.setCapability(1);
        ta.setCapability(20);
        ta.setCapability(8);
        ta.setCapability(18);
        return ta;
    }
}

