/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.WavefrontExporter;
import customnode.WavefrontLoader;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.process.StackConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryStripArray;
import org.scijava.java3d.Material;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.java3d.utils.geometry.GeometryInfo;
import org.scijava.java3d.utils.geometry.NormalGenerator;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import vib.InterpolatedImage;

public abstract class CustomMesh
extends Shape3D {
    public static final Color3f DEFAULT_COLOR = new Color3f(0.0f, 1.0f, 0.0f);
    protected Color3f color = DEFAULT_COLOR;
    protected List<Point3f> mesh = null;
    protected float transparency = 0.0f;
    protected boolean shaded = true;
    protected String loadedFromName = null;
    protected String loadedFromFile = null;
    protected boolean changed = false;
    private final int[] valid = new int[1];

    protected CustomMesh() {
    }

    protected CustomMesh(List<Point3f> mesh) {
        this(mesh, DEFAULT_COLOR, 0.0f);
    }

    protected CustomMesh(List<Point3f> mesh, Color3f color, float transp) {
        this.mesh = mesh;
        if (color != null) {
            this.color = color;
        }
        this.transparency = transp;
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.update();
    }

    public String getFile() {
        return this.loadedFromFile;
    }

    public String getName() {
        return this.loadedFromName;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void update() {
        this.setGeometry((Geometry)this.createGeometry());
        this.setAppearance(this.createAppearance());
        this.changed = true;
    }

    public List getMesh() {
        return this.mesh;
    }

    public Color3f getColor() {
        return this.color;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public boolean isShaded() {
        return this.shaded;
    }

    public void setShaded(boolean b) {
        this.shaded = b;
        PolygonAttributes pa = this.getAppearance().getPolygonAttributes();
        if (b) {
            pa.setPolygonMode(2);
        } else {
            pa.setPolygonMode(1);
        }
    }

    public void calculateMinMaxCenterPoint(Point3f min, Point3f max, Point3f center) {
        if (this.mesh == null || this.mesh.size() == 0) {
            min.set(0.0f, 0.0f, 0.0f);
            max.set(0.0f, 0.0f, 0.0f);
            center.set(0.0f, 0.0f, 0.0f);
            return;
        }
        min.z = Float.MAX_VALUE;
        min.y = Float.MAX_VALUE;
        min.x = Float.MAX_VALUE;
        max.z = -3.4028235E38f;
        max.y = -3.4028235E38f;
        max.x = -3.4028235E38f;
        for (int i = 0; i < this.mesh.size(); ++i) {
            Point3f p = this.mesh.get(i);
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (!(p.z > max.z)) continue;
            max.z = p.z;
        }
        center.x = (max.x + min.x) / 2.0f;
        center.y = (max.y + min.y) / 2.0f;
        center.z = (max.z + min.z) / 2.0f;
    }

    public abstract float getVolume();

    protected void addVerticesToGeometryStripArray(Point3f[] v) {
        this.changed = true;
        this.mesh.addAll(Arrays.asList(v));
        GeometryStripArray ga = (GeometryStripArray)this.getGeometry();
        int max = ga.getVertexCount();
        ga.getStripVertexCounts(this.valid);
        int idx = this.valid[0];
        if (idx + v.length > max) {
            this.setGeometry((Geometry)this.createGeometry());
            return;
        }
        this.valid[0] = idx + v.length;
        ga.setStripVertexCounts(this.valid);
        ga.setCoordinates(idx, v);
        Object[] colors = new Color3f[v.length];
        Arrays.fill(colors, this.color);
        ga.setColors(idx, (Color3f[])colors);
        this.recalculateNormals((GeometryArray)ga);
    }

    protected void addVerticesToGeometryArray(Point3f[] v) {
        this.changed = true;
        this.mesh.addAll(Arrays.asList(v));
        GeometryArray ga = (GeometryArray)this.getGeometry();
        int max = ga.getVertexCount();
        int idx = ga.getValidVertexCount();
        if (idx + v.length > max) {
            this.setGeometry((Geometry)this.createGeometry());
            return;
        }
        ga.setValidVertexCount(idx + v.length);
        ga.setCoordinates(idx, v);
        Object[] colors = new Color3f[v.length];
        Arrays.fill(colors, this.color);
        ga.setColors(idx, (Color3f[])colors);
        this.recalculateNormals(ga);
    }

    public int[] vertexIndicesOfPoint(Point3f p) {
        int N = this.mesh.size();
        int[] indices = new int[N];
        int i = 0;
        for (int v = 0; v < N; ++v) {
            if (this.mesh.get(v) == null || !this.mesh.get(v).equals((Tuple3f)p)) continue;
            indices[i++] = v;
        }
        int[] ret = new int[i];
        System.arraycopy(indices, 0, ret, 0, i);
        return ret;
    }

    public void setCoordinate(int i, Point3f p) {
        this.changed = true;
        ((GeometryArray)this.getGeometry()).setCoordinate(i, p);
        this.mesh.get(i).set((Tuple3f)p);
    }

    public void setCoordinates(int[] indices, Point3f p) {
        this.changed = true;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        for (int i = 0; i < indices.length; ++i) {
            ga.setCoordinate(indices[i], p);
            this.mesh.get(indices[i]).set((Tuple3f)p);
        }
    }

    public void recalculateNormals(GeometryArray ga) {
        if (ga == null) {
            return;
        }
        if ((ga.getVertexFormat() & 2) == 0) {
            return;
        }
        this.changed = true;
        GeometryInfo gi = new GeometryInfo(ga);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray tmp = gi.getGeometryArray();
        int v = ga.getValidVertexCount();
        float[] normals = new float[3 * v];
        tmp.getNormals(0, normals);
        ga.setNormals(0, normals);
    }

    protected void addVertices(Point3f[] v) {
        if (this.mesh == null) {
            return;
        }
        this.changed = true;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            this.mesh.addAll(Arrays.asList(v));
            this.setGeometry((Geometry)this.createGeometry());
            return;
        }
        if (ga instanceof GeometryStripArray) {
            this.addVerticesToGeometryStripArray(v);
        } else {
            this.addVerticesToGeometryArray(v);
        }
    }

    protected void removeVertices(int[] indices) {
        if (this.mesh == null) {
            return;
        }
        this.changed = true;
        for (int i = indices.length - 1; i >= 0; --i) {
            if (indices[i] < 0 || indices[i] >= this.mesh.size()) continue;
            this.mesh.remove(indices[i]);
        }
        this.setGeometry((Geometry)this.createGeometry());
    }

    public void setColor(Color3f color) {
        this.color = color != null ? color : DEFAULT_COLOR;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        int N = ga.getVertexCount();
        Color3f[] colors = new Color3f[N];
        for (int i = 0; i < N; ++i) {
            colors[i] = this.color;
        }
        ga.setColors(0, colors);
        this.changed = true;
    }

    public void setColor(List<Color3f> color) {
        this.color = null;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        int N = ga.getValidVertexCount();
        if (color.size() != N) {
            throw new IllegalArgumentException("list of size " + N + " expected");
        }
        Color3f[] colors = new Color3f[N];
        color.toArray(colors);
        ga.setColors(0, colors);
        this.changed = true;
    }

    public void setColor(int vtxIndex, Color3f color) {
        this.color = null;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        ga.setColor(vtxIndex, color);
        this.changed = true;
    }

    public void loadSurfaceColorsFromImage(ImagePlus imp) {
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        if (imp.getType() != 4) {
            imp = new Duplicator().run(imp);
            new StackConverter(imp).convertToRGB();
        }
        InterpolatedImage ii = new InterpolatedImage(imp);
        int N = ga.getValidVertexCount();
        Color3f[] colors = new Color3f[N];
        Calibration cal = imp.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        double pd = cal.pixelDepth;
        Point3f coord = new Point3f();
        for (int i = 0; i < N; ++i) {
            ga.getCoordinate(i, coord);
            int v = (int)Math.round(ii.interpol.get((double)coord.x / pw, (double)coord.y / ph, (double)coord.z / pd));
            colors[i] = new Color3f((float)((v & 0xFF0000) >> 16) / 255.0f, (float)((v & 0xFF00) >> 8) / 255.0f, (float)(v & 0xFF) / 255.0f);
        }
        ga.setColors(0, colors);
        this.changed = true;
    }

    public void setTransparency(float transparency) {
        TransparencyAttributes ta = this.getAppearance().getTransparencyAttributes();
        if (transparency <= 0.01f) {
            this.transparency = 0.0f;
            ta.setTransparencyMode(4);
        } else {
            this.transparency = transparency;
            ta.setTransparencyMode(0);
        }
        ta.setTransparency(this.transparency);
    }

    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        if (this.shaded) {
            polyAttrib.setPolygonMode(2);
        } else {
            polyAttrib.setPolygonMode(1);
        }
        polyAttrib.setCullFace(0);
        polyAttrib.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        if (null != this.color) {
            colorAttrib.setColor(this.color);
        }
        appearance.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        boolean mode = false;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(0);
        tr.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    public void restoreDisplayedData(String path, String name) {
        HashMap<String, CustomMesh> contents = null;
        try {
            contents = WavefrontLoader.load(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (contents.containsKey(name)) {
            this.mesh = contents.get(name).getMesh();
            this.update();
        }
    }

    public void swapDisplayedData(String path, String name) {
        HashMap<String, CustomMesh> contents = new HashMap<String, CustomMesh>();
        contents.put(name, this);
        try {
            WavefrontExporter.save(contents, path + ".obj");
            this.mesh = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clearDisplayedData() {
        this.mesh = null;
    }

    protected abstract GeometryArray createGeometry();
}

