/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import java.util.Arrays;
import java.util.List;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.LineArray;
import org.scijava.java3d.LineAttributes;
import org.scijava.java3d.LineStripArray;
import org.scijava.java3d.Material;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;

public class CustomLineMesh
extends CustomMesh {
    public static final int PAIRWISE = 0;
    public static final int CONTINUOUS = 1;
    public static final int SOLID = 0;
    public static final int DOT = 2;
    public static final int DASH = 1;
    public static final int DASH_DOT = 3;
    public static final int DEFAULT_MODE = 1;
    public static final int DEFAULT_PATTERN = 0;
    public static final float DEFAULT_LINEWIDTH = 1.0f;
    private int mode = 1;
    private int pattern = 0;
    private float linewidth = 1.0f;

    public CustomLineMesh(List<Point3f> mesh) {
        this(mesh, 1);
    }

    public CustomLineMesh(List<Point3f> mesh, int mode) {
        this(mesh, mode, DEFAULT_COLOR, 0.0f);
    }

    public CustomLineMesh(List<Point3f> mesh, int mode, Color3f color, float transparency) {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        if (color != null) {
            this.color = color;
        }
        this.mesh = mesh;
        this.mode = mode;
        this.transparency = transparency;
        this.update();
    }

    public int getMode() {
        return this.mode;
    }

    public void setPattern(int pattern) {
        this.pattern = pattern;
        this.getAppearance().getLineAttributes().setLinePattern(pattern);
    }

    public void setAntiAliasing(boolean b) {
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(b);
    }

    public void setLineWidth(float w) {
        this.linewidth = w;
        this.getAppearance().getLineAttributes().setLineWidth(w);
    }

    public float getLineWidth() {
        return this.linewidth;
    }

    public void addLines(Point3f[] v) {
        if (this.mode == 0 && v.length % 2 != 0) {
            throw new IllegalArgumentException("Even number expected");
        }
        this.addVertices(v);
    }

    @Override
    public float getVolume() {
        return 0.0f;
    }

    @Override
    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        appearance.setCapability(16);
        LineAttributes lineAttrib = new LineAttributes();
        lineAttrib.setCapability(5);
        lineAttrib.setCapability(3);
        lineAttrib.setCapability(1);
        lineAttrib.setLineWidth(this.linewidth);
        lineAttrib.setLinePattern(this.pattern);
        appearance.setLineAttributes(lineAttrib);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        polyAttrib.setPolygonMode(2);
        polyAttrib.setCullFace(0);
        polyAttrib.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        colorAttrib.setColor(this.color);
        appearance.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        int mode = this.transparency == 0.0f ? 4 : 0;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(mode);
        tr.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.mesh == null || this.mesh.size() < 2) {
            return null;
        }
        List tri = this.mesh;
        int nValid = tri.size();
        int nAll = 2 * nValid;
        Point3f[] coords = new Point3f[nValid];
        tri.toArray(coords);
        Object[] colors = new Color3f[nValid];
        Arrays.fill(colors, this.color);
        LineArray ta = null;
        if (this.mode == 0) {
            ta = new LineArray(nAll, 5);
            ta.setValidVertexCount(nValid);
        } else if (this.mode == 1) {
            ta = new LineStripArray(nAll, 5, new int[]{nValid});
        }
        ta.setCoordinates(0, coords);
        ta.setColors(0, (Color3f[])colors);
        ta.setCapability(3);
        ta.setCapability(1);
        ta.setCapability(20);
        ta.setCapability(8);
        ta.setCapability(18);
        return ta;
    }
}

