/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.process.StackConverter;
import java.util.List;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.IndexedTriangleArray;
import org.scijava.java3d.Material;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;
import vib.InterpolatedImage;

public class CustomIndexedTriangleMesh
extends CustomMesh {
    protected Point3f[] vertices;
    protected Color3f[] colors;
    protected int[] faces;
    protected int nFaces;
    protected int nVertices;

    public CustomIndexedTriangleMesh(List<Point3f> mesh) {
    }

    public CustomIndexedTriangleMesh(Point3f[] vertices, int[] faces) {
        this(vertices, faces, DEFAULT_COLOR, 0.0f);
    }

    public CustomIndexedTriangleMesh(Point3f[] vertices, int[] faces, Color3f color, float transp) {
        this.nVertices = vertices.length;
        this.nFaces = faces.length;
        this.vertices = vertices;
        this.faces = faces;
        if (color != null) {
            this.setColor(color);
        }
        this.transparency = transp;
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.update();
    }

    @Override
    public String getFile() {
        return this.loadedFromFile;
    }

    @Override
    public String getName() {
        return this.loadedFromName;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void update() {
        this.setGeometry((Geometry)this.createGeometry());
        this.setAppearance(this.createAppearance());
        this.changed = true;
    }

    @Override
    public List getMesh() {
        return this.mesh;
    }

    @Override
    public Color3f getColor() {
        return this.color;
    }

    @Override
    public float getTransparency() {
        return this.transparency;
    }

    @Override
    public boolean isShaded() {
        return this.shaded;
    }

    @Override
    public void setShaded(boolean b) {
        this.shaded = b;
        PolygonAttributes pa = this.getAppearance().getPolygonAttributes();
        if (b) {
            pa.setPolygonMode(2);
        } else {
            pa.setPolygonMode(1);
        }
    }

    @Override
    public void calculateMinMaxCenterPoint(Point3f min, Point3f max, Point3f center) {
        if (this.vertices == null || this.nVertices == 0) {
            min.set(0.0f, 0.0f, 0.0f);
            max.set(0.0f, 0.0f, 0.0f);
            center.set(0.0f, 0.0f, 0.0f);
            return;
        }
        min.z = Float.MAX_VALUE;
        min.y = Float.MAX_VALUE;
        min.x = Float.MAX_VALUE;
        max.z = -3.4028235E38f;
        max.y = -3.4028235E38f;
        max.x = -3.4028235E38f;
        for (int i = 0; i < this.nVertices; ++i) {
            Point3f p = this.vertices[i];
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.z < min.z) {
                min.z = p.z;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            if (!(p.z > max.z)) continue;
            max.z = p.z;
        }
        center.x = (max.x + min.x) / 2.0f;
        center.y = (max.y + min.y) / 2.0f;
        center.z = (max.z + min.z) / 2.0f;
    }

    @Override
    public float getVolume() {
        throw new IllegalArgumentException("Not supported yet");
    }

    @Override
    protected void addVerticesToGeometryStripArray(Point3f[] v) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support adding vertices");
    }

    @Override
    protected void addVerticesToGeometryArray(Point3f[] v) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support adding vertices");
    }

    @Override
    public int[] vertexIndicesOfPoint(Point3f p) {
        int i = this.vertexIndexOfPoint(p);
        if (i == -1) {
            return new int[0];
        }
        return new int[]{i};
    }

    public int vertexIndexOfPoint(Point3f p) {
        for (int i = 0; i < this.nVertices; ++i) {
            Point3f v = this.vertices[i];
            if (!p.equals((Tuple3f)v)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setCoordinate(int i, Point3f p) {
        this.changed = true;
        this.vertices[i].set((Tuple3f)p);
        ((GeometryArray)this.getGeometry()).setCoordinate(i, p);
    }

    @Override
    public void setCoordinates(int[] indices, Point3f p) {
        this.changed = true;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        for (int i = 0; i < indices.length; ++i) {
            ga.setCoordinate(indices[i], p);
            this.vertices[indices[i]].set((Tuple3f)p);
        }
    }

    @Override
    public void recalculateNormals(GeometryArray ga) {
    }

    @Override
    protected void addVertices(Point3f[] v) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support adding vertices");
    }

    @Override
    protected void removeVertices(int[] indices) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support adding vertices");
    }

    @Override
    public void setColor(Color3f color) {
        if (this.colors == null || this.colors.length != this.vertices.length) {
            this.colors = new Color3f[this.vertices.length];
        }
        this.color = color != null ? color : DEFAULT_COLOR;
        for (int i = 0; i < this.nVertices; ++i) {
            this.colors[i] = this.color;
        }
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        ga.setColors(0, this.colors);
        this.changed = true;
    }

    @Override
    public void setColor(List<Color3f> color) {
        if (color.size() != this.colors.length) {
            throw new IllegalArgumentException("Number of colors must equal number of vertices");
        }
        this.color = null;
        color.toArray(this.colors);
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        ga.setColors(0, this.colors);
        this.changed = true;
    }

    @Override
    public void setColor(int vtxIndex, Color3f color) {
        this.color = null;
        this.colors[vtxIndex] = color;
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        ga.setColor(vtxIndex, color);
        this.changed = true;
    }

    @Override
    public void loadSurfaceColorsFromImage(ImagePlus imp) {
        if (imp.getType() != 4) {
            imp = new Duplicator().run(imp);
            new StackConverter(imp).convertToRGB();
        }
        InterpolatedImage ii = new InterpolatedImage(imp);
        Calibration cal = imp.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        double pd = cal.pixelDepth;
        for (int i = 0; i < this.nVertices; ++i) {
            Point3f coord = this.vertices[i];
            int v = (int)Math.round(ii.interpol.get((double)coord.x / pw, (double)coord.y / ph, (double)coord.z / pd));
            this.colors[i] = new Color3f((float)((v & 0xFF0000) >> 16) / 255.0f, (float)((v & 0xFF00) >> 8) / 255.0f, (float)(v & 0xFF) / 255.0f);
        }
        GeometryArray ga = (GeometryArray)this.getGeometry();
        if (ga == null) {
            return;
        }
        ga.setColors(0, this.colors);
        this.changed = true;
    }

    @Override
    public void setTransparency(float transparency) {
        TransparencyAttributes ta = this.getAppearance().getTransparencyAttributes();
        if (transparency <= 0.01f) {
            this.transparency = 0.0f;
            ta.setTransparencyMode(4);
        } else {
            this.transparency = transparency;
            ta.setTransparencyMode(0);
        }
        ta.setTransparency(this.transparency);
    }

    @Override
    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCapability(3);
        if (this.shaded) {
            polyAttrib.setPolygonMode(2);
        } else {
            polyAttrib.setPolygonMode(1);
        }
        polyAttrib.setCullFace(0);
        polyAttrib.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polyAttrib);
        ColoringAttributes colorAttrib = new ColoringAttributes();
        colorAttrib.setShadeModel(3);
        if (null != this.color) {
            colorAttrib.setColor(this.color);
        }
        appearance.setColoringAttributes(colorAttrib);
        TransparencyAttributes tr = new TransparencyAttributes();
        int mode = this.transparency == 0.0f ? 4 : 0;
        tr.setCapability(3);
        tr.setCapability(1);
        tr.setTransparencyMode(mode);
        tr.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(tr);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    @Override
    public void restoreDisplayedData(String path, String name) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support swapping data.");
    }

    @Override
    public void swapDisplayedData(String path, String name) {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support swapping data.");
    }

    @Override
    public void clearDisplayedData() {
        throw new RuntimeException("CustomIndexedTriangleMesh does not support swapping data.");
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.nVertices == 0) {
            return null;
        }
        IndexedTriangleArray ta = new IndexedTriangleArray(this.vertices.length, 7, this.faces.length);
        ta.setValidIndexCount(this.nFaces);
        ta.setCoordinates(0, this.vertices);
        ta.setColors(0, this.colors);
        ta.setCoordinateIndices(0, this.faces);
        ta.setColorIndices(0, this.faces);
        ta.setNormals(0, this.getNormals());
        ta.setNormalIndices(0, this.faces);
        ta.setCapability(3);
        ta.setCapability(18);
        return ta;
    }

    public Vector3f[] getNormals() {
        int i;
        Vector3f[] normals = new Vector3f[this.nVertices];
        for (int i2 = 0; i2 < this.nVertices; ++i2) {
            normals[i2] = new Vector3f();
        }
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        for (i = 0; i < this.nFaces; i += 3) {
            int f1 = this.faces[i];
            int f2 = this.faces[i + 1];
            int f3 = this.faces[i + 2];
            v1.sub((Tuple3f)this.vertices[f2], (Tuple3f)this.vertices[f1]);
            v2.sub((Tuple3f)this.vertices[f3], (Tuple3f)this.vertices[f1]);
            v1.cross(v1, v2);
            normals[f1].add((Tuple3f)v1);
            normals[f2].add((Tuple3f)v1);
            normals[f3].add((Tuple3f)v1);
        }
        for (i = 0; i < this.nVertices; ++i) {
            normals[i].normalize();
        }
        return normals;
    }
}

