/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.scala;

import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripteditor.scala.ScalaAutoCompletion;
import org.scijava.plugins.scripteditor.scala.ScalaAutocompletionProvider;
import org.scijava.ui.swing.script.LanguageSupportPlugin;

@Plugin(type=LanguageSupportPlugin.class, priority=100.0)
public class ScalaLanguageSupportPlugin
extends AbstractLanguageSupport
implements LanguageSupportPlugin {
    @Parameter
    private LogService log;
    private AutoCompletion ac;
    private RSyntaxTextArea text_area;

    public ScalaLanguageSupportPlugin() {
        this.setAutoCompleteEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(false);
    }

    @Override
    public String getLanguageName() {
        return "scala";
    }

    public void install(RSyntaxTextArea textArea) {
        this.text_area = textArea;
        this.ac = this.createAutoCompletion(null);
        this.ac.setParameterAssistanceEnabled(false);
        this.ac.setShowDescWindow(false);
        this.ac.install((JTextComponent)textArea);
        super.installImpl(textArea, this.ac);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        if (textArea == this.text_area) {
            super.uninstallImpl(textArea);
        }
    }

    protected AutoCompletion createAutoCompletion(CompletionProvider p) {
        return new ScalaAutoCompletion((CompletionProvider)new ScalaAutocompletionProvider(this.log));
    }
}

