/*
 * Decompiled with CFR 0.152.
 */
package levelsets.ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.EnumMap;
import levelsets.algorithm.DeferredObjectArray3D;
import levelsets.algorithm.FastMarching;
import levelsets.algorithm.LevelSetFactory;
import levelsets.algorithm.LevelSetImplementation;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public class LevelSet
implements PlugIn {
    private static String[] shapeList = new String[]{"none"};
    private static String[] preprocessList = new String[]{"none", "Gaussian difference"};
    private static boolean fast_marching = true;
    private static boolean level_sets = true;
    private static String[] levelsetList;
    private static int ls_choice;
    private static String[] expansionList;
    private static short expansion_choice;
    static boolean insideout;
    protected ImagePlus imp;
    protected ImageContainer ic = null;
    protected static LevelSetFactory lf;
    protected int ITER_INC = 100;
    protected static double fm_dist;
    protected static int fm_grey;
    protected EnumMap<LevelSetFactory.Parameter, String> parameters;
    protected preprocessChoices preprocess = preprocessChoices.none;
    protected ImagePlus shapeStack = null;
    protected int fm_maxiter = 100000;
    protected int ls_maxiter = 100;
    protected boolean ask_params = true;
    private static String testImageFn;
    private static int[] poly_rx;
    private static int[] poly_ry;
    private static int[] rx;
    private static int[] ry;
    private static boolean test_dialog;
    private static boolean test_algorithm;
    private static boolean test_roi;

    public LevelSet() {
        if (lf == null) {
            lf = new LevelSetFactory();
            levelsetList = lf.getImplementationNames();
            lf.resetParameters(levelsetList[ls_choice]);
        }
        this.parameters = lf.getParameters();
        if (fm_grey < 0) {
            fm_grey = FastMarching.getGreyThreshold();
            fm_dist = FastMarching.getDistanceThreshold();
        }
    }

    public static void main(String[] args) {
        String[] ij_args = new String[]{"-Dplugins.dir=/Users/erwin/Desktop/fiji_git/fiji/plugins", "-Dmacros.dir=/Users/erwin/Desktop/fiji_git/fiji/macros"};
        ImageJ.main((String[])ij_args);
        ImagePlus testIP = new ImagePlus(testImageFn);
        testIP.show();
        PointRoi pr = new PointRoi(rx[0], ry[0], testIP);
        if (rx.length > 1) {
            for (int i = 1; i < rx.length; ++i) {
                pr.addPoint((double)rx[1], (double)ry[1]);
                pr.addPoint((double)rx[2], (double)ry[2]);
            }
        }
        testIP.setRoi((Roi)pr);
        LevelSet ls_filter = new LevelSet();
        if (test_dialog) {
            ls_filter.showDialog();
        }
        if (test_roi) {
            ls_filter.showROI(testIP, new Roi(10, 10, 20, 30), null);
            ls_filter.showROI(testIP, (Roi)new PolygonRoi(poly_rx, poly_ry, poly_rx.length, 2), null);
        }
        if (test_algorithm) {
            ls_filter.imp = testIP;
            ls_filter.run("");
        }
    }

    public void run(ImagePlus imp) {
        ImagePlus result = this.execute(imp, true);
        if (null != result) {
            result.show();
        }
    }

    public ImagePlus execute(ImagePlus imp, boolean with_progress) {
        ImageProgressContainer progressImage;
        Roi roi = imp.getRoi();
        if (roi == null) {
            return null;
        }
        this.ic = new ImageContainer(imp);
        ImageProgressContainer imageProgressContainer = progressImage = with_progress ? new ImageProgressContainer() : null;
        if (null != progressImage) {
            progressImage.duplicateImages(this.ic);
            progressImage.createImagePlus("Segmentation progress of " + imp.getTitle());
            progressImage.showProgressStep();
        }
        StateContainer sc_roi = new StateContainer();
        System.out.println("current slice: " + imp.getCurrentSlice());
        sc_roi.setROI(roi, this.ic.getWidth(), this.ic.getHeight(), this.ic.getImageCount(), imp.getCurrentSlice());
        sc_roi.setExpansionToInside(insideout);
        StateContainer sc_ls = null;
        StateContainer sc_final = null;
        IJ.showStatus((String)"Press 'Esc' to abort");
        try {
            int iter;
            if (fast_marching) {
                FastMarching fm = new FastMarching(this.ic, progressImage, sc_roi, true, fm_grey, fm_dist);
                IJ.log((String)("Fast Marching: Starting " + new Date(System.currentTimeMillis())));
                for (iter = 0; iter < this.fm_maxiter && fm.step(this.ITER_INC); ++iter) {
                    if (!IJ.escapePressed()) continue;
                    IJ.log((String)"Aborted");
                    return null;
                }
                IJ.log((String)("Fast Marching: Finished " + new Date(System.currentTimeMillis())));
                sc_ls = fm.getStateContainer();
                if (sc_ls == null) {
                    return null;
                }
                sc_ls.setExpansionToInside(insideout);
                sc_final = sc_ls;
            } else {
                sc_ls = sc_roi;
            }
            if (level_sets) {
                IJ.log((String)("Level Set (" + levelsetList[ls_choice] + "): Starting " + new Date(System.currentTimeMillis())));
                IJ.log((String)("Note: Each iteration step is " + this.ITER_INC + " iterations"));
                LevelSetImplementation ls = lf.getImplementation(levelsetList[ls_choice], this.ic, progressImage, sc_ls);
                for (iter = 0; iter < this.ls_maxiter && ls.step(this.ITER_INC); ++iter) {
                    if (!IJ.escapePressed()) continue;
                    IJ.log((String)"Aborted");
                    return null;
                }
                IJ.log((String)("Level Set: Finished " + new Date(System.currentTimeMillis())));
                sc_final = ls.getStateContainer();
            }
            if (sc_final == null) {
                return null;
            }
            ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
            for (ImageProcessor bp : sc_final.getIPMask()) {
                stack.addSlice(null, bp);
            }
            ImagePlus seg = imp.createImagePlus();
            seg.setStack("Segmentation of " + imp.getTitle(), stack);
            seg.setSlice(imp.getCurrentSlice());
            return seg;
        }
        catch (IllegalArgumentException e) {
            IJ.error((String)e.getMessage());
        }
        catch (ArithmeticException e) {
            IJ.error((String)("Arithmetic problem: " + e.getMessage()));
        }
        return null;
    }

    public void run(String arg) {
        Roi roi;
        if (null == this.imp) {
            this.imp = WindowManager.getCurrentImage();
            if (null == this.imp) {
                IJ.showMessage((String)"Level Sets needs an image with a ROI in it!");
                return;
            }
        }
        if (null == (roi = this.imp.getRoi())) {
            IJ.error((String)"Seed (points) required");
            return;
        }
        if (this.ask_params && !this.showDialog()) {
            return;
        }
        if (fm_grey < 0) {
            fm_grey = FastMarching.getGreyThreshold();
            fm_dist = FastMarching.getDistanceThreshold();
        }
        this.run(this.imp);
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Level Set Segmentation");
        gd.addCheckbox("Use_Fast_Marching", fast_marching);
        gd.addNumericField("Grey_value_threshold", (double)fm_grey, 0);
        gd.addNumericField("Distance_threshold", fm_dist, 2);
        gd.addCheckbox("Use_Level_Sets", level_sets);
        gd.addChoice("Method", levelsetList, levelsetList[0]);
        gd.addMessage("(Not all parameters used in all methods)");
        gd.addMessage("Level set weigths (0 = don't use)");
        for (LevelSetFactory.Parameter pn : this.parameters.keySet()) {
            Object pv = lf.getParameterValue(pn);
            if (pv == null) {
                gd.addNumericField(this.parameters.get((Object)pn), 0.0, 2);
            }
            if (!(pv instanceof Double)) continue;
            gd.addNumericField(this.parameters.get((Object)pn), ((Double)lf.getParameterValue(pn)).doubleValue(), 2);
        }
        gd.addMessage("Level set convergence criterion");
        gd.addNumericField("Convergence", ((Double)lf.getParameterValue(LevelSetFactory.Parameter.CONVERGENCE)).doubleValue(), 4);
        gd.addChoice("Region expands to ", expansionList, expansionList[expansion_choice]);
        gd.addMessage("");
        gd.addMessage("Developed by Erwin Frise.\nBased on code by Arne-Michael Toersel\n");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        String method = gd.getNextChoice();
        for (int i = 0; i < levelsetList.length; ++i) {
            if (method.compareTo(levelsetList[i]) != 0) continue;
            ls_choice = i;
            break;
        }
        fast_marching = gd.getNextBoolean();
        level_sets = gd.getNextBoolean();
        fm_grey = (int)gd.getNextNumber();
        fm_dist = gd.getNextNumber();
        for (LevelSetFactory.Parameter pn : this.parameters.keySet()) {
            Object pv = lf.getParameterValue(pn);
            lf.setParameterValue(pn, new Double(gd.getNextNumber()));
        }
        lf.setParameterValue(LevelSetFactory.Parameter.CONVERGENCE, new Double(gd.getNextNumber()));
        String expansion = gd.getNextChoice();
        if (expansion.contentEquals(expansionList[1])) {
            insideout = true;
            expansion_choice = 1;
        } else {
            insideout = false;
            expansion_choice = 0;
        }
        if (test_dialog) {
            IJ.log((String)("Convergence to " + lf.getParameterValue(LevelSetFactory.Parameter.CONVERGENCE)));
            IJ.log((String)("Fast Marching enabled = " + fast_marching));
            IJ.log((String)("Fast Marching: fm_grey=" + fm_grey + " , fm_dist=" + fm_dist));
            IJ.log((String)("Level Sets enabled = " + level_sets));
            IJ.log((String)("Level Sets: w_adv= " + lf.getParameterValue(LevelSetFactory.Parameter.W_ADVECTION) + ", w_curv=" + lf.getParameterValue(LevelSetFactory.Parameter.W_CURVATURE) + ", w_gray=" + lf.getParameterValue(LevelSetFactory.Parameter.TOL_GRAYSCALE) + ", f_conv=" + lf.getParameterValue(LevelSetFactory.Parameter.CONVERGENCE)));
            if (insideout) {
                IJ.log((String)"Inverse expansion");
            }
        }
        return true;
    }

    public void showROI(ImagePlus ip, Roi roi, StateContainer sc_in) {
        int[] ALIVE_PIXEL = new int[]{0, 255, 0, 0};
        int[] BAND_PIXEL = new int[]{255, 0, 0, 0};
        ImageProgressContainer progress = new ImageProgressContainer(new ImageContainer(ip));
        StateContainer sc_test = null;
        if (sc_in != null) {
            sc_test = sc_in;
        }
        if (roi != null) {
            sc_test = new StateContainer();
            sc_test.setROI(roi, progress.getWidth(), progress.getHeight(), progress.getImageCount(), 1);
        }
        if (sc_test == null) {
            IJ.error((String)"sc_test not set");
            return;
        }
        DeferredObjectArray3D<StateContainer.States> map = sc_test.getForSparseField();
        int px_alive = 0;
        int px_band = 0;
        int px_far = 0;
        ImageProgressContainer output = progress;
        if (this.ask_params) {
            progress.showProgressStep();
        }
        StateContainer.States cell_state = StateContainer.States.OUTSIDE;
        for (int z = 0; z < map.getZLength(); ++z) {
            for (int x = 0; x < map.getXLength(); ++x) {
                for (int y = 0; y < map.getYLength(); ++y) {
                    cell_state = map.get(x, y, z);
                    if (cell_state == StateContainer.States.INSIDE) {
                        output.setPixel(x, y, z, ALIVE_PIXEL);
                        ++px_alive;
                        continue;
                    }
                    if (cell_state == StateContainer.States.ZERO) {
                        output.setPixel(x, y, z, BAND_PIXEL);
                        ++px_band;
                        continue;
                    }
                    ++px_far;
                }
            }
        }
        progress.showProgressStep();
    }

    private final void addEnablerListener(Checkbox master, final Component[] enable, final Component[] disable) {
        master.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.process(enable, true);
                    this.process(disable, false);
                } else {
                    this.process(enable, false);
                    this.process(disable, true);
                }
            }

            private void process(Component[] c, boolean state) {
                if (null == c) {
                    return;
                }
                for (int i = 0; i < c.length; ++i) {
                    c[i].setEnabled(state);
                }
            }
        });
    }

    static {
        ls_choice = 0;
        expansionList = new String[]{"outside", "inside"};
        expansion_choice = 0;
        insideout = false;
        fm_dist = -1.0;
        fm_grey = -1;
        testImageFn = "/Users/erwin/Desktop/fiji_git/Dot_Blot.tif";
        poly_rx = new int[]{78, 78, 291};
        poly_ry = new int[]{79, 150, 69};
        rx = new int[]{260};
        ry = new int[]{180};
        test_dialog = false;
        test_algorithm = false;
        test_roi = false;
    }

    public static enum preprocessChoices {
        none,
        gaussian;

    }
}

