/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.liner;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.liner.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class CurvedLiner
implements Liner,
DOMStorable {
    private double shoulderSize;

    public CurvedLiner() {
        this(20.0);
    }

    public CurvedLiner(double slantSize) {
        this.shoulderSize = slantSize;
    }

    @Override
    public Collection<Handle> createHandles(BezierPath path) {
        return Collections.emptyList();
    }

    @Override
    public void lineout(ConnectionFigure figure) {
        BezierPath path = ((LineConnectionFigure)figure).getBezierPath();
        Connector start = figure.getStartConnector();
        Connector end = figure.getEndConnector();
        if (start == null || end == null || path == null) {
            return;
        }
        if (figure.getStartFigure() == figure.getEndFigure()) {
            int eoutcode;
            while (path.size() < 4) {
                path.add(1, new BezierPath.Node(0.0, 0.0));
            }
            while (path.size() > 4) {
                path.remove(1);
            }
            Point2D.Double sp = start.findStart(figure);
            Point2D.Double ep = end.findEnd(figure);
            Rectangle2D.Double sb = start.getBounds();
            Rectangle2D.Double eb = end.getBounds();
            int soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = Geom.outcode(sb, eb);
            }
            if ((eoutcode = eb.outcode(ep)) == 0) {
                eoutcode = Geom.outcode(sb, eb);
            }
            ((BezierPath.Node)path.get(0)).moveTo(sp);
            ((BezierPath.Node)path.get(path.size() - 1)).moveTo(ep);
            switch (soutcode) {
                case 2: {
                    eoutcode = 1;
                    break;
                }
                case 4: {
                    eoutcode = 2;
                    break;
                }
                case 8: {
                    eoutcode = 4;
                    break;
                }
                case 1: {
                    eoutcode = 8;
                    break;
                }
                default: {
                    eoutcode = 2;
                    soutcode = 4;
                }
            }
            ((BezierPath.Node)path.get((int)0)).mask = 2;
            if ((soutcode & 4) != 0) {
                ((BezierPath.Node)path.get((int)0)).x[2] = sp.x + this.shoulderSize;
                ((BezierPath.Node)path.get((int)0)).y[2] = sp.y;
            } else if ((soutcode & 1) != 0) {
                ((BezierPath.Node)path.get((int)0)).x[2] = sp.x - this.shoulderSize;
                ((BezierPath.Node)path.get((int)0)).y[2] = sp.y;
            } else if ((soutcode & 8) != 0) {
                ((BezierPath.Node)path.get((int)0)).x[2] = sp.x;
                ((BezierPath.Node)path.get((int)0)).y[2] = sp.y + this.shoulderSize;
            } else {
                ((BezierPath.Node)path.get((int)0)).x[2] = sp.x;
                ((BezierPath.Node)path.get((int)0)).y[2] = sp.y - this.shoulderSize;
            }
            ((BezierPath.Node)path.get((int)1)).mask = 2;
            ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.shoulderSize, (sp.y + ep.y) / 2.0);
            ((BezierPath.Node)path.get((int)1)).x[2] = sp.x + this.shoulderSize;
            ((BezierPath.Node)path.get((int)1)).y[2] = ep.y - this.shoulderSize;
            ((BezierPath.Node)path.get((int)2)).mask = 1;
            ((BezierPath.Node)path.get(2)).moveTo((sp.x + ep.x) / 2.0, ep.y - this.shoulderSize);
            ((BezierPath.Node)path.get((int)2)).x[1] = sp.x + this.shoulderSize;
            ((BezierPath.Node)path.get((int)2)).y[1] = ep.y - this.shoulderSize;
            ((BezierPath.Node)path.get((int)3)).mask = 1;
            if ((eoutcode & 4) != 0) {
                ((BezierPath.Node)path.get((int)3)).x[1] = ep.x + this.shoulderSize;
                ((BezierPath.Node)path.get((int)3)).y[1] = ep.y;
            } else if ((eoutcode & 1) != 0) {
                ((BezierPath.Node)path.get((int)3)).x[1] = ep.x - this.shoulderSize;
                ((BezierPath.Node)path.get((int)3)).y[1] = ep.y;
            } else if ((eoutcode & 8) != 0) {
                ((BezierPath.Node)path.get((int)3)).x[1] = ep.x;
                ((BezierPath.Node)path.get((int)3)).y[1] = ep.y + this.shoulderSize;
            } else {
                ((BezierPath.Node)path.get((int)3)).x[1] = ep.x;
                ((BezierPath.Node)path.get((int)3)).y[1] = ep.y - this.shoulderSize;
            }
        } else {
            Point2D.Double sp = start.findStart(figure);
            Point2D.Double ep = end.findEnd(figure);
            path.clear();
            if (sp.x == ep.x || sp.y == ep.y) {
                path.add(new BezierPath.Node(ep.x, ep.y));
            } else {
                int eoutcode;
                Rectangle2D.Double sb = start.getBounds();
                sb.x += 5.0;
                sb.y += 5.0;
                sb.width -= 10.0;
                sb.height -= 10.0;
                Rectangle2D.Double eb = end.getBounds();
                eb.x += 5.0;
                eb.y += 5.0;
                eb.width -= 10.0;
                eb.height -= 10.0;
                int soutcode = sb.outcode(sp);
                if (soutcode == 0) {
                    soutcode = Geom.outcode(sb, eb);
                }
                if ((eoutcode = eb.outcode(ep)) == 0) {
                    eoutcode = Geom.outcode(eb, sb);
                }
                if ((soutcode & 0xA) != 0 && (eoutcode & 0xA) != 0) {
                    path.add(new BezierPath.Node(2, sp.x, sp.y, sp.x, sp.y, sp.x, (sp.y + ep.y) / 2.0));
                    path.add(new BezierPath.Node(1, ep.x, ep.y, ep.x, (sp.y + ep.y) / 2.0, ep.x, ep.y));
                } else if ((soutcode & 5) != 0 && (eoutcode & 5) != 0) {
                    path.add(new BezierPath.Node(2, sp.x, sp.y, sp.x, sp.y, (sp.x + ep.x) / 2.0, sp.y));
                    path.add(new BezierPath.Node(1, ep.x, ep.y, (sp.x + ep.x) / 2.0, ep.y, ep.x, ep.y));
                } else if (soutcode == 8 || soutcode == 2) {
                    path.add(new BezierPath.Node(2, sp.x, sp.y, sp.x, sp.y, sp.x, ep.y));
                    path.add(new BezierPath.Node(ep.x, ep.y));
                } else {
                    path.add(new BezierPath.Node(2, sp.x, sp.y, sp.x, sp.y, ep.x, sp.y));
                    path.add(new BezierPath.Node(ep.x, ep.y));
                }
            }
        }
        path.invalidatePath();
    }

    @Override
    public void read(DOMInput in) {
    }

    @Override
    public void write(DOMOutput out) {
    }

    @Override
    public Liner clone() {
        try {
            return (Liner)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }
}

