/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.EditorColorChooserAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawingColorChooserAction
extends EditorColorChooserAction {
    public DrawingColorChooserAction(DrawingEditor editor, AttributeKey<Color> key) {
        this(editor, key, null, null);
    }

    public DrawingColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable Icon icon) {
        this(editor, key, null, icon);
    }

    public DrawingColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name) {
        this(editor, key, name, null);
    }

    public DrawingColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name, @Nullable Icon icon) {
        this(editor, key, name, icon, new HashMap<AttributeKey, Object>());
    }

    public DrawingColorChooserAction(DrawingEditor editor, AttributeKey<Color> key, @Nullable String name, @Nullable Icon icon, Map<AttributeKey, Object> fixedAttributes) {
        super(editor, key, name, icon, fixedAttributes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color initialColor = this.getInitialColor();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        Color chosenColor = JColorChooser.showDialog((Component)e.getSource(), labels.getString("attribute.color.text"), initialColor);
        if (chosenColor != null) {
            HashMap<AttributeKey, Object> attr = new HashMap<AttributeKey, Object>(this.attributes);
            attr.put(this.key, chosenColor);
            HashSet<Figure> figures = new HashSet<Figure>();
            figures.add(this.getView().getDrawing());
            this.applyAttributesTo(attr, figures);
        }
    }

    @Override
    protected Color getInitialColor() {
        Color initialColor = null;
        DrawingView v = this.getEditor().getActiveView();
        if (v != null) {
            Drawing f = v.getDrawing();
            initialColor = (Color)f.get(this.key);
        }
        if (initialColor == null) {
            initialColor = super.getInitialColor();
        }
        return initialColor;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled());
        } else {
            this.setEnabled(false);
        }
    }
}

