/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Container;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.file.LoadRecentFileAction;
import org.jhotdraw.app.action.file.OpenRecentFileAction;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public abstract class AbstractApplication
extends AbstractBean
implements Application {
    private LinkedList<View> views = new LinkedList();
    private Collection<View> unmodifiableViews;
    private boolean isEnabled = true;
    protected ResourceBundleUtil labels;
    protected ApplicationModel model;
    private Preferences prefs;
    @Nullable
    private View activeView;
    public static final String VIEW_COUNT_PROPERTY = "viewCount";
    private LinkedList<URI> recentFiles = new LinkedList();
    private static final int maxRecentFilesCount = 10;
    private ActionMap actionMap;
    private URIChooser openChooser;
    private URIChooser saveChooser;
    private URIChooser importChooser;
    private URIChooser exportChooser;

    @Override
    public void init() {
        this.prefs = PreferencesUtil.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        int count = this.prefs.getInt("recentFileCount", 0);
        for (int i = 0; i < count; ++i) {
            String path = this.prefs.get("recentFile." + i, null);
            if (path == null) continue;
            try {
                this.recentFiles.add(new URI(path));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void start(List<URI> uris) {
        if (uris.isEmpty()) {
            final View v = this.createView();
            this.add(v);
            v.setEnabled(false);
            this.show(v);
            this.setActiveView(v);
            v.execute(new Worker<Object>(){

                @Override
                public Object construct() {
                    v.clear();
                    return null;
                }

                @Override
                public void finished() {
                    v.setEnabled(true);
                }
            });
        } else {
            for (final URI uri : uris) {
                final View v = this.createView();
                this.add(v);
                v.setEnabled(false);
                this.show(v);
                this.setActiveView(v);
                v.execute(new Worker<Object>(){

                    @Override
                    public Object construct() throws Exception {
                        v.read(uri, null);
                        return null;
                    }

                    @Override
                    public void finished() {
                        v.setURI(uri);
                        v.setEnabled(true);
                    }
                });
            }
        }
    }

    @Override
    public final View createView() {
        View v = this.basicCreateView();
        v.setActionMap(this.createViewActionMap(v));
        return v;
    }

    @Override
    public void setModel(ApplicationModel newValue) {
        ApplicationModel oldValue = this.model;
        this.model = newValue;
        this.firePropertyChange("model", oldValue, newValue);
    }

    @Override
    public ApplicationModel getModel() {
        return this.model;
    }

    protected View basicCreateView() {
        return this.model.createView();
    }

    public void setActiveView(@Nullable View newValue) {
        View oldValue = this.activeView;
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        this.activeView = newValue;
        if (this.activeView != null) {
            this.activeView.activate();
        }
        this.firePropertyChange("activeView", oldValue, newValue);
    }

    @Override
    @Nullable
    public View getActiveView() {
        return this.activeView;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getVersion() {
        return this.model.getVersion();
    }

    @Override
    public String getCopyright() {
        return this.model.getCopyright();
    }

    @Override
    public void stop() {
        for (View p : new LinkedList<View>(this.views())) {
            this.dispose(p);
        }
    }

    @Override
    public void destroy() {
        this.stop();
        this.model.destroyApplication(this);
        System.exit(0);
    }

    @Override
    public void remove(View v) {
        this.hide(v);
        if (v == this.getActiveView()) {
            this.setActiveView(null);
        }
        int oldCount = this.views.size();
        this.views.remove(v);
        v.setApplication(null);
        this.firePropertyChange(VIEW_COUNT_PROPERTY, oldCount, this.views.size());
    }

    @Override
    public void add(View v) {
        if (v.getApplication() != this) {
            int oldCount = this.views.size();
            this.views.add(v);
            v.setApplication(this);
            v.init();
            this.model.initView(this, v);
            this.firePropertyChange(VIEW_COUNT_PROPERTY, oldCount, this.views.size());
        }
    }

    protected abstract ActionMap createViewActionMap(View var1);

    @Override
    public void dispose(View view) {
        this.remove(view);
        this.model.destroyView(this, view);
        view.dispose();
    }

    @Override
    public Collection<View> views() {
        if (this.unmodifiableViews == null) {
            this.unmodifiableViews = Collections.unmodifiableCollection(this.views);
        }
        return this.unmodifiableViews;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.isEnabled;
        this.isEnabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Container createContainer() {
        return new JFrame();
    }

    @Override
    public void launch(String[] args) {
        this.configure(args);
        final List<URI> uris = this.getOpenURIsFromMainArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractApplication.this.init();
                AbstractApplication.this.start(uris);
            }
        });
    }

    protected List<URI> getOpenURIsFromMainArgs(String[] args) {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-open")) continue;
            ++i;
            while (i < args.length && !args[i].startsWith("-")) {
                URI uri = new File(args[i]).toURI();
                uris.add(uri);
                ++i;
            }
        }
        return uris;
    }

    protected void initLabels() {
        this.labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
    }

    @Override
    public void configure(String[] args) {
    }

    @Override
    public void removePalette(Window palette) {
    }

    @Override
    public void addPalette(Window palette) {
    }

    @Override
    public void removeWindow(Window window) {
    }

    @Override
    public void addWindow(Window window, @Nullable View p) {
    }

    protected Action getAction(@Nullable View view, String actionID) {
        return this.getActionMap(view).get(actionID);
    }

    protected void addAction(JMenu m, @Nullable View view, String actionID) {
        this.addAction(m, this.getAction(view, actionID));
    }

    protected void addAction(JMenu m, Action a) {
        if (a != null) {
            if (m.getClientProperty("needsSeparator") == Boolean.TRUE) {
                m.addSeparator();
                m.putClientProperty("needsSeparator", null);
            }
            JMenuItem mi = m.add(a);
            mi.setIcon(null);
            mi.setToolTipText(null);
        }
    }

    protected void addMenuItem(JMenu m, JMenuItem mi) {
        if (mi != null) {
            if (m.getClientProperty("needsSeparator") == Boolean.TRUE) {
                m.addSeparator();
                m.putClientProperty("needsSeparator", null);
            }
            m.add(mi);
        }
    }

    protected void maybeAddSeparator(JMenu m) {
        JPopupMenu pm = m.getPopupMenu();
        if (pm.getComponentCount() > 0 && !(pm.getComponent(pm.getComponentCount() - 1) instanceof JSeparator)) {
            m.addSeparator();
        }
    }

    @Override
    public List<URI> getRecentURIs() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    @Override
    public void clearRecentURIs() {
        List oldValue = (List)this.recentFiles.clone();
        this.recentFiles.clear();
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void addRecentURI(URI uri) {
        List oldValue = (List)this.recentFiles.clone();
        if (this.recentFiles.contains(uri)) {
            this.recentFiles.remove(uri);
        }
        this.recentFiles.addFirst(uri);
        if (this.recentFiles.size() > 10) {
            this.recentFiles.removeLast();
        }
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        int i = 0;
        for (URI f : this.recentFiles) {
            this.prefs.put("recentFile." + i, f.toString());
            ++i;
        }
        this.firePropertyChange("recentFiles", oldValue, (Object)0);
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    protected JMenu createOpenRecentFileMenu(@Nullable View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, this.getAction(view, "file.load") != null || this.getAction(view, "file.loadDirectory") != null ? "file.loadRecent" : "file.openRecent");
        m.setIcon(null);
        m.add(this.getAction(view, "file.clearRecentFiles"));
        new OpenRecentMenuHandler(m, view);
        return m;
    }

    @Override
    public URIChooser getOpenChooser(View v) {
        if (v == null) {
            if (this.openChooser == null) {
                this.openChooser = this.model.createOpenChooser(this, null);
                List<URI> ruris = this.getRecentURIs();
                if (ruris.size() > 0) {
                    try {
                        this.openChooser.setSelectedURI(ruris.get(0));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
            }
            return this.openChooser;
        }
        URIChooser chooser = (URIChooser)v.getComponent().getClientProperty("openChooser");
        if (chooser == null) {
            chooser = this.model.createOpenChooser(this, v);
            v.getComponent().putClientProperty("openChooser", chooser);
            List<URI> ruris = this.getRecentURIs();
            if (ruris.size() > 0) {
                try {
                    chooser.setSelectedURI(ruris.get(0));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return chooser;
    }

    @Override
    public URIChooser getSaveChooser(View v) {
        if (v == null) {
            if (this.saveChooser == null) {
                this.saveChooser = this.model.createSaveChooser(this, null);
            }
            return this.saveChooser;
        }
        URIChooser chooser = (URIChooser)v.getComponent().getClientProperty("saveChooser");
        if (chooser == null) {
            chooser = this.model.createSaveChooser(this, v);
            v.getComponent().putClientProperty("saveChooser", chooser);
            try {
                chooser.setSelectedURI(v.getURI());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return chooser;
    }

    @Override
    public URIChooser getImportChooser(View v) {
        if (v == null) {
            if (this.importChooser == null) {
                this.importChooser = this.model.createImportChooser(this, null);
            }
            return this.importChooser;
        }
        URIChooser chooser = (URIChooser)v.getComponent().getClientProperty("importChooser");
        if (chooser == null) {
            chooser = this.model.createImportChooser(this, v);
            v.getComponent().putClientProperty("importChooser", chooser);
        }
        return chooser;
    }

    @Override
    public URIChooser getExportChooser(View v) {
        if (v == null) {
            if (this.exportChooser == null) {
                this.exportChooser = this.model.createExportChooser(this, null);
            }
            return this.exportChooser;
        }
        URIChooser chooser = (URIChooser)v.getComponent().getClientProperty("exportChooser");
        if (chooser == null) {
            chooser = this.model.createExportChooser(this, v);
            v.getComponent().putClientProperty("exportChooser", chooser);
        }
        return chooser;
    }

    public void setActionMap(ActionMap m) {
        this.actionMap = m;
    }

    @Override
    public ActionMap getActionMap(@Nullable View v) {
        return v == null ? this.actionMap : v.getActionMap();
    }

    private class OpenRecentMenuHandler
    implements PropertyChangeListener,
    Disposable {
        private JMenu openRecentMenu;
        private LinkedList<Action> openRecentActions = new LinkedList();
        @Nullable
        private View view;

        public OpenRecentMenuHandler(@Nullable JMenu openRecentMenu, View view) {
            this.openRecentMenu = openRecentMenu;
            this.view = view;
            if (view != null) {
                view.addDisposable(this);
            }
            this.updateOpenRecentMenu();
            AbstractApplication.this.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "recentFiles") {
                this.updateOpenRecentMenu();
            }
        }

        protected void updateOpenRecentMenu() {
            if (this.openRecentMenu.getItemCount() > 0) {
                JMenuItem clearRecentFilesItem = this.openRecentMenu.getItem(this.openRecentMenu.getItemCount() - 1);
                this.openRecentMenu.remove(this.openRecentMenu.getItemCount() - 1);
                for (Action action : this.openRecentActions) {
                    if (!(action instanceof Disposable)) continue;
                    ((Disposable)((Object)action)).dispose();
                }
                this.openRecentActions.clear();
                this.openRecentMenu.removeAll();
                if (AbstractApplication.this.getAction(this.view, "file.load") != null || AbstractApplication.this.getAction(this.view, "file.loadDirectory") != null) {
                    for (URI f : AbstractApplication.this.getRecentURIs()) {
                        LoadRecentFileAction action = new LoadRecentFileAction(AbstractApplication.this, this.view, f);
                        this.openRecentMenu.add(action);
                        this.openRecentActions.add(action);
                    }
                } else {
                    for (URI f : AbstractApplication.this.getRecentURIs()) {
                        OpenRecentFileAction action = new OpenRecentFileAction(AbstractApplication.this, f);
                        this.openRecentMenu.add(action);
                        this.openRecentActions.add(action);
                    }
                }
                if (AbstractApplication.this.getRecentURIs().size() > 0) {
                    this.openRecentMenu.addSeparator();
                }
                this.openRecentMenu.add(clearRecentFilesItem);
            }
        }

        @Override
        public void dispose() {
            AbstractApplication.this.removePropertyChangeListener(this);
            for (Action action : this.openRecentActions) {
                if (!(action instanceof Disposable)) continue;
                ((Disposable)((Object)action)).dispose();
            }
            this.openRecentActions.clear();
        }
    }
}

