/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ocpsoft.prettytime.PrettyTime;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.web.WebSearchResult;

@Plugin(type=Searcher.class, enabled=false)
public class ImageScSearcher
implements Searcher {
    private static String URL_PREFIX = "https://forum.image.sc/search.json?q=";
    private static String POST_URL_PREFIX = "https://forum.image.sc/t";
    private static String FORUM_AVATAR_PREFIX = "https://forum.image.sc";
    private static String TERM_SUFFIX = " tags:imagej";
    @Parameter
    private LogService logService;

    @Override
    public String title() {
        return "Image.sc Forum";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        try {
            URL url = new URL(URL_PREFIX + URLEncoder.encode(text + TERM_SUFFIX, "utf-8"));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Api-Username", "imagesc-bot");
            con.setRequestProperty("Api-Key", "b1a28dbb29c385e06026482661c8de55dd01972ff993bea6547783e52e8a017d");
            InputStream is = con.getInputStream();
            try (InputStreamReader sr = new InputStreamReader(is, "UTF-8");
                 BufferedReader reader = new BufferedReader(sr);){
                HashMap topicTitleMap = new HashMap();
                HashMap topicTagMap = new HashMap();
                JsonObject info = new JsonStreamParser((Reader)reader).next().getAsJsonObject();
                JsonArray topics = info.get("topics").getAsJsonArray();
                topics.forEach(t -> this.appendTopicMaps(t.getAsJsonObject(), topicTitleMap, topicTagMap));
                JsonArray posts = info.get("posts").getAsJsonArray();
                posts.forEach(p -> searchResults.add(this.createResult(p.getAsJsonObject(), topicTitleMap, topicTagMap)));
            }
        }
        catch (MalformedURLException exc) {
            this.logService.warn((Throwable)exc);
        }
        catch (UnsupportedEncodingException exc) {
            this.logService.warn((Throwable)exc);
        }
        catch (IOException exc) {
            this.logService.warn((Throwable)exc);
        }
        return searchResults;
    }

    private void appendTopicMaps(JsonObject t, Map<String, String> topicTitleMap, Map<String, String> topicTagMap) {
        topicTitleMap.put(this.get(t, "id"), this.get(t, "title"));
        topicTagMap.put(this.get(t, "id"), String.join((CharSequence)", ", StreamSupport.stream(t.get("tags").getAsJsonArray().spliterator(), false).map(j -> j.getAsString()).collect(Collectors.toList())));
    }

    private SearchResult createResult(JsonObject post, Map<String, String> topics, Map<String, String> tags) {
        String title = topics.get(this.get(post, "topic_id"));
        String displayName = this.get(post, "name");
        displayName = displayName + (displayName.isEmpty() ? this.get(post, "username") : " (" + this.get(post, "username") + ")");
        String iconPath = this.get(post, "avatar_template").replace("{size}", "16");
        if (!iconPath.startsWith("https://")) {
            iconPath = FORUM_AVATAR_PREFIX + iconPath;
        }
        LinkedHashMap<String, String> extraProps = new LinkedHashMap<String, String>();
        extraProps.put("Created", this.formatDate(this.get(post, "created_at")) + " by " + displayName);
        extraProps.put("Tags", tags.get(this.get(post, "topic_id")));
        extraProps.put("Likes", "\u2665 " + this.get(post, "like_count"));
        return new WebSearchResult(title, String.join((CharSequence)"/", POST_URL_PREFIX, this.get(post, "topic_id"), this.get(post, "post_number")), this.get(post, "blurb"), iconPath, extraProps);
    }

    private String get(JsonObject post, String key) {
        return post.get(key).getAsString();
    }

    private String formatDate(String datestr) {
        Instant instant = Instant.parse(datestr);
        return new PrettyTime().format(Date.from(instant));
    }

    public static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }
}

