/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.demo;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.demo.MakeAndGetSurfaceDemo;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.WaitForUserDialog;

public class MakeSurfaceFromMaskDemo {
    public static void main(String ... args) throws Exception {
        try {
            MakeAndGetSurfaceDemo.main(new String[0]);
            ImagePlus surfaceImp = IJ.getImage();
            if (args.length > 0 && args[0].equals("Test Mode")) {
                IJ.log("The surface will be skeletonized ...");
            } else {
                new WaitForUserDialog("The surface will be skeletonized ...").show();
            }
            Prefs.blackBackground = true;
            IJ.run(surfaceImp, "Skeletonize", "stack");
            if (args.length > 0 && args[0].equals("Test Mode")) {
                IJ.log("And sent back to Imaris ...");
            } else {
                new WaitForUserDialog("And sent back to Imaris ...").show();
            }
            ISurfacesPrx surface = EasyXT.Surfaces.create(surfaceImp);
            EasyXT.Scene.addItem((IDataItemPrx)surface);
            surfaceImp.changes = false;
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }
}

