/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.demo;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.IDataSetPrx;
import Imaris.ISpotsPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.demo.FreshStartWithIJAndBIOPImsSample;
import ij.ImagePlus;
import java.net.URISyntaxException;
import net.imagej.ImageJ;

public class GetSurfacesAndSpotsLabelsDemo {
    public static void main(String ... args) throws Error, URISyntaxException {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        FreshStartWithIJAndBIOPImsSample.main(new String[0]);
        ISurfacesPrx surface = EasyXT.Surfaces.create(2).setSmoothingWidth(0.275).setLocalContrastFilterWidth(1.0).setLowerThreshold(40.0).setUpperThreshold(255.0).setName("My Surface").setColor(new Integer[]{255, 120, 45}).build().detect();
        EasyXT.Scene.addItem((IDataItemPrx)surface);
        ImagePlus label_imp = EasyXT.Surfaces.getLabelsImage(surface);
        label_imp.show();
        EasyXT.Dataset.setBitDepth(label_imp.getBitDepth());
        ISpotsPrx detected_ellipticSpots = EasyXT.Spots.create(0).setName("My Elliptic Region Grown Spots").setDiameterXYZ(1.0, 2.0).isSubtractBackground(true).setFilter("\"Quality\" above 15.0").isRegionsFromLocalContrast(true).setRegionsThresholdManual(40.0).isRegionsSpotsDiameterFromVolume(true).isCreateRegionsChannel(false).setColor(new Integer[]{255, 128, 0}).build().detect();
        EasyXT.Scene.addItem((IDataItemPrx)detected_ellipticSpots);
        ImagePlus spots_label_imp = EasyXT.Spots.getLabelsImage(detected_ellipticSpots);
        spots_label_imp.show();
        IDataSetPrx newDataset = EasyXT.Dataset.getCurrent().Clone();
        EasyXT.Dataset.addChannels(label_imp, newDataset);
        EasyXT.Dataset.addChannels(spots_label_imp, newDataset);
        EasyXT.Dataset.setCurrent(newDataset);
        System.out.println("Done!");
    }
}

