/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.demo;

import Imaris.IDataItemPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.StatsQuery;
import ch.epfl.biop.imaris.SurfacesDetector;
import ch.epfl.biop.imaris.demo.FreshStartWithIJAndBIOPImsSample;
import ij.measure.ResultsTable;
import java.util.Arrays;

public class GetStatisticsDemo {
    public static void main(String ... args) throws Exception {
        FreshStartWithIJAndBIOPImsSample.main(new String[0]);
        ISurfacesPrx surface = SurfacesDetector.Channel(0).setSmoothingWidth(1.0).setLowerThreshold(40.0).setName("My Surface").setColor(new Integer[]{255, 120, 45}).build().detect();
        ResultsTable stats1 = EasyXT.Stats.export((IDataItemPrx)surface);
        stats1.show("All Statistics");
        ResultsTable stats2 = EasyXT.Stats.export((IDataItemPrx)surface, "Intensity Mean");
        stats2.show("Mean Intensity Statistics");
        ResultsTable stats3 = EasyXT.Stats.export((IDataItemPrx)surface, Arrays.asList("Intensity Mean", "Intensity Sum"));
        stats3.show("Intensity Results");
        ResultsTable stats4 = EasyXT.Stats.export((IDataItemPrx)surface, Arrays.asList("Intensity Mean", "Intensity Sum"), (Integer)1);
        stats4.show("Intensity Results C1");
        ResultsTable stats5 = EasyXT.Stats.export((IDataItemPrx)surface, Arrays.asList("Intensity Mean", "Intensity Sum"), Arrays.asList(1, 2));
        stats5.show("Intensity Results 2 Channels");
        ResultsTable stats6 = new StatsQuery((IDataItemPrx)surface).selectStatistics(Arrays.asList("Area", "Sphericity")).selectTime(1).get();
        stats6.show("Using StatsQuery Directly");
    }
}

