/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.demo;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.ISpotsPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.ImarisCalibration;
import ch.epfl.biop.imaris.demo.FreshStartWithIJAndBIOPImsSample;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import java.util.Random;
import mcib3d.geom.Point3D;

public class CreateSpotsAndSurfacesFromImageJDemo {
    public static void main(String[] args) throws Error {
        FreshStartWithIJAndBIOPImsSample.main(new String[0]);
        ImarisCalibration cal = EasyXT.Dataset.getCalibration();
        Random rnd = new Random(300484L);
        int nSpots = 10;
        int nT = cal.tSize;
        Point3D radius = new Point3D(2.0, 2.0, 3.0);
        ArrayList<Point3D> coordinates = new ArrayList<Point3D>(nSpots * nT);
        ArrayList<Integer> timepoints = new ArrayList<Integer>(nSpots * nT);
        ArrayList<Point3D> radii = new ArrayList<Point3D>(nSpots * nT);
        PrimitiveIterator.OfDouble rx = rnd.doubles(cal.xOrigin, cal.xEnd).iterator();
        PrimitiveIterator.OfDouble ry = rnd.doubles(cal.yOrigin, cal.yEnd).iterator();
        PrimitiveIterator.OfDouble rz = rnd.doubles(cal.zOrigin, cal.zEnd).iterator();
        for (int t = 0; t < nT; ++t) {
            for (int i = 0; i < nSpots; ++i) {
                coordinates.add(new Point3D(rx.next().doubleValue(), ry.next().doubleValue(), rz.next().doubleValue()));
                timepoints.add(t);
                radii.add(radius);
            }
        }
        ISpotsPrx spots = EasyXT.Spots.create(coordinates, radii, timepoints);
        EasyXT.Scene.setName((IDataItemPrx)spots, "Random Spots");
        EasyXT.Scene.addItem((IDataItemPrx)spots);
        ImagePlus imp = EasyXT.Dataset.getImagePlus(EasyXT.Dataset.getCurrent());
        IJ.run(imp, "Convert to Mask", "method=Default background=Dark black");
        ISurfacesPrx surface = EasyXT.Surfaces.create(imp);
        EasyXT.Scene.setName((IDataItemPrx)surface, "Surface From Mask");
        EasyXT.Scene.addItem((IDataItemPrx)surface);
    }
}

