/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.demo;

import Imaris.Error;
import Imaris.IDataContainerPrx;
import Imaris.IDataItemPrx;
import Imaris.IFramePrx;
import Imaris.ISpotsPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.ItemQuery;
import ch.epfl.biop.imaris.SpotsDetector;
import ch.epfl.biop.imaris.demo.FreshStartWithIJAndBIOPImsSample;
import ij.IJ;
import java.util.List;
import java.util.logging.Level;

public class AllGettersDemo {
    public static void main(String ... args) throws Exception {
        try {
            FreshStartWithIJAndBIOPImsSample.main(new String[0]);
            IDataContainerPrx itemGroup = EasyXT.Scene.createGroup("Spots And Surface");
            EasyXT.Scene.addItem((IDataItemPrx)itemGroup);
            ISpotsPrx spots = SpotsDetector.Channel(2).setName("My Spots").setDiameter(3.0).setRegionsThresholdManual(100.0).isSubtractBackground(true).isRegionsFromLocalContrast(true).isRegionsSpotsDiameterFromVolume(false).isCreateRegionsChannel(false).build().detect();
            EasyXT.Scene.addItem((IDataItemPrx)spots);
            ISpotsPrx spots2 = SpotsDetector.Channel(1).setName("Sub Spots").setDiameter(2.0).setRegionsThresholdManual(100.0).isSubtractBackground(true).isRegionsFromLocalContrast(true).isRegionsSpotsDiameterFromVolume(false).isCreateRegionsChannel(false).build().detect();
            EasyXT.Scene.addItem((IDataItemPrx)spots2, itemGroup);
            ISurfacesPrx surface = EasyXT.Surfaces.create(0).setSmoothingWidth(1.0).setLowerThreshold(40.0).setName("My Surface").setColor(new Integer[]{255, 120, 45}).build().detect();
            EasyXT.Scene.addItem((IDataItemPrx)surface);
            ISpotsPrx spotByName = EasyXT.Spots.find("My Spots");
            ISpotsPrx subSpotByName = EasyXT.Spots.find("Sub Spots", itemGroup);
            List<ISpotsPrx> spotsList = EasyXT.Spots.findAll();
            for (ISpotsPrx iSpotsPrx : spotsList) {
                IJ.log(EasyXT.Scene.getName((IDataItemPrx)iSpotsPrx));
            }
            ItemQuery.isRecursiveSearch = true;
            List<ISpotsPrx> recursiveSpotsList = EasyXT.Spots.findAll();
            for (ISpotsPrx iSpotsPrx : recursiveSpotsList) {
                IJ.log("Recursively: " + EasyXT.Scene.getName((IDataItemPrx)iSpotsPrx));
            }
            ItemQuery.isRecursiveSearch = false;
            ISurfacesPrx iSurfacesPrx = EasyXT.Surfaces.find("My Surface");
            List<ISurfacesPrx> surfacesList = EasyXT.Surfaces.findAll();
            IDataItemPrx rawFrame = EasyXT.Scene.findItem("Frame 1");
            IJ.log(String.valueOf(rawFrame));
            IJ.log("Is " + EasyXT.Scene.getName(rawFrame) + " an IFramePrx?  - " + (rawFrame instanceof IFramePrx));
            IFramePrx frame = (IFramePrx)rawFrame;
            IDataContainerPrx parent = EasyXT.Scene.createGroup("Some Parent");
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setName("Spots 1").setParent(parent).build();
            List<IDataItemPrx> items = query.find();
            List<IDataItemPrx> allRawSpots = EasyXT.Scene.findAll("Spots");
            List<IDataItemPrx> allRawSurfaces = EasyXT.Scene.findAll("Surfaces");
            List<IDataItemPrx> allVolumes = EasyXT.Scene.findAll("Volume");
            IJ.log("Spot: " + spotByName.GetName());
        }
        catch (Error error) {
            EasyXT.log.log(Level.SEVERE, "Error during Demo:", error);
        }
    }
}

