/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.command;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>EasyXT>Surface>Make Surface In Imaris")
public class MakeSurfaceCommand
implements Command {
    @Parameter(label="Channel, zero index based")
    int channelIndex;
    @Parameter
    String surfaceName;
    @Parameter
    ColorRGB color;
    @Parameter
    double smoothingWidth = -1.0;
    @Parameter
    double lowerThreshold;

    public void run() {
        try {
            ISurfacesPrx surf = EasyXT.Surfaces.create(this.channelIndex).setSmoothingWidth(this.smoothingWidth).setLowerThreshold(this.lowerThreshold).setName(this.surfaceName).setColor(new Integer[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()}).build().detect();
            EasyXT.Scene.addItem((IDataItemPrx)surf);
            surf.SetVisible(false);
            surf.SetVisible(true);
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }
}

