/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris.command;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import ij.ImagePlus;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>EasyXT>Surface>Send Labels Image as Surface(s) to Imaris")
public class LabelsImageToSurfaceCommand
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter
    Boolean sendImp;

    public void run() {
        try {
            ISurfacesPrx surface = EasyXT.Surfaces.createFromLabels(this.imp);
            EasyXT.Scene.addItem((IDataItemPrx)surface);
            if (this.sendImp.booleanValue()) {
                if (this.imp.getBitDepth() == EasyXT.Dataset.getBitDepth(EasyXT.Dataset.getCurrent())) {
                    EasyXT.Dataset.addChannels(this.imp);
                } else {
                    System.out.println("Labels image and Imaris dataset have different bitdepth");
                }
            }
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }
}

