/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataSetPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;

public class SurfacesDetector {
    IDataSetPrx aDataSet;
    int[][] aRegionsOfInterest;
    Integer aChannelIndex;
    Float aSmoothFilterWidth;
    Float aLocalContrastFilterWidth;
    Boolean aIntensityLowerThresholdAutomatic;
    Float aIntensityLowerThresholdManual;
    String aSurfaceFiltersString;
    Float aSeedsEstimateDiameter;
    Boolean aSeedsSubtractBackground;
    String aSeedsFiltersString;
    Boolean aLowerThresholdEnabled;
    Boolean aUpperThresholdEnabled;
    Boolean aIntensityUpperThresholdAutomatic;
    Float aIntensityUpperThresholdManual;
    String name;
    Integer[] color;

    public ISurfacesPrx detect() throws Error {
        ISurfacesPrx surfaces = this.aUpperThresholdEnabled != null || this.aIntensityUpperThresholdAutomatic != null || this.aIntensityUpperThresholdManual != null ? (this.aSeedsEstimateDiameter == null ? EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSurfacesWithUpperThreshold(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aSmoothFilterWidth.floatValue(), this.aLocalContrastFilterWidth.floatValue(), this.aLowerThresholdEnabled.booleanValue(), this.aIntensityLowerThresholdAutomatic.booleanValue(), this.aIntensityLowerThresholdManual.floatValue(), this.aUpperThresholdEnabled.booleanValue(), this.aIntensityUpperThresholdAutomatic.booleanValue(), this.aIntensityUpperThresholdManual.floatValue(), this.aSurfaceFiltersString) : EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSurfacesRegionGrowingWithUpperThreshold(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aSmoothFilterWidth.floatValue(), this.aLocalContrastFilterWidth.floatValue(), this.aLowerThresholdEnabled.booleanValue(), this.aIntensityLowerThresholdAutomatic.booleanValue(), this.aIntensityLowerThresholdManual.floatValue(), this.aUpperThresholdEnabled.booleanValue(), this.aIntensityUpperThresholdAutomatic.booleanValue(), this.aIntensityUpperThresholdManual.floatValue(), this.aSeedsEstimateDiameter.floatValue(), this.aSeedsSubtractBackground.booleanValue(), this.aSeedsFiltersString, this.aSurfaceFiltersString)) : (this.aSeedsEstimateDiameter != null || this.aSeedsSubtractBackground != null || this.aSeedsFiltersString != null ? EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSurfacesRegionGrowing(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aSmoothFilterWidth.floatValue(), this.aLocalContrastFilterWidth.floatValue(), this.aIntensityLowerThresholdAutomatic.booleanValue(), this.aIntensityLowerThresholdManual.floatValue(), this.aSeedsEstimateDiameter.floatValue(), this.aSeedsSubtractBackground.booleanValue(), this.aSeedsFiltersString, this.aSurfaceFiltersString) : EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSurfaces(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aSmoothFilterWidth.floatValue(), this.aLocalContrastFilterWidth.floatValue(), this.aIntensityLowerThresholdAutomatic.booleanValue(), this.aIntensityLowerThresholdManual.floatValue(), this.aSurfaceFiltersString));
        if (this.name != null) {
            surfaces.SetName(this.name);
        }
        if (this.color != null) {
            surfaces.SetColorRGBA(this.color[0] + this.color[1] * 256 + this.color[2] * 256 * 256);
        }
        return surfaces;
    }

    public static SurfacesDetectorBuilder Channel(int indexChannel) throws Error {
        return SurfacesDetectorBuilder.aSurfacesDetector(indexChannel);
    }

    public static final class SurfacesDetectorBuilder {
        IDataSetPrx aDataSet;
        int[][] aRegionsOfInterest;
        Integer aChannelIndex;
        Float aSmoothFilterWidth = new Float(0.0f);
        Float aLocalContrastFilterWidth = new Float(0.0f);
        String aSurfaceFiltersString;
        Float aSeedsEstimateDiameter;
        Boolean aSeedsSubtractBackground;
        String aSeedsFiltersString;
        Boolean aLowerThresholdEnabled;
        Boolean aIntensityLowerThresholdAutomatic = Boolean.TRUE;
        Float aIntensityLowerThresholdManual = new Float(0.0f);
        Boolean aUpperThresholdEnabled;
        Boolean aIntensityUpperThresholdAutomatic;
        Float aIntensityUpperThresholdManual;
        Integer[] color;
        String name;

        private SurfacesDetectorBuilder(int channelIndex) throws Error {
            this.aDataSet = EasyXT.Utils.getImarisApp().GetDataSet();
            this.aChannelIndex = channelIndex;
        }

        public static SurfacesDetectorBuilder aSurfacesDetector(int channelIndex) throws Error {
            return new SurfacesDetectorBuilder(channelIndex);
        }

        public SurfacesDetectorBuilder setDataSet(IDataSetPrx aDataSet) {
            this.aDataSet = aDataSet;
            return this;
        }

        public SurfacesDetectorBuilder setROI(int[][] aRegionsOfInterest) {
            this.aRegionsOfInterest = aRegionsOfInterest;
            return this;
        }

        public SurfacesDetectorBuilder setSmoothingWidth(double aSmoothFilterWidth) {
            this.aSmoothFilterWidth = new Float(aSmoothFilterWidth);
            return this;
        }

        public SurfacesDetectorBuilder setLocalContrastFilterWidth(double aLocalContrastFilterWidth) {
            this.aLocalContrastFilterWidth = new Float(aLocalContrastFilterWidth);
            return this;
        }

        public SurfacesDetectorBuilder setSurfaceFilter(String aSurfaceFiltersString) {
            this.aSurfaceFiltersString = aSurfaceFiltersString;
            return this;
        }

        public SurfacesDetectorBuilder setSeedsDiameter(double aSeedsEstimateDiameter) {
            this.aSeedsEstimateDiameter = new Float(aSeedsEstimateDiameter);
            return this;
        }

        public SurfacesDetectorBuilder isSeedsSubtractBackground(Boolean aSeedsSubtractBackground) {
            this.aSeedsSubtractBackground = aSeedsSubtractBackground;
            return this;
        }

        public SurfacesDetectorBuilder setSeedsFilter(String aSeedsFiltersString) {
            this.aSeedsFiltersString = aSeedsFiltersString;
            return this;
        }

        public SurfacesDetectorBuilder enableAutomaticLowerThreshold() {
            this.aIntensityLowerThresholdAutomatic = true;
            this.aLowerThresholdEnabled = true;
            return this;
        }

        public SurfacesDetectorBuilder setLowerThreshold(double aIntensityLowerThresholdManual) {
            this.aIntensityLowerThresholdManual = new Float(aIntensityLowerThresholdManual);
            this.aLowerThresholdEnabled = true;
            this.aIntensityLowerThresholdAutomatic = false;
            return this;
        }

        public SurfacesDetectorBuilder enableAutomaticUpperThreshold() {
            this.aIntensityUpperThresholdAutomatic = true;
            this.aUpperThresholdEnabled = true;
            return this;
        }

        public SurfacesDetectorBuilder setUpperThreshold(double aIntensityUpperThresholdManual) {
            this.aIntensityUpperThresholdManual = new Float(aIntensityUpperThresholdManual);
            this.aUpperThresholdEnabled = true;
            this.aIntensityUpperThresholdAutomatic = false;
            return this;
        }

        public SurfacesDetectorBuilder setColor(Integer[] color) {
            this.color = color;
            return this;
        }

        public SurfacesDetectorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SurfacesDetector build() {
            SurfacesDetector surfacesDetector = new SurfacesDetector();
            surfacesDetector.aIntensityLowerThresholdManual = this.aIntensityLowerThresholdManual;
            surfacesDetector.aUpperThresholdEnabled = this.aUpperThresholdEnabled;
            surfacesDetector.aDataSet = this.aDataSet;
            surfacesDetector.aLocalContrastFilterWidth = this.aLocalContrastFilterWidth;
            surfacesDetector.aRegionsOfInterest = this.aRegionsOfInterest;
            surfacesDetector.aLowerThresholdEnabled = this.aLowerThresholdEnabled;
            surfacesDetector.aIntensityUpperThresholdManual = this.aIntensityUpperThresholdManual;
            surfacesDetector.color = this.color;
            surfacesDetector.name = this.name;
            surfacesDetector.aSeedsEstimateDiameter = this.aSeedsEstimateDiameter;
            surfacesDetector.aSeedsFiltersString = this.aSeedsFiltersString;
            surfacesDetector.aSurfaceFiltersString = this.aSurfaceFiltersString;
            surfacesDetector.aIntensityLowerThresholdAutomatic = this.aIntensityLowerThresholdAutomatic;
            surfacesDetector.aSeedsSubtractBackground = this.aSeedsSubtractBackground;
            surfacesDetector.aSmoothFilterWidth = this.aSmoothFilterWidth;
            surfacesDetector.aIntensityUpperThresholdAutomatic = this.aIntensityUpperThresholdAutomatic;
            surfacesDetector.aChannelIndex = this.aChannelIndex;
            return surfacesDetector;
        }
    }
}

