/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.cStatisticValues;
import ch.epfl.biop.imaris.EasyXT;
import ij.measure.ResultsTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class StatsQuery {
    private static final List<String> firstColumns = Arrays.asList("Label", "Name", "ID", "Timepoint", "Category");
    private static final Consumer<String> log = str -> System.out.println("StatsQuery : " + str);
    private final String itemName;
    private final cStatisticValues stats;
    private final List<Long> ids = new ArrayList<Long>();
    private final List<String> names = new ArrayList<String>();
    private List<String> timepoints = new ArrayList<String>();
    private List<String> channels = new ArrayList<String>();
    private int nImages = 1;
    private boolean getGlobalStatsOnly = false;
    private ResultsTable results = new ResultsTable();

    public StatsQuery(IDataItemPrx item) throws Error {
        this.stats = item.GetStatistics();
        int imageFactor = Arrays.asList(this.stats.mFactorNames).indexOf("Image");
        this.nImages = Arrays.stream(this.stats.mFactors[imageFactor]).distinct().collect(Collectors.toList()).size() - 1;
        if (this.nImages > 1) {
            log.accept("More than one image: 'Image' will be appended to some column names ");
        }
        this.itemName = item.GetName();
    }

    public static Map<Long, Map<String, Double>> extractStatistic(ResultsTable results, String statName) {
        if (results.columnExists(statName)) {
            LinkedHashMap<Long, Map<String, Double>> stat = new LinkedHashMap<Long, Map<String, Double>>(results.size());
            for (int i = 0; i < results.size(); ++i) {
                LinkedHashMap<String, Double> values = new LinkedHashMap<String, Double>();
                for (String col : firstColumns) {
                    values.put(col, results.getValue(col, i));
                }
                values.put(statName, results.getValue(statName, i));
                stat.put((long)results.getValue("ID", i), values);
            }
            return stat;
        }
        log.accept("The statistic: '" + statName + "' does not exist in the provided Results Table");
        return null;
    }

    public StatsQuery globalStats() {
        this.getGlobalStatsOnly = true;
        return this;
    }

    public StatsQuery selectId(Integer id) {
        this.ids.add(id.longValue());
        return this;
    }

    public StatsQuery resultsTable(ResultsTable rt) {
        this.results = rt;
        return this;
    }

    public StatsQuery selectIds(List<Integer> ids) {
        this.ids.addAll(ids.stream().map(id -> id.longValue()).collect(Collectors.toList()));
        return this;
    }

    public StatsQuery selectStatistic(String name) {
        this.names.add(name);
        return this;
    }

    public StatsQuery selectStatistics(List<String> names) {
        this.names.addAll(names);
        return this;
    }

    public StatsQuery selectTime(Integer timepoint) {
        this.timepoints.add(timepoint.toString());
        return this;
    }

    public StatsQuery selectTimes(List<Integer> timepoints) {
        this.timepoints = timepoints.stream().map(t -> t.toString()).collect(Collectors.toList());
        return this;
    }

    public StatsQuery selectChannel(Integer channel) {
        if (channel > 0) {
            this.channels.add(channel.toString());
        }
        return this;
    }

    public StatsQuery selectChannels(List<Integer> channels) {
        this.channels = channels.stream().map(c -> c.toString()).collect(Collectors.toList());
        return this;
    }

    public StatsQuery appendTo(ResultsTable results) {
        for (int i = 0; i < results.size(); ++i) {
            this.results.incrementCounter();
            for (String c : results.getHeadings()) {
                String stringVal = results.getStringValue(c, i);
                if (!this.isDoubleValue(stringVal).booleanValue()) {
                    this.results.addValue(c, stringVal);
                    continue;
                }
                this.results.addValue(c, results.getValue(c, i));
            }
        }
        return this;
    }

    private Boolean isDoubleValue(String stringTotTest) {
        try {
            Double dummy = Double.parseDouble(stringTotTest);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public ResultsTable get() throws Error {
        ArrayList selectedIndexes = new ArrayList();
        HashMap statsById = new HashMap();
        String imageName = new File(EasyXT.Files.getOpenFileName()).getName();
        for (int i = 0; i < this.stats.mIds.length; ++i) {
            boolean matchesID;
            boolean matchesTime;
            Object timeIdx;
            boolean matchesChannel;
            Iterator<String> name;
            boolean matchesName;
            if (this.names.size() > 0) {
                matchesName = false;
                Iterator<String> iterator = this.names.iterator();
                while (iterator.hasNext() && !(matchesName = this.stats.mNames[i].matches((String)((Object)(name = iterator.next()))))) {
                }
            } else {
                matchesName = true;
            }
            if (this.channels.size() > 0) {
                matchesChannel = false;
                Integer channelIdx = Arrays.asList(this.stats.mFactorNames).indexOf("Channel");
                name = this.channels.iterator();
                while (name.hasNext()) {
                    String channel = (String)name.next();
                    matchesChannel = this.stats.mFactors[channelIdx][i].matches(channel) || this.stats.mFactors[channelIdx][i].matches("") && matchesName;
                    if (!matchesChannel) continue;
                    break;
                }
            } else {
                matchesChannel = true;
            }
            if (this.timepoints.size() > 0) {
                timeIdx = Arrays.asList(this.stats.mFactorNames).indexOf("Time");
                matchesTime = false;
                name = this.timepoints.iterator();
                while (name.hasNext()) {
                    String time = name.next();
                    matchesTime = this.stats.mFactors[(Integer)timeIdx][i].matches(time);
                    if (!matchesTime) continue;
                    break;
                }
            } else {
                matchesTime = true;
            }
            if (this.ids.size() > 0) {
                Long id;
                matchesID = false;
                timeIdx = this.ids.iterator();
                while (timeIdx.hasNext() && !(matchesID = this.stats.mIds[i] == (id = (Long)timeIdx.next()))) {
                }
            } else {
                matchesID = true;
            }
            if (!matchesName || !matchesChannel || !matchesID || !matchesTime || (this.stats.mIds[i] != -1L || !this.getGlobalStatsOnly) && (this.stats.mIds[i] == -1L || this.getGlobalStatsOnly)) continue;
            String name2 = this.stats.mNames[i];
            Float value = Float.valueOf(this.stats.mValues[i]);
            long id = this.stats.mIds[i];
            HashMap<String, String> statElements = statsById.containsKey(id) ? (Map)statsById.get(id) : new HashMap<String, String>();
            statElements.put("Label", imageName);
            statElements.put("ID", String.valueOf(id));
            statElements.put("Name", this.itemName);
            block20: for (int factorIdx = 0; factorIdx < this.stats.mFactorNames.length; ++factorIdx) {
                String factorName = this.stats.mFactorNames[factorIdx];
                String factorValue = this.stats.mFactors[factorIdx][i];
                if (factorValue.equals("")) continue;
                switch (factorName) {
                    case "Time": {
                        statElements.put("Timepoint", factorValue);
                        continue block20;
                    }
                    case "Category": {
                        statElements.put("Category", factorValue);
                        continue block20;
                    }
                    case "Collection": 
                    case "Time Index": {
                        continue block20;
                    }
                    case "Image": {
                        if (this.nImages <= 1) continue block20;
                        name2 = name2 + " : " + factorValue;
                        continue block20;
                    }
                    case "Channel": {
                        name2 = name2 + " C" + factorValue;
                        continue block20;
                    }
                    default: {
                        name2 = name2 + " : " + factorName + " : " + factorValue;
                    }
                }
            }
            name2 = name2.replaceAll(",", "");
            statElements.put(name2, String.valueOf(value));
            statsById.put(id, statElements);
        }
        Map statsByIdSorted = new ImarisResultComparator().sort(statsById);
        statsByIdSorted.forEach((uid, columns) -> {
            this.results.incrementCounter();
            firstColumns.forEach(name -> {
                if (this.isNumber((String)columns.get(name))) {
                    this.results.addValue((String)name, (double)Double.valueOf((String)columns.get(name)));
                } else {
                    this.results.addValue((String)name, (String)columns.get(name));
                }
                columns.remove(name);
            });
            columns.forEach((name, value) -> {
                if (this.isNumber((String)value)) {
                    this.results.addValue((String)name, (double)Double.valueOf(value));
                } else {
                    this.results.addValue((String)name, (String)value);
                }
            });
        });
        return this.results;
    }

    private boolean isNumber(String test) {
        try {
            Double.valueOf(test);
            return true;
        }
        catch (NullPointerException | NumberFormatException ne) {
            return false;
        }
    }

    class ImarisColumnComparator
    implements Comparator<Map.Entry<String, String>> {
        ImarisColumnComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }

        public Map<String, String> sort(Map<String, String> columnMap) {
            ArrayList<Map.Entry<String, String>> columnList = new ArrayList<Map.Entry<String, String>>(columnMap.entrySet());
            Collections.sort(columnList, this);
            LinkedHashMap<String, String> sortedColumn = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : columnList) {
                sortedColumn.put(entry.getKey(), entry.getValue());
            }
            return sortedColumn;
        }
    }

    class ImarisResultComparator
    implements Comparator<Map.Entry<Long, Map<String, String>>> {
        ImarisResultComparator() {
        }

        @Override
        public int compare(Map.Entry<Long, Map<String, String>> o1, Map.Entry<Long, Map<String, String>> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }

        private Map<Long, Map<String, String>> sort(Map<Long, Map<String, String>> idMap) {
            ArrayList<Map.Entry<Long, Map<String, String>>> idList = new ArrayList<Map.Entry<Long, Map<String, String>>>(idMap.entrySet());
            Collections.sort(idList, this);
            LinkedHashMap<Long, Map<String, String>> sortedMap = new LinkedHashMap<Long, Map<String, String>>();
            for (Map.Entry<Long, Map<String, String>> entry : idList) {
                Map<String, String> columns = new ImarisColumnComparator().sort(entry.getValue());
                sortedMap.put(entry.getKey(), columns);
            }
            return sortedMap;
        }
    }
}

