/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.cStatisticValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class StatsCreator {
    private static final Consumer<String> log = str -> System.out.println("StatsCreator : " + str);
    private String channel = "";
    private final String statName;
    private final Map<Long, Map<String, Double>> statValues;
    private final IDataItemPrx item;
    private Integer time;
    private final List<String> units;
    private String category;

    public StatsCreator(IDataItemPrx item, String statName, Map<Long, Map<String, Double>> values) {
        this.item = item;
        this.statName = statName;
        this.statValues = values;
        this.time = 1;
        this.units = new ArrayList<String>(this.statValues.size());
        for (int t = 0; t < this.statValues.size(); ++t) {
            this.units.add("");
        }
    }

    public StatsCreator setTimepoint(Integer timepoint) {
        this.time = timepoint;
        return this;
    }

    public StatsCreator setChannel(Integer channel) {
        if (channel != null) {
            this.channel = channel.toString();
        }
        return this;
    }

    public StatsCreator setCategory(String category) {
        this.category = category;
        return this;
    }

    public StatsCreator setUnit(String unit) {
        this.units.clear();
        for (int i = 0; i < this.statValues.size(); ++i) {
            this.units.add(unit);
        }
        return this;
    }

    public void send() throws Error {
        if (this.statValues.size() == 0) {
            throw new Error("No statistics", "No statistics were set", "The statistic values list was empty when using 'StatsCreator.send()'");
        }
        if (this.item == null) {
            throw new Error("Null Imaris object", "Imaris Object was null", "The Imaris object provided to 'StatsCreator.send()' was null");
        }
        if (!this.statValues.get(this.statValues.keySet().iterator().next()).containsKey("Timepoint")) {
            log.accept("Your custom statistic has no timepoints, associating to timepoint " + this.time);
        }
        cStatisticValues rawStats = this.item.GetStatistics();
        String[] factorNames = rawStats.mFactorNames;
        int n = this.statValues.size();
        String[] finalStatNames = new String[n];
        String[] finalStatUnits = new String[n];
        long[] finalStatIds = new long[n];
        float[] finalStatValues = new float[n];
        String[][] finalStatFactors = new String[factorNames.length][n];
        for (int i = 0; i < factorNames.length; ++i) {
            finalStatFactors[i] = new String[n];
            for (int j = 0; j < n; ++j) {
                finalStatFactors[i][j] = "";
            }
        }
        int channelIdx = Arrays.asList(factorNames).indexOf("Channel");
        int timeIdx = Arrays.asList(factorNames).indexOf("Time");
        int catIdx = Arrays.asList(factorNames).indexOf("Category");
        int i = 0;
        for (long id : this.statValues.keySet()) {
            finalStatNames[i] = this.statName;
            finalStatValues[i] = this.statValues.get(id).get(this.statName).floatValue();
            finalStatIds[i] = id;
            finalStatUnits[i] = this.units.get(i);
            finalStatFactors[channelIdx][i] = this.channel;
            finalStatFactors[timeIdx][i] = this.statValues.get(id).containsKey("Timepoint") ? String.valueOf(Math.round(this.statValues.get(id).get("Timepoint"))) : this.time.toString();
            finalStatFactors[catIdx][i] = this.category;
            ++i;
        }
        this.item.AddStatistics(finalStatNames, finalStatValues, finalStatUnits, finalStatFactors, factorNames, finalStatIds);
    }
}

