/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataSetPrx;
import Imaris.ISpotsPrx;
import ch.epfl.biop.imaris.EasyXT;
import java.util.function.Consumer;

public class SpotsDetector {
    private static final Consumer<String> log = str -> System.out.println("SpotsDetector : " + str);
    private static final Consumer<String> errlog = str -> System.err.println("SpotsDetector : " + str);
    IDataSetPrx aDataSet;
    int[][] aRegionsOfInterest;
    Integer aChannelIndex;
    Float aEstimateDiameter;
    Boolean aSubtractBackground;
    String aSpotFiltersString;
    Boolean aRegionsFromLocalContrast;
    Boolean aRegionsThresholdAutomatic;
    Float aRegionsThresholdManual;
    Boolean aRegionsSpotsDiameterFromVolume;
    Boolean aRegionsCreateChannel;
    float[] aEstimateDiameterXYZ;
    String name;
    Integer[] color;

    public static SpotsDetectorBuilder Channel(int indexChannel) throws Error {
        return SpotsDetectorBuilder.aSpotsDetector(indexChannel);
    }

    public ISpotsPrx detect() throws Error {
        ISpotsPrx spots;
        if (this.aRegionsFromLocalContrast != null || this.aRegionsThresholdAutomatic != null || this.aRegionsThresholdManual != null || this.aRegionsSpotsDiameterFromVolume != null || this.aRegionsCreateChannel != null) {
            if (this.aRegionsFromLocalContrast == null || this.aRegionsThresholdAutomatic == null || this.aRegionsThresholdManual == null || this.aRegionsSpotsDiameterFromVolume == null || this.aRegionsCreateChannel == null) {
                errlog.accept("Please specify all parameters!");
            }
            spots = this.aEstimateDiameterXYZ != null ? EasyXT.Utils.getImarisApp().GetImageProcessing().DetectEllipticSpotsRegionGrowing(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aEstimateDiameterXYZ, this.aSubtractBackground.booleanValue(), this.aSpotFiltersString, this.aRegionsFromLocalContrast.booleanValue(), this.aRegionsThresholdAutomatic.booleanValue(), this.aRegionsThresholdManual.floatValue(), this.aRegionsSpotsDiameterFromVolume.booleanValue(), this.aRegionsCreateChannel.booleanValue()) : EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSpotsRegionGrowing(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aEstimateDiameter.floatValue(), this.aSubtractBackground.booleanValue(), this.aSpotFiltersString, this.aRegionsFromLocalContrast.booleanValue(), this.aRegionsThresholdAutomatic.booleanValue(), this.aRegionsThresholdManual.floatValue(), this.aRegionsSpotsDiameterFromVolume.booleanValue(), this.aRegionsCreateChannel.booleanValue());
        } else {
            spots = this.aEstimateDiameterXYZ != null ? EasyXT.Utils.getImarisApp().GetImageProcessing().DetectEllipticSpots(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aEstimateDiameterXYZ, this.aSubtractBackground.booleanValue(), this.aSpotFiltersString) : EasyXT.Utils.getImarisApp().GetImageProcessing().DetectSpots2(this.aDataSet, this.aRegionsOfInterest, this.aChannelIndex.intValue(), this.aEstimateDiameter.floatValue(), this.aSubtractBackground.booleanValue(), this.aSpotFiltersString);
        }
        if (this.name != null) {
            spots.SetName(this.name);
        }
        if (this.color != null) {
            spots.SetColorRGBA(this.color[0] + this.color[1] * 256 + this.color[2] * 256 * 256);
        }
        return spots;
    }

    public static final class SpotsDetectorBuilder {
        IDataSetPrx aDataSet = EasyXT.Utils.getImarisApp().GetDataSet();
        int[][] aRegionsOfInterest;
        Integer aChannelIndex;
        Float aEstimateDiameter;
        Boolean aSubtractBackground;
        String aSpotFiltersString;
        Boolean aRegionsFromLocalContrast;
        Boolean aRegionsThresholdAutomatic;
        Float aRegionsThresholdManual;
        Boolean aRegionsSpotsDiameterFromVolume;
        Boolean aRegionsCreateChannel;
        float[] aEstimateDiameterXYZ;
        String name;
        Integer[] color;

        private SpotsDetectorBuilder(int channelIndex) throws Error {
            this.aChannelIndex = channelIndex;
        }

        public static SpotsDetectorBuilder aSpotsDetector(int channelIndex) throws Error {
            return new SpotsDetectorBuilder(channelIndex);
        }

        public SpotsDetectorBuilder setDataSet(IDataSetPrx aDataSet) {
            this.aDataSet = aDataSet;
            return this;
        }

        public SpotsDetectorBuilder setROI(int[][] aRegionsOfInterest) {
            this.aRegionsOfInterest = aRegionsOfInterest;
            return this;
        }

        public SpotsDetectorBuilder setColor(Integer[] color) {
            this.color = color;
            return this;
        }

        public SpotsDetectorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SpotsDetectorBuilder setDiameter(double diameter) {
            this.aEstimateDiameter = new Float(diameter);
            return this;
        }

        public SpotsDetectorBuilder setAxialDiameter(double aEstimateDiameterZ) {
            if (this.aEstimateDiameter != null) {
                this.aEstimateDiameterXYZ = new float[]{this.aEstimateDiameter.floatValue(), this.aEstimateDiameter.floatValue(), new Float(aEstimateDiameterZ).floatValue()};
            } else {
                System.err.println("EasyXT error log : Please specify XY diameter using setDiameter() when building the SpotsDetector.");
            }
            return this;
        }

        public SpotsDetectorBuilder setDiameterXYZ(double aEstimateDiameterXY, double aEstimateDiameterZ) {
            this.setDiameter(aEstimateDiameterXY);
            this.setAxialDiameter(aEstimateDiameterZ);
            return this;
        }

        public SpotsDetectorBuilder isSubtractBackground(Boolean aSubtractBackground) {
            this.aSubtractBackground = aSubtractBackground;
            return this;
        }

        public SpotsDetectorBuilder setFilter(String aFiltersString) {
            this.aSpotFiltersString = aFiltersString;
            return this;
        }

        public SpotsDetectorBuilder isRegionsFromLocalContrast(Boolean aRegionsFromLocalContrast) {
            this.aRegionsFromLocalContrast = aRegionsFromLocalContrast;
            return this;
        }

        public SpotsDetectorBuilder enableRegionsThresholdAutomatic() {
            this.aRegionsThresholdAutomatic = true;
            return this;
        }

        public SpotsDetectorBuilder setRegionsThresholdManual(double threshold) {
            this.aRegionsThresholdManual = new Float(threshold);
            this.aRegionsThresholdAutomatic = false;
            return this;
        }

        public SpotsDetectorBuilder isCreateRegionsChannel(Boolean flag) {
            this.aRegionsCreateChannel = flag;
            return this;
        }

        public SpotsDetectorBuilder isRegionsSpotsDiameterFromVolume(Boolean flag) {
            this.aRegionsSpotsDiameterFromVolume = flag;
            return this;
        }

        public SpotsDetector build() throws Error {
            Boolean throwError = false;
            if (this.aEstimateDiameter == null && this.aEstimateDiameterXYZ == null) {
                errlog.accept("aEstimateDiameter was not set, use setDiameter(double diameter) or setDiameterXYZ(double aEstimateDiameterXY, double aEstimateDiameterZ)");
            }
            if (this.aSubtractBackground == null) {
                errlog.accept("aSubtractBackground was not set, use isSubtractBackground(Boolean aSubtractBackground)");
            }
            if (this.aRegionsFromLocalContrast != null || this.aRegionsThresholdAutomatic != null || this.aRegionsThresholdManual != null || this.aRegionsSpotsDiameterFromVolume != null || this.aRegionsCreateChannel != null) {
                if (this.aRegionsFromLocalContrast == null) {
                    errlog.accept(" aRegionsFromLocalContrast was not set, use isRegionsFromLocalContrast(boolean flag)");
                    throwError = true;
                }
                if (this.aRegionsThresholdManual == null && this.aRegionsThresholdAutomatic == null) {
                    errlog.accept("No threshold method was set for region growing, please use either 'enableRegionsThresholdAutomatic() ' or 'setRegionsThresholdManual(double threshold)' ");
                    throwError = true;
                }
                if (this.aRegionsSpotsDiameterFromVolume == null) {
                    errlog.accept("aRegionsSpotsDiameterFromVolume was not set, please use isRegionsSpotsDiameterFromVolume(boolean flag)");
                    throwError = true;
                }
                if (this.aRegionsCreateChannel == null) {
                    this.aRegionsCreateChannel = false;
                    log.accept("aRegionsCreateChannel was set to false (Default Imaris behaviour), use isCreateRegionChannel(boolean flag) to change its status!");
                    throwError = true;
                }
            }
            if (throwError.booleanValue()) {
                throw new Error();
            }
            SpotsDetector spotsDetector = new SpotsDetector();
            spotsDetector.aDataSet = this.aDataSet;
            spotsDetector.aRegionsOfInterest = this.aRegionsOfInterest;
            spotsDetector.aChannelIndex = this.aChannelIndex;
            spotsDetector.aEstimateDiameter = this.aEstimateDiameter;
            spotsDetector.aSubtractBackground = this.aSubtractBackground;
            spotsDetector.aSpotFiltersString = this.aSpotFiltersString;
            spotsDetector.aRegionsFromLocalContrast = this.aRegionsFromLocalContrast;
            spotsDetector.aRegionsThresholdAutomatic = this.aRegionsThresholdAutomatic;
            spotsDetector.aRegionsThresholdManual = this.aRegionsThresholdManual;
            spotsDetector.aRegionsSpotsDiameterFromVolume = this.aRegionsSpotsDiameterFromVolume;
            spotsDetector.aRegionsCreateChannel = this.aRegionsCreateChannel;
            spotsDetector.aEstimateDiameterXYZ = this.aEstimateDiameterXYZ;
            spotsDetector.color = this.color;
            spotsDetector.name = this.name;
            return spotsDetector;
        }
    }
}

