/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Ice.ObjectPrx;
import Imaris.Error;
import Imaris.IClippingPlane;
import Imaris.IDataContainer;
import Imaris.IDataItem;
import Imaris.IDataItemPrx;
import Imaris.IFilaments;
import Imaris.IFrame;
import Imaris.IICells;
import Imaris.ILightSource;
import Imaris.IMeasurementPoints;
import Imaris.IReferenceFrames;
import Imaris.ISpots;
import Imaris.ISurfaces;
import Imaris.IVolume;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.ItemQuery;
import java.util.logging.Logger;

public enum ItemType {
    Volume(IVolume.class, t -> EasyXT.Utils.getFactory().IsVolume((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToVolume((ObjectPrx)t)),
    Spots(ISpots.class, t -> EasyXT.Utils.getFactory().IsSpots((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToSpots((ObjectPrx)t)),
    Surfaces(ISurfaces.class, t -> EasyXT.Utils.getFactory().IsSurfaces((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToSurfaces((ObjectPrx)t)),
    Cells(IICells.class, t -> EasyXT.Utils.getFactory().IsCells((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToCells((ObjectPrx)t)),
    Filaments(IFilaments.class, t -> EasyXT.Utils.getFactory().IsFilaments((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToFilaments((ObjectPrx)t)),
    ReferenceFrames(IReferenceFrames.class, t -> EasyXT.Utils.getFactory().IsReferenceFrames((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToReferenceFrames((ObjectPrx)t)),
    Points(IMeasurementPoints.class, t -> EasyXT.Utils.getFactory().IsMeasurementPoints((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToMeasurementPoints((ObjectPrx)t)),
    ClippingPlane(IClippingPlane.class, t -> EasyXT.Utils.getFactory().IsClippingPlane((ObjectPrx)t), t -> EasyXT.Utils.getFactory().ToClippingPlane((ObjectPrx)t)),
    Group(IDataContainer.class, t -> {
        try {
            return EasyXT.Utils.getImarisApp().GetFactory().IsDataContainer((ObjectPrx)t);
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
    }, t -> EasyXT.Utils.getImarisApp().GetFactory().ToDataContainer((ObjectPrx)t)),
    Light(ILightSource.class, t -> {
        try {
            return EasyXT.Utils.getImarisApp().GetFactory().IsLightSource((ObjectPrx)t);
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
    }, t -> EasyXT.Utils.getImarisApp().GetFactory().ToLightSource((ObjectPrx)t)),
    Frame(IFrame.class, t -> EasyXT.Utils.getImarisApp().GetFactory().IsFrame((ObjectPrx)t), t -> EasyXT.Utils.getImarisApp().GetFactory().ToFrame((ObjectPrx)t));

    private static final Logger log;
    private final Comparer<IDataItemPrx> comparer;
    private final Converter<IDataItemPrx> converter;
    Class cls;

    private ItemType(Class cls, Comparer<IDataItemPrx> comparer, Converter<IDataItemPrx> converter) {
        this.cls = cls;
        this.comparer = comparer;
        this.converter = converter;
    }

    boolean matches(IDataItemPrx item) {
        try {
            return this.comparer.test(item);
        }
        catch (Error e) {
            log.severe("Error while testing if item " + item.getClass().getSimpleName() + " is of type " + this.name());
            log.severe(e.toString());
            return false;
        }
    }

    IDataItemPrx convert(IDataItemPrx item) {
        try {
            return this.converter.convert(item);
        }
        catch (Error e) {
            log.severe("Error while converting item " + item.getClass().getSimpleName() + " to " + this.name());
            log.severe(e.toString());
            return null;
        }
    }

    Class<? extends IDataItem> getType() {
        return this.cls;
    }

    static {
        log = Logger.getLogger(ItemQuery.class.getName());
    }

    private static interface Comparer<T> {
        public boolean test(T var1) throws Error;
    }

    private static interface Converter<T> {
        public IDataItemPrx convert(T var1) throws Error;
    }
}

