/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Ice.ObjectPrx;
import Imaris.Error;
import Imaris.IDataItemPrx;
import Imaris.IFactoryPrx;
import Imaris.ISpotsPrx;
import Imaris.ISurfacesPrx;
import ch.epfl.biop.imaris.EasyXT;
import java.util.function.Consumer;

public class ItemTracker {
    private static final Consumer<String> log = str -> System.out.println("ItemTracker : " + str);
    private static final Consumer<String> errlog = str -> System.err.println("ItemTracker : " + str);
    IDataItemPrx aItem;
    String aTrackFiltersString;
    float aMaximalDistance;
    int aGapSize;
    float aIntensityWeight;
    String aMethod;

    public static ItemTrackerBuilder Item(IDataItemPrx aItem) throws Error {
        return ItemTrackerBuilder.setItem(aItem);
    }

    public IDataItemPrx track() throws Error {
        IFactoryPrx factory = EasyXT.Utils.getImarisApp().GetFactory();
        ISpotsPrx aItemTracked = null;
        if (this.aMethod != null) {
            if (factory.IsSpots((ObjectPrx)this.aItem)) {
                ISpotsPrx spots_totrack = (ISpotsPrx)EasyXT.Utils.convertToSubType(this.aItem);
                ISpotsPrx spots_tracked = null;
                if (this.aMethod.equals("ConnectedComponents")) {
                    spots_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSpotsConnectedComponents(spots_totrack, this.aTrackFiltersString);
                } else if (this.aMethod.equals("BrownianMotion")) {
                    spots_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSpotsBrownianMotion(spots_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod.equals("Lineage")) {
                    spots_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSpotsLineage(spots_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod.equals("AutoregressiveMotion")) {
                    spots_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSpotsAutoregressiveMotion(spots_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod.equals("AutoregressiveMotionExpert")) {
                    spots_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSpotsAutoregressiveMotionExpert(spots_totrack, this.aMaximalDistance, this.aGapSize, this.aIntensityWeight, this.aTrackFiltersString);
                }
                aItemTracked = spots_tracked;
            } else if (factory.IsSurfaces((ObjectPrx)this.aItem)) {
                ISurfacesPrx surfaces_totrack = (ISurfacesPrx)EasyXT.Utils.convertToSubType(this.aItem);
                ISurfacesPrx surfaces_tracked = null;
                if (this.aMethod == "ConnectedComponents") {
                    surfaces_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSurfacesConnectedComponents(surfaces_totrack, this.aTrackFiltersString);
                } else if (this.aMethod == "BrownianMotion") {
                    surfaces_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSurfacesBrownianMotion(surfaces_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod == "Lineage") {
                    surfaces_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSurfacesLineage(surfaces_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod == "AutoregressiveMotion") {
                    surfaces_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSurfacesAutoregressiveMotion(surfaces_totrack, this.aMaximalDistance, this.aGapSize, this.aTrackFiltersString);
                } else if (this.aMethod == "AutoregressiveMotionExpert") {
                    surfaces_tracked = EasyXT.Utils.getImarisApp().GetImageProcessing().TrackSurfacesAutoregressiveMotionExpert(surfaces_totrack, this.aMaximalDistance, this.aGapSize, this.aIntensityWeight, this.aTrackFiltersString);
                }
                if (surfaces_tracked != null && surfaces_tracked.GetNumberOfSurfaces() > 0) {
                    surfaces_tracked.AddSurface(surfaces_tracked.GetSurfaceData(0), 0);
                    surfaces_tracked.RemoveSurface(surfaces_tracked.GetNumberOfSurfaces() - 1);
                }
                aItemTracked = surfaces_tracked;
            }
        } else {
            log.accept("Please define a Tracking Method, using setMethod(...), or useConnectedComponents , use...");
        }
        return aItemTracked;
    }

    public static final class ItemTrackerBuilder {
        IDataItemPrx aItem;
        String aMethod;
        String aTrackFiltersString;
        float aMaximalDistance;
        int aGapSize;
        float aIntensityWeight;

        private ItemTrackerBuilder(IDataItemPrx aItem) throws Error {
            this.aItem = aItem;
        }

        public static ItemTrackerBuilder setItem(IDataItemPrx aItem) throws Error {
            return new ItemTrackerBuilder(aItem);
        }

        public ItemTrackerBuilder setMethod(String method) {
            this.aMethod = method;
            return this;
        }

        public ItemTrackerBuilder useConnectedComponents() {
            this.aMethod = "ConnectedComponents";
            return this;
        }

        public ItemTrackerBuilder useBrownianMotion() {
            this.aMethod = "BrownianMotion";
            return this;
        }

        public ItemTrackerBuilder useLineage() {
            this.aMethod = "Lineage";
            return this;
        }

        public ItemTrackerBuilder useAutoregressiveMotion() {
            this.aMethod = "AutoregressiveMotion";
            return this;
        }

        public ItemTrackerBuilder useAutoregressiveMotionExpert() {
            this.aMethod = "AutoregressiveMotionExpert";
            return this;
        }

        public ItemTrackerBuilder setFilter(String filter) {
            this.aTrackFiltersString = filter;
            return this;
        }

        public ItemTrackerBuilder setMaxDistance(float maximalDistance) {
            this.aMaximalDistance = maximalDistance;
            return this;
        }

        public ItemTrackerBuilder setGapSize(int gapSize) {
            this.aGapSize = gapSize;
            return this;
        }

        public ItemTrackerBuilder setIntensityWeight(int intensityWeight) {
            this.aIntensityWeight = intensityWeight;
            return this;
        }

        public ItemTracker build() throws Error {
            ItemTracker itemTracker = new ItemTracker();
            itemTracker.aItem = this.aItem;
            itemTracker.aMethod = this.aMethod;
            itemTracker.aTrackFiltersString = this.aTrackFiltersString;
            itemTracker.aGapSize = this.aGapSize;
            itemTracker.aMaximalDistance = this.aMaximalDistance;
            itemTracker.aIntensityWeight = this.aIntensityWeight;
            return itemTracker;
        }
    }
}

