/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataContainerPrx;
import Imaris.IDataItem;
import Imaris.IDataItemPrx;
import ch.epfl.biop.imaris.EasyXT;
import ch.epfl.biop.imaris.ItemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class ItemQuery {
    private IDataContainerPrx itemParent = null;
    private String itemName = null;
    private Class<? extends IDataItem> itemType = null;
    public static Boolean isRecursiveSearch = false;
    private List<IDataItemPrx> items;
    private static final Logger log = Logger.getLogger(ItemQuery.class.getName());

    private static Class<? extends IDataItem> getType(IDataItemPrx item) throws Error {
        Optional<ItemType> itype = Arrays.stream(ItemType.values()).filter(t -> t.matches(item)).findFirst();
        if (itype.isPresent()) {
            return itype.get().getType();
        }
        log.warning("Type not found for item " + item + " of class " + item.getClass().getSimpleName());
        return null;
    }

    private ItemQuery(IDataContainerPrx parent, String itemName, Class<? extends IDataItem> itemType) {
        this.itemParent = parent;
        this.itemName = itemName;
        this.itemType = itemType;
        this.items = new ArrayList<IDataItemPrx>();
    }

    public List<IDataItemPrx> find() throws Error {
        if (this.itemParent != null) {
            return this.find(this.itemParent);
        }
        return new ArrayList<IDataItemPrx>();
    }

    public IDataItemPrx findFirst() throws Error {
        this.items = this.find();
        if (this.items.size() > 0) {
            return this.find().get(0);
        }
        return null;
    }

    private List<IDataItemPrx> find(IDataContainerPrx parent) throws Error {
        int nChildren = parent.GetNumberOfChildren();
        for (int i = 0; i < nChildren; ++i) {
            IDataItemPrx child = EasyXT.Utils.convertToSubType(parent.GetChild(i));
            if (child == null) continue;
            String aName = child.GetName();
            Class<? extends IDataItem> aCls = ItemQuery.getType(child);
            if (aCls.equals(ItemType.Group.getType()) && isRecursiveSearch.booleanValue()) {
                this.find((IDataContainerPrx)child);
            }
            if (this.itemName != null) {
                if (!aName.equals(this.itemName)) continue;
                if (this.itemType != null) {
                    if (!aCls.equals(this.itemType)) continue;
                    this.items.add(child);
                    continue;
                }
                this.items.add(child);
                continue;
            }
            if (this.itemType != null) {
                if (!aCls.equals(this.itemType)) continue;
                this.items.add(child);
                continue;
            }
            this.items.add(child);
        }
        this.items.replaceAll(item -> {
            try {
                return EasyXT.Utils.convertToSubType(item);
            }
            catch (Error error) {
                error.printStackTrace();
                return item;
            }
        });
        return this.items;
    }

    public IDataItemPrx find(int position) throws Error {
        List<IDataItemPrx> items = this.find();
        if (position < items.size()) {
            return items.get(position);
        }
        log.warning("You requested item number " + position + ". There are only " + items.size() + " items");
        return null;
    }

    public String toString() {
        try {
            return "ItemQuery with the following elements: \n  parent:\t" + EasyXT.Scene.getName((IDataItemPrx)this.itemParent) + "\n  name:\t '" + this.itemName + "\n  type:\t" + this.itemType;
        }
        catch (Error error) {
            error.printStackTrace();
            return "ItemQuery with the following elements: \n  name:\t '" + this.itemName + "\n  type:\t" + this.itemType;
        }
    }

    public static class ItemQueryBuilder {
        private IDataContainerPrx itemParent = null;
        String itemName = null;
        Class<? extends IDataItem> itemType = null;

        public ItemQueryBuilder setName(String itemName) {
            this.itemName = itemName;
            return this;
        }

        public ItemQueryBuilder setParent(IDataContainerPrx itemParent) {
            this.itemParent = itemParent;
            return this;
        }

        public ItemQueryBuilder setType(String itemType) {
            this.itemType = ItemType.valueOf(itemType).getType();
            return this;
        }

        public ItemQuery build() throws Error {
            String[] parts;
            if (this.itemParent == null) {
                this.itemParent = EasyXT.Scene.getScene();
            }
            if (this.itemName != null && (parts = this.itemName.split("/")).length > 1) {
                Boolean isRecursiveTmp = isRecursiveSearch;
                isRecursiveSearch = false;
                IDataContainerPrx scene = EasyXT.Scene.getScene();
                for (int i = 0; i < parts.length - 1; ++i) {
                    String child = parts[i];
                    IDataItemPrx tempItem = new ItemQuery(scene, child, ItemType.Group.getType()).find(0);
                    if (tempItem == null) continue;
                    scene = (IDataContainerPrx)tempItem;
                }
                isRecursiveSearch = isRecursiveTmp;
                return new ItemQuery(scene, parts[parts.length - 1], this.itemType);
            }
            return new ItemQuery(this.itemParent, this.itemName, this.itemType);
        }
    }
}

