/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Imaris.Error;
import Imaris.IDataSetPrx;
import ij.ImagePlus;
import ij.measure.Calibration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImarisCalibration
extends Calibration {
    public static Logger logger = LoggerFactory.getLogger(ImarisCalibration.class);
    public final double xStart;
    public final double yStart;
    public final double zStart;
    public final double xEnd;
    public final double yEnd;
    public final double zEnd;
    public int xSize;
    public int ySize;
    public int zSize;
    public int cSize;
    public int tSize;
    public float[] cMin;
    public float[] cMax;
    public int[] cColorsRGBA;
    public String[] cNames;

    public ImarisCalibration(IDataSetPrx dataset) throws Error {
        this.xStart = dataset.GetExtendMinX();
        this.yStart = dataset.GetExtendMinY();
        this.zStart = dataset.GetExtendMinZ();
        this.xEnd = dataset.GetExtendMaxX();
        this.yEnd = dataset.GetExtendMaxY();
        this.zEnd = dataset.GetExtendMaxZ();
        this.xSize = dataset.GetSizeX();
        this.ySize = dataset.GetSizeY();
        this.zSize = dataset.GetSizeZ();
        this.cSize = dataset.GetSizeC();
        this.tSize = dataset.GetSizeT();
        if (this.xSize == 0) {
            logger.error("Size X of dataset is 0 -> pixelWidth will be infinite");
        }
        if (this.ySize == 0) {
            logger.error("Size Y of dataset is 0 -> pixelHeight will be infinite");
        }
        if (this.zSize == 0) {
            logger.error("Size Z of dataset is 0 -> pixelDepth will be infinite");
        }
        this.pixelWidth = (this.xEnd - this.xStart) / (double)this.xSize;
        this.pixelHeight = (this.yEnd - this.yStart) / (double)this.ySize;
        this.pixelDepth = (this.zEnd - this.zStart) / (double)this.zSize;
        this.xOrigin = this.xStart / this.pixelWidth;
        this.yOrigin = this.yStart / this.pixelHeight;
        this.zOrigin = this.zStart / this.pixelDepth;
        this.setUnit(dataset.GetUnit());
        this.setTimeUnit("s");
        this.frameInterval = dataset.GetTimePointsDelta();
        this.cMin = new float[this.cSize];
        this.cMax = new float[this.cSize];
        this.cColorsRGBA = new int[this.cSize];
        this.cNames = new String[this.cSize];
        for (int c = 0; c < this.cSize; ++c) {
            this.cMin[c] = dataset.GetChannelRangeMin(c);
            this.cMax[c] = dataset.GetChannelRangeMax(c);
            this.cColorsRGBA[c] = dataset.GetChannelColorRGBA(c);
            this.cNames[c] = dataset.GetChannelName(c);
        }
    }

    public ImarisCalibration getDownsampled(double downsample) {
        ImarisCalibration new_calibration = (ImarisCalibration)this.clone();
        new_calibration.xSize = (int)((double)new_calibration.xSize * downsample);
        new_calibration.ySize = (int)((double)new_calibration.ySize * downsample);
        new_calibration.zSize = (int)((double)new_calibration.zSize * downsample);
        new_calibration.pixelWidth /= downsample;
        new_calibration.pixelHeight /= downsample;
        new_calibration.pixelDepth /= downsample;
        return new_calibration;
    }

    public boolean isSameSize(ImagePlus imp) {
        return this.xSize == imp.getWidth() && this.ySize == imp.getHeight() && this.zSize == imp.getNSlices() && this.cSize == imp.getNChannels() && this.tSize == imp.getNFrames();
    }
}

