/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.imaris;

import Ice.ObjectPrx;
import Imaris.Error;
import Imaris.IApplicationPrx;
import Imaris.IApplicationPrxHelper;
import Imaris.IDataContainerPrx;
import Imaris.IDataItemPrx;
import Imaris.IDataSetPrx;
import Imaris.IFactoryPrx;
import Imaris.IFramePrx;
import Imaris.ILabelImagePrx;
import Imaris.ILightSourcePrx;
import Imaris.ISpotsPrx;
import Imaris.ISurfacesPrx;
import Imaris.IVolumePrx;
import Imaris.cSurfaceLayout;
import Imaris.tType;
import ImarisServer.IServerPrx;
import ch.epfl.biop.imaris.ImarisCalibration;
import ch.epfl.biop.imaris.ItemQuery;
import ch.epfl.biop.imaris.ItemTracker;
import ch.epfl.biop.imaris.ItemType;
import ch.epfl.biop.imaris.SpotsDetector;
import ch.epfl.biop.imaris.StatsCreator;
import ch.epfl.biop.imaris.StatsQuery;
import ch.epfl.biop.imaris.SurfacesDetector;
import com.bitplane.xt.BPImarisLib;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Concatenator;
import ij.plugin.Duplicator;
import ij.plugin.HyperStackConverter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import net.imagej.ImageJ;
import org.apache.commons.lang3.ArrayUtils;

public class EasyXT {
    private static IApplicationPrx APP;
    public static Map<tType, Integer> datatype;
    public static Logger log;
    private static BPImarisLib vImarisLib;

    private static void closeImarisConnection() {
        if (vImarisLib != null) {
            log.info("Closing existing ImarisLib connection");
            vImarisLib.Disconnect();
            vImarisLib = null;
        } else {
            log.info("No ImarisLib connection to close");
        }
    }

    public static void main(String ... args) {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
    }

    static {
        log = Logger.getLogger(EasyXT.class.getName());
        log.info("Initializing EasyXT");
        Utils.connectToImaris();
        HashMap<tType, Integer> tmap = new HashMap<tType, Integer>(4);
        tmap.put(tType.eTypeUInt8, 8);
        tmap.put(tType.eTypeUInt16, 16);
        tmap.put(tType.eTypeFloat, 32);
        tmap.put(tType.eTypeUnknown, -1);
        datatype = Collections.unmodifiableMap(tmap);
        log.info("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Closing ICE Connection from Imaris...");
            EasyXT.closeImarisConnection();
            log.info("Done.");
        }));
        if (APP == null) {
            log.warning("Imaris connection failed");
        } else {
            log.info("Initialization Done. Ready to work with EasyXT");
        }
    }

    public static class Utils {
        static IDataItemPrx convertToSubType(IDataItemPrx item) throws Error {
            Optional<ItemType> type = Arrays.stream(ItemType.values()).filter(i -> i.matches(item)).findFirst();
            if (type.isPresent()) {
                return type.get().convert(item);
            }
            return null;
        }

        public static IApplicationPrx getImarisApp() {
            return APP;
        }

        public static void connectToImaris() {
            EasyXT.closeImarisConnection();
            log.info("Starting ImarisLib");
            vImarisLib = new BPImarisLib();
            log.info("Getting Imaris Server");
            IServerPrx vServer = vImarisLib.GetServer();
            if (vServer == null) {
                log.severe("Could not connect to Imaris Server. Try closing Fiji and Restart Imaris");
                return;
            }
            int nObjects = vServer.GetNumberOfObjects();
            log.info("Number of potential Applications found : " + nObjects);
            if (nObjects > 0) {
                for (int i = 0; i < nObjects; ++i) {
                    int id = vServer.GetObjectID(i);
                    ObjectPrx vObject = vServer.GetObject(id);
                    APP = IApplicationPrxHelper.checkedCast((ObjectPrx)vObject);
                    if (APP != null) break;
                }
            }
        }

        public static void resetImarisConnection() {
            Utils.connectToImaris();
        }

        public static Color getColorFromInt(int color) {
            byte[] bytes = ByteBuffer.allocate(4).putInt(color).array();
            int[] colorArray = new int[]{bytes[3] & 0xFF, bytes[2] & 0xFF, bytes[1] & 0xFF};
            return Utils.getColorIntFromIntArray(colorArray);
        }

        public static Color getColorIntFromIntArray(int[] color) {
            if (color.length < 3) {
                log.warning("You did not provide enough colors. need 3. Returning white.");
                return new Color(255, 255, 255);
            }
            return new Color(color[0], color[1], color[2]);
        }

        public static int getRGBAColor(Color color) {
            return color.getRed() + 256 * color.getGreen() + 65536 * color.getBlue();
        }

        public static IDataItemPrx filter(IDataItemPrx aItem, String columnName, double minValue, double maxValue) throws Error {
            IFactoryPrx factory = Utils.getImarisApp().GetFactory();
            ISpotsPrx aItemFiltered = null;
            ResultsTable rt = Stats.export(aItem);
            double[] ids = Arrays.stream(rt.getColumnAsVariables("ID")).map(var -> var.getValue()).mapToDouble(d -> d).toArray();
            double[] values = Arrays.stream(rt.getColumnAsVariables(columnName)).map(var -> var.getValue()).mapToDouble(d -> d).toArray();
            ArrayList<Integer> filteredIdsList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < ids.length; ++i2) {
                if (!(values[i2] >= minValue) || !(values[i2] <= maxValue)) continue;
                filteredIdsList.add((int)ids[i2]);
            }
            if (factory.IsSpots((ObjectPrx)aItem)) {
                ISpotsPrx spots_filtered;
                long[] filteredIds = filteredIdsList.stream().mapToLong(l -> l.intValue()).toArray();
                ISpotsPrx spots_tofilter = (ISpotsPrx)Utils.convertToSubType(aItem);
                aItemFiltered = spots_filtered = Utils.copySpots(spots_tofilter, filteredIds);
            } else if (factory.IsSurfaces((ObjectPrx)aItem)) {
                int[] filteredIds = filteredIdsList.stream().mapToInt(i -> i).toArray();
                ISurfacesPrx surfacesToFilter = (ISurfacesPrx)Utils.convertToSubType(aItem);
                ISurfacesPrx surfacesFiltered = surfacesToFilter.CopySurfaces(filteredIds);
                aItemFiltered = surfacesFiltered;
            }
            return aItemFiltered;
        }

        public static IDataItemPrx filterAbove(IDataItemPrx aItem, String columnName, double minValue) throws Error {
            IDataItemPrx filteredItem = Utils.filter(aItem, columnName, minValue, Double.MAX_VALUE);
            return filteredItem;
        }

        public static IDataItemPrx filterBelow(IDataItemPrx aItem, String columnName, double maxValue) throws Error {
            IDataItemPrx filteredItem = Utils.filter(aItem, columnName, -1.7976931348623157E308, maxValue);
            return filteredItem;
        }

        public static ISpotsPrx copySpots(ISpotsPrx spots, long[] filteredIds) throws Error {
            long[] ids = spots.GetIds();
            float[][] coords = spots.GetPositionsXYZ();
            int[] t = spots.GetIndicesT();
            float[] rad = spots.GetRadii();
            float[][] rads = spots.GetRadiiXYZ();
            float[][] filtered_coords = new float[filteredIds.length][];
            int[] filtered_t = new int[filteredIds.length];
            float[] filtered_rad = new float[filteredIds.length];
            float[][] filtered_rads = new float[filteredIds.length][];
            for (int i = 0; i < filteredIds.length; ++i) {
                int idx = ArrayUtils.indexOf((long[])ids, (long)filteredIds[i]);
                filtered_coords[i] = coords[idx];
                filtered_t[i] = t[idx];
                filtered_rad[i] = rad[idx];
                filtered_rads[i] = rads[idx];
            }
            ISpotsPrx filteredSpots = Utils.getImarisApp().GetFactory().CreateSpots();
            filteredSpots.Set((float[][])filtered_coords, filtered_t, filtered_rad);
            filteredSpots.SetRadiiXYZ((float[][])filtered_rads);
            return filteredSpots;
        }

        private static tType getImarisDatasetType(int bitDepth) {
            switch (bitDepth) {
                case 8: {
                    return tType.eTypeUInt8;
                }
                case 16: {
                    return tType.eTypeUInt16;
                }
                case 32: {
                    return tType.eTypeFloat;
                }
            }
            return tType.eTypeUnknown;
        }

        public static IFactoryPrx getFactory() {
            try {
                return Utils.getImarisApp().GetFactory();
            }
            catch (Error e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Tracks {
        public static ItemTracker.ItemTrackerBuilder create(IDataItemPrx aItem) throws Error {
            return ItemTracker.Item(aItem);
        }
    }

    public static class Stats {
        public static ResultsTable export(IDataItemPrx item) throws Error {
            return new StatsQuery(item).get();
        }

        public static ResultsTable export(IDataItemPrx item, String name) throws Error {
            return new StatsQuery(item).selectStatistic(name).get();
        }

        public static ResultsTable export(IDataItemPrx item, String name, Integer channel) throws Error {
            return new StatsQuery(item).selectStatistic(name).selectChannel(channel).get();
        }

        public static ResultsTable export(IDataItemPrx item, List<String> names) throws Error {
            return new StatsQuery(item).selectStatistics(names).get();
        }

        public static ResultsTable export(IDataItemPrx item, List<String> names, Integer channel) throws Error {
            return new StatsQuery(item).selectStatistics(names).selectChannel(channel).get();
        }

        public static ResultsTable export(IDataItemPrx item, List<String> names, List<Integer> channels) throws Error {
            return new StatsQuery(item).selectStatistics(names).selectChannels(channels).get();
        }

        public static Map<Long, Map<String, Double>> extract(ResultsTable statistics, String columnName) {
            return StatsQuery.extractStatistic(statistics, columnName);
        }

        public static StatsCreator create(IDataItemPrx item, String statName, Map<Long, Map<String, Double>> statValues) {
            return new StatsCreator(item, statName, statValues);
        }
    }

    public static class Spots {
        public static SpotsDetector.SpotsDetectorBuilder create(int channel) throws Error {
            return SpotsDetector.Channel(channel);
        }

        public static ISpotsPrx create(List<Point3D> coordinates, Point3D radiusXYZ, Integer timepoint) throws Error {
            int n = coordinates.size();
            ArrayList<Point3D> radii = new ArrayList<Point3D>(n);
            ArrayList<Integer> timepoints = new ArrayList<Integer>(n);
            for (int i = 0; i < n; ++i) {
                radii.add(radiusXYZ);
                timepoints.add(timepoint);
            }
            return Spots.create(coordinates, radii, timepoints);
        }

        public static ISpotsPrx create(List<Point3D> coordinates, List<Point3D> radiiXYZ, List<Integer> timepoints) throws Error {
            if (coordinates.size() != radiiXYZ.size() || coordinates.size() != timepoints.size()) {
                throw new Error("Inconsistent Sizes", "Coordinates, Radii and timepoints lists must be the same size", "");
            }
            int n = coordinates.size();
            int[] t = new int[n];
            float[] rad = new float[n];
            float[][] coords = new float[n][];
            float[][] rads = new float[n][];
            for (int i = 0; i < coordinates.size(); ++i) {
                Point3D p = coordinates.get(i);
                Point3D r = radiiXYZ.get(i);
                coords[i] = new float[]{p.getPoint3f().getX(), p.getPoint3f().getY(), p.getPoint3f().getZ()};
                t[i] = timepoints.get(i);
                rad[i] = radiiXYZ.get(i).getPoint3f().getX();
                rads[i] = new float[]{r.getPoint3f().getX(), r.getPoint3f().getY(), r.getPoint3f().getZ()};
            }
            ISpotsPrx spots = Utils.getImarisApp().GetFactory().CreateSpots();
            spots.Set((float[][])coords, t, rad);
            spots.SetRadiiXYZ((float[][])rads);
            return spots;
        }

        public static List<ISpotsPrx> findAll() throws Error {
            return Scene.findAllSpots();
        }

        public static ISpotsPrx find(String name, IDataContainerPrx parent) throws Error {
            return Scene.findSpots(name, parent);
        }

        public static ISpotsPrx filter(ISpotsPrx spots, String columnName, double minValue, double maxValue) throws Error {
            return (ISpotsPrx)Utils.filter((IDataItemPrx)spots, columnName, minValue, maxValue);
        }

        public static ISpotsPrx filterAbove(ISpotsPrx spots, String columnName, double minValue) throws Error {
            return Spots.filter(spots, columnName, minValue, Double.MAX_VALUE);
        }

        public static ISpotsPrx filterBelow(ISpotsPrx spots, String columnName, double maxValue) throws Error {
            return Spots.filter(spots, columnName, -1.7976931348623157E308, maxValue);
        }

        public static ISpotsPrx find(String name) throws Error {
            return Scene.findSpots(name);
        }

        public static ImagePlus getMaskImage(ISpotsPrx spots) throws Error {
            return Spots.getImage(spots, false, false);
        }

        private static ImagePlus getImage(ISpotsPrx spots, boolean isValueId, boolean isGauss) throws Error {
            ImagePlus finalImp;
            ImarisCalibration cal = new ImarisCalibration(Dataset.getCurrent());
            long[] spots_ids = spots.GetIds();
            float[][] spotsCenterXYZ = spots.GetPositionsXYZ();
            float[][] spotsRadiiXYZ = spots.GetRadiiXYZ();
            int[] spotsT = spots.GetIndicesT();
            Vector3D vector3D1 = new Vector3D(1.0f, 0.0f, 0.0f);
            Vector3D vector3D2 = new Vector3D(0.0f, 1.0f, 0.0f);
            if (Math.abs(vector3D1.dotProduct(vector3D2)) > 0.001) {
                IJ.log("ERROR : vectors should be perpendicular");
            }
            ObjectCreator3D objCreator = new ObjectCreator3D(cal.xSize, cal.ySize, cal.zSize);
            objCreator.setResolution(cal.pixelWidth, cal.pixelDepth, cal.getUnit());
            int val = 255;
            int previousT = spotsT[0];
            ArrayList<ImagePlus> imps = new ArrayList<ImagePlus>(spotsT[spotsT.length - 1]);
            for (int t = 0; t < spotsT.length; ++t) {
                if (cal.tSize > 1 && (spotsT[t] != previousT || t == spotsT.length - 1)) {
                    imps.add(new ImagePlus("t" + previousT, objCreator.getStack().duplicate()));
                    objCreator.reset();
                }
                if (isValueId) {
                    val = (int)spots_ids[t];
                }
                objCreator.createEllipsoidAxesUnit((double)spotsCenterXYZ[t][0] - cal.xStart, (double)spotsCenterXYZ[t][1] - cal.yStart, (double)spotsCenterXYZ[t][2] - cal.zStart, (double)spotsRadiiXYZ[t][0], (double)spotsRadiiXYZ[t][1], (double)spotsRadiiXYZ[t][2], (float)val, vector3D1, vector3D2, isGauss);
                previousT = spotsT[t];
                if (t % 10 != 0) continue;
                log.info("Creating Labelled Spots " + (t + 1) + "/" + spotsT.length);
            }
            if (cal.tSize > 1) {
                ImagePlus[] impsArray = imps.toArray(new ImagePlus[0]);
                finalImp = Concatenator.run(impsArray);
            } else {
                finalImp = new ImagePlus("t" + previousT, objCreator.getStack().duplicate());
            }
            finalImp.setDisplayRange(0.0, val);
            finalImp.setTitle(Files.getOpenFileName());
            finalImp.setCalibration(cal);
            if (!isValueId) {
                IJ.run(finalImp, "8-bit", "");
            }
            return finalImp;
        }

        public static ImagePlus getLabelsImage(ISpotsPrx spots) throws Error {
            return Spots.getImage(spots, true, false);
        }
    }

    public static class Surfaces {
        public static SurfacesDetector.SurfacesDetectorBuilder create(int channel) throws Error {
            return SurfacesDetector.Channel(channel);
        }

        public static ISurfacesPrx create(ImagePlus imp) throws Error {
            Object tInd = imp.getProperty("Time Index");
            if (tInd != null) {
                return Surfaces.create(imp, (Integer)tInd);
            }
            log.warning("EasyXT cannot find a timepoint associated with this surface mask. Defaulting to Timepoint 0");
            log.warning("Use Surfaces.create(ImagePlus imp, int timepoint) to specify the desired timepoint to insert this surface");
            return Surfaces.create(imp, 0);
        }

        public static ISurfacesPrx create(ImagePlus imp, int timepointOffset) throws Error {
            if (!imp.getProcessor().isBinary()) {
                log.severe("Provided image is not binary");
                throw new Error("Image Type Error", "Image " + imp.getTitle() + " is not binary", "");
            }
            ImagePlus tempImage = imp.duplicate();
            int nProcessor = tempImage.getStack().getSize();
            IntStream.range(0, nProcessor).parallel().forEach(index -> tempImage.getStack().getProcessor(index + 1).multiply(0.00392156862745098));
            ISurfacesPrx surface = Utils.getImarisApp().GetFactory().CreateSurfaces();
            for (int t = 0; t < tempImage.getNFrames(); ++t) {
                ImagePlus tImp = new Duplicator().run(tempImage, 1, 1, 1, imp.getNSlices(), t + 1, t + 1);
                IDataSetPrx data = Dataset.create(tImp);
                surface.AddSurface(data, t + timepointOffset);
            }
            Scene.setName((IDataItemPrx)surface, tempImage.getTitle());
            return surface;
        }

        public static ISurfacesPrx createFromLabels(ImagePlus impLabel) throws Error {
            int width = impLabel.getWidth();
            int height = impLabel.getHeight();
            int slices = impLabel.getNSlices();
            int timepoints = impLabel.getNFrames();
            ILabelImagePrx labelImage = Utils.getImarisApp().GetFactory().CreateLabelImage();
            labelImage.Create(width, height, slices, timepoints);
            Calibration cal = impLabel.getCalibration();
            labelImage.SetExtendMinX((float)(cal.xOrigin * cal.pixelWidth));
            labelImage.SetExtendMinY((float)(cal.yOrigin * cal.pixelHeight));
            labelImage.SetExtendMinZ((float)(cal.zOrigin * cal.pixelDepth));
            labelImage.SetExtendMaxX((float)((cal.xOrigin + (double)width) * cal.pixelWidth));
            labelImage.SetExtendMaxY((float)((cal.yOrigin + (double)height) * cal.pixelHeight));
            labelImage.SetExtendMaxZ((float)((cal.zOrigin + (double)slices) * cal.pixelDepth));
            IDataSetPrx currentDataset = Dataset.getCurrent();
            for (int t = 0; t < timepoints; ++t) {
                if (currentDataset.GetSizeT() <= t) continue;
                labelImage.SetTimePoint(t, currentDataset.GetTimePoint(t));
            }
            for (int z = 0; z < slices; ++z) {
                for (int t = 0; t < timepoints; ++t) {
                    int i;
                    int idx = impLabel.getStackIndex(1, z + 1, t + 1);
                    ImageProcessor ip = impLabel.getStack().getProcessor(idx);
                    int[] pixelsInt = new int[ip.getPixelCount()];
                    switch (ip.getBitDepth()) {
                        case 8: {
                            byte[] pixels8 = (byte[])ip.getPixels();
                            for (i = 0; i < pixels8.length; ++i) {
                                pixelsInt[i] = pixels8[i];
                            }
                            break;
                        }
                        case 16: {
                            short[] pixels16 = (short[])ip.getPixels();
                            for (int i2 = 0; i2 < pixels16.length; ++i2) {
                                pixelsInt[i2] = pixels16[i2];
                            }
                            break;
                        }
                        case 32: {
                            float[] pixels32 = (float[])ip.getPixels();
                            for (int i3 = 0; i3 < pixels32.length; ++i3) {
                                pixelsInt[i3] = Math.round(pixels32[i3]);
                            }
                            break;
                        }
                        default: {
                            log.severe("Unsupported pixel type for label image");
                            throw new Error("Unsupported Pixel Type", "Unsupported pixel type for label image", "");
                        }
                    }
                    short[] pixels = (short[])ip.getPixels();
                    for (i = 0; i < pixels.length; ++i) {
                        pixelsInt[i] = pixels[i];
                    }
                    labelImage.SetDataSubVolumeAs1DArrayInts(pixelsInt, 0, 0, z, t, width, height, 1);
                }
            }
            log.info("InterNal label image created, detecting surfaces");
            ISurfacesPrx surface = Utils.getImarisApp().GetImageProcessing().DetectSurfacesFromLabelImage(labelImage);
            return surface;
        }

        public static List<ISurfacesPrx> findAll() throws Error {
            return Scene.findAllSurfaces();
        }

        public static ISurfacesPrx find(String name, IDataContainerPrx parent) throws Error {
            return Scene.findSurfaces(name, parent);
        }

        public static ISurfacesPrx find(String name) throws Error {
            return Scene.findSurfaces(name);
        }

        public static ImagePlus getMaskImage(ISurfacesPrx surface) throws Error {
            ImagePlus masks = Surfaces.getLabelsImage(surface);
            masks.getProcessor().setThreshold(1.0, Double.MAX_VALUE, 2);
            Prefs.blackBackground = true;
            IJ.run(masks, "Convert to Mask", "method=Default background=Dark black");
            masks.setTitle(Scene.getName((IDataItemPrx)surface) + "-Masks");
            masks.setLut(LUT.createLutFromColor(Utils.getColorFromInt(surface.GetColorRGBA())));
            masks.setDisplayRange(0.0, 255.0);
            return masks;
        }

        public static ImagePlus getLabelsImage(ISurfacesPrx surface) throws Error {
            int nSurfaces = surface.GetNumberOfSurfaces();
            int maxSurfaceID = (int)Arrays.stream(surface.GetIds()).max().getAsLong();
            ImarisCalibration cal = new ImarisCalibration(Dataset.getCurrent());
            cal.cSize = 1;
            ImagePlus labelImage = IJ.createHyperStack(Scene.getName((IDataItemPrx)surface) + "-Labels", cal.xSize, cal.ySize, 1, cal.zSize, cal.tSize, 32);
            labelImage.setCalibration(cal);
            for (int i = 0; i < nSurfaces; ++i) {
                Surfaces.addSurfaceIndexToLabelImage(surface, i, labelImage);
            }
            boolean doScaling = ImageConverter.getDoScaling();
            ImageConverter.setDoScaling(false);
            if (maxSurfaceID < 256) {
                new ImageConverter(labelImage).convertToGray8();
            }
            if (maxSurfaceID < 65536) {
                new ImageConverter(labelImage).convertToGray16();
            }
            ImageConverter.setDoScaling(doScaling);
            return labelImage;
        }

        public static ImagePlus getSurfaceIdAsMask(ISurfacesPrx surface, long id) throws Error {
            List ids = Arrays.stream(surface.GetIds()).boxed().collect(Collectors.toList());
            int idx = ids.indexOf(new Long(id));
            cSurfaceLayout layout = surface.GetSurfaceDataLayout(idx);
            layout = Surfaces.padLayout(layout, 5, 5, 5);
            IDataSetPrx dataset = surface.GetSingleMask(idx, layout.mExtendMinX, layout.mExtendMinY, layout.mExtendMinZ, layout.mExtendMaxX, layout.mExtendMaxY, layout.mExtendMaxZ, layout.mSizeX, layout.mSizeY, layout.mSizeZ);
            ImagePlus surfaceImp = Dataset.getImagePlus(dataset);
            int nProcessor = surfaceImp.getStack().getSize();
            IntStream.range(0, nProcessor).parallel().forEach(index -> surfaceImp.getStack().getProcessor(index + 1).multiply(255.0));
            surfaceImp.setProperty("Time Index", surface.GetTimeIndex(idx));
            return surfaceImp;
        }

        private static cSurfaceLayout padLayout(cSurfaceLayout layout, int extraX, int extraY, int extraZ) {
            double vX = (layout.mExtendMaxX - layout.mExtendMinX) / (float)layout.mSizeX;
            double vY = (layout.mExtendMaxY - layout.mExtendMinY) / (float)layout.mSizeY;
            double vZ = (layout.mExtendMaxZ - layout.mExtendMinZ) / (float)layout.mSizeZ;
            layout.mExtendMinX = (float)((double)layout.mExtendMinX - vX * (double)extraX);
            layout.mExtendMinY = (float)((double)layout.mExtendMinY - vY * (double)extraY);
            layout.mExtendMinZ = (float)((double)layout.mExtendMinZ - vZ * (double)extraZ);
            layout.mExtendMaxX = (float)((double)layout.mExtendMaxX + vX * (double)extraX);
            layout.mExtendMaxY = (float)((double)layout.mExtendMaxY + vY * (double)extraY);
            layout.mExtendMaxZ = (float)((double)layout.mExtendMaxZ + vZ * (double)extraZ);
            layout.mSizeX += 2 * extraX;
            layout.mSizeY += 2 * extraY;
            layout.mSizeZ += 2 * extraZ;
            return layout;
        }

        private static void addSurfaceIndexToLabelImage(ISurfacesPrx surface, int index, ImagePlus image) throws Error {
            Calibration fCal = image.getCalibration();
            cSurfaceLayout layout = Surfaces.adjustBounds(surface.GetSurfaceDataLayout(index), fCal);
            int t = surface.GetTimeIndex(index);
            long id = surface.GetIds()[index];
            IDataSetPrx currentSurfaceDataset = surface.GetSingleMask(index, layout.mExtendMinX, layout.mExtendMinY, layout.mExtendMinZ, layout.mExtendMaxX, layout.mExtendMaxY, layout.mExtendMaxZ, layout.mSizeX, layout.mSizeY, layout.mSizeZ);
            ImagePlus temp = Dataset.getImagePlus(currentSurfaceDataset);
            Calibration tCal = temp.getCalibration();
            int startX = (int)Math.round(tCal.xOrigin - fCal.xOrigin);
            int startY = (int)Math.round(tCal.yOrigin - fCal.yOrigin);
            int startZ = (int)Math.round(tCal.zOrigin - fCal.zOrigin);
            if (startZ < 0) {
                startZ = 0;
            }
            if (startZ + temp.getNSlices() > image.getNSlices()) {
                // empty if block
            }
            for (int z = 1; z <= temp.getNSlices(); ++z) {
                int position = image.getStackIndex(1, z + startZ, t + 1);
                ImageProcessor fip = image.getStack().getProcessor(position);
                ImageProcessor pip = temp.getStack().getProcessor(z).convertToFloat();
                pip.multiply(id + 1L);
                fip.copyBits(pip, startX, startY, 14);
                image.getStack().setProcessor(fip, position);
            }
        }

        private static cSurfaceLayout adjustBounds(cSurfaceLayout originalLayout, Calibration referenceCalibration) {
            cSurfaceLayout newLayout = originalLayout.clone();
            double xmi = Math.floor((double)originalLayout.mExtendMinX / referenceCalibration.pixelWidth - referenceCalibration.xOrigin);
            double xma = Math.ceil((double)originalLayout.mExtendMaxX / referenceCalibration.pixelWidth - referenceCalibration.xOrigin);
            if (xmi < 0.0) {
                xmi = 0.0;
            }
            if (xma < 0.0) {
                xma = 0.0;
            }
            newLayout.mExtendMinX = (float)((referenceCalibration.xOrigin + xmi) * referenceCalibration.pixelWidth);
            newLayout.mExtendMaxX = (float)((referenceCalibration.xOrigin + xma) * referenceCalibration.pixelWidth);
            double ymi = Math.floor((double)originalLayout.mExtendMinY / referenceCalibration.pixelHeight - referenceCalibration.yOrigin);
            double yma = Math.ceil((double)originalLayout.mExtendMaxY / referenceCalibration.pixelHeight - referenceCalibration.yOrigin);
            if (ymi < 0.0) {
                ymi = 0.0;
            }
            if (yma < 0.0) {
                yma = 0.0;
            }
            newLayout.mExtendMinY = (float)((referenceCalibration.yOrigin + ymi) * referenceCalibration.pixelHeight);
            newLayout.mExtendMaxY = (float)((referenceCalibration.yOrigin + yma) * referenceCalibration.pixelHeight);
            double zmi = Math.floor((double)originalLayout.mExtendMinZ / referenceCalibration.pixelDepth - referenceCalibration.zOrigin);
            double zma = Math.ceil((double)originalLayout.mExtendMaxZ / referenceCalibration.pixelDepth - referenceCalibration.zOrigin);
            if (zmi < 0.0) {
                zmi = 0.0;
            }
            if (zma < 0.0) {
                zma = 0.0;
            }
            newLayout.mExtendMinZ = (float)((referenceCalibration.zOrigin + zmi) * referenceCalibration.pixelDepth);
            newLayout.mExtendMaxZ = (float)((referenceCalibration.zOrigin + zma) * referenceCalibration.pixelDepth);
            newLayout.mSizeX = (int)Math.round((double)(newLayout.mExtendMaxX - newLayout.mExtendMinX) / referenceCalibration.pixelWidth);
            newLayout.mSizeY = (int)Math.round((double)(newLayout.mExtendMaxY - newLayout.mExtendMinY) / referenceCalibration.pixelHeight);
            newLayout.mSizeZ = (int)Math.round((double)(newLayout.mExtendMaxZ - newLayout.mExtendMinZ) / referenceCalibration.pixelDepth);
            return newLayout;
        }

        public static IDataSetPrx getMaskDataset(ISurfacesPrx surface) throws Error {
            IDataSetPrx finalDataset = Dataset.getCurrent().Clone();
            ImarisCalibration cal = new ImarisCalibration(finalDataset);
            finalDataset.SetSizeC(1);
            Dataset.setBitDepth(8, finalDataset);
            for (int t = 0; t < cal.tSize; ++t) {
                IDataSetPrx oneTimepoint = Surfaces.getMaskDataset(surface, 1.0, t);
                finalDataset.SetDataVolumeAs1DArrayBytes(oneTimepoint.GetDataVolumeAs1DArrayBytes(0, 0), 0, t);
            }
            return finalDataset;
        }

        public static IDataSetPrx getMaskDataset(ISurfacesPrx surface, double downsample, int timepoint) throws Error {
            ImarisCalibration cal = new ImarisCalibration(Utils.getImarisApp().GetDataSet()).getDownsampled(downsample);
            IDataSetPrx data = surface.GetMask((float)cal.xStart, (float)cal.yStart, (float)cal.zStart, (float)cal.xEnd, (float)cal.yEnd, (float)cal.zEnd, cal.xSize, cal.ySize, cal.zSize, timepoint);
            return data;
        }

        public static ISurfacesPrx filter(ISurfacesPrx surface, String columnName, double minValue, double maxValue) throws Error {
            return (ISurfacesPrx)Utils.filter((IDataItemPrx)surface, columnName, minValue, maxValue);
        }

        public static ISurfacesPrx filterAbove(ISurfacesPrx surface, String columnName, double minValue) throws Error {
            ISurfacesPrx filteredSurface = Surfaces.filter(surface, columnName, minValue, Double.MAX_VALUE);
            return filteredSurface;
        }

        public static ISurfacesPrx filterBelow(ISurfacesPrx surface, String columnName, double maxValue) throws Error {
            ISurfacesPrx filteredSurface = Surfaces.filter(surface, columnName, -1.7976931348623157E308, maxValue);
            return filteredSurface;
        }
    }

    public static class Dataset {
        public static ImarisCalibration getCalibration() throws Error {
            return Dataset.getCalibration(Dataset.getCurrent());
        }

        public static ImarisCalibration getCalibration(IDataSetPrx dataset) throws Error {
            return new ImarisCalibration(dataset);
        }

        public static IDataSetPrx getCurrent() throws Error {
            return Utils.getImarisApp().GetDataSet();
        }

        public static void setCurrent(IDataSetPrx dataset) throws Error {
            Utils.getImarisApp().SetDataSet(dataset);
        }

        public static IDataSetPrx create(ImarisCalibration calibration, int bitDepth) throws Error {
            IDataSetPrx dataset = Utils.getImarisApp().GetFactory().CreateDataSet();
            return Dataset.matchDimensionsFromCalibration(dataset, calibration, bitDepth);
        }

        public static IDataSetPrx matchDimensionsFromCalibration(IDataSetPrx dataset, ImarisCalibration calibration, int bitDepth) throws Error {
            dataset.Create(Utils.getImarisDatasetType(bitDepth), calibration.xSize, calibration.ySize, calibration.zSize, calibration.cSize, calibration.tSize);
            dataset.SetExtendMinX((float)calibration.xStart);
            dataset.SetExtendMinY((float)calibration.yStart);
            dataset.SetExtendMinZ((float)calibration.zStart);
            dataset.SetExtendMaxX((float)calibration.xEnd);
            dataset.SetExtendMaxY((float)calibration.yEnd);
            dataset.SetExtendMaxZ((float)calibration.zEnd);
            for (int c = 0; c < calibration.cSize; ++c) {
                dataset.SetChannelColorRGBA(c, calibration.cColorsRGBA[c]);
                dataset.SetChannelName(c, calibration.cNames[c]);
                dataset.SetChannelRange(c, calibration.cMin[c], calibration.cMax[c]);
            }
            return dataset;
        }

        public static IDataSetPrx create(ImagePlus imp) throws Error {
            IDataSetPrx dataset = Utils.getImarisApp().GetFactory().CreateDataSet();
            Dataset.matchDimensionsFromImagePlus(dataset, imp);
            Dataset.setFromImagePlus(dataset, imp);
            return dataset;
        }

        public static IDataSetPrx matchDimensionsFromImagePlus(IDataSetPrx dataset, ImagePlus imp) throws Error {
            Calibration cal = imp.getCalibration();
            dataset.Create(Utils.getImarisDatasetType(imp.getBitDepth()), imp.getWidth(), imp.getHeight(), imp.getNSlices(), imp.getNChannels(), imp.getNFrames());
            dataset.SetExtendMinX((float)(cal.xOrigin * cal.pixelWidth));
            dataset.SetExtendMinY((float)(cal.yOrigin * cal.pixelHeight));
            dataset.SetExtendMinZ((float)(cal.zOrigin * cal.pixelDepth));
            dataset.SetExtendMaxX((float)((cal.xOrigin + (double)imp.getWidth()) * cal.pixelWidth));
            dataset.SetExtendMaxY((float)((cal.yOrigin + (double)imp.getHeight()) * cal.pixelHeight));
            dataset.SetExtendMaxZ((float)((cal.zOrigin + (double)imp.getNSlices()) * cal.pixelDepth));
            for (int c = 0; c < imp.getNChannels(); ++c) {
                imp.setC(c + 1);
                if (imp instanceof CompositeImage) {
                    CompositeImage cimp = (CompositeImage)imp;
                    cimp.setC(c + 1);
                    Color color = cimp.getChannelColor();
                    dataset.SetChannelColorRGBA(c, Utils.getRGBAColor(color));
                }
                dataset.SetChannelRange(c, (float)imp.getDisplayRangeMin(), (float)imp.getDisplayRangeMax());
            }
            return dataset;
        }

        public static void setFromImagePlus(IDataSetPrx dataset, ImagePlus imp) throws Error {
            int c;
            int iBitDepth;
            ImarisCalibration cal = new ImarisCalibration(dataset);
            if (!cal.isSameSize(imp)) {
                throw new Error("Inconsistent Sizes", "ImagePlus does not have the same dimensions as dataset", "");
            }
            int w = cal.xSize;
            int h = cal.ySize;
            int nc = cal.cSize;
            int nz = cal.zSize;
            int nt = cal.tSize;
            int dBitDepth = Dataset.getBitDepth(dataset);
            if (dBitDepth != (iBitDepth = imp.getBitDepth())) {
                log.warning("Provided dataset bitdepth (" + dBitDepth + "-bit)differs from image bitdepth (" + iBitDepth + "-bit)");
                log.warning("   dataset will be changed to (" + iBitDepth + " bits");
                Dataset.setBitDepth(iBitDepth, dataset);
                dBitDepth = iBitDepth;
            }
            for (c = 0; c < nc; ++c) {
                for (int z = 0; z < nz; ++z) {
                    block7: for (int t = 0; t < nt; ++t) {
                        int idx = imp.getStackIndex(c + 1, z + 1, t + 1);
                        ImageProcessor ip = imp.getStack().getProcessor(idx);
                        switch (dBitDepth) {
                            case 8: {
                                dataset.SetDataSubVolumeAs1DArrayBytes((byte[])ip.getPixels(), 0, 0, z, c, t, w, h, 1);
                                continue block7;
                            }
                            case 16: {
                                dataset.SetDataSubVolumeAs1DArrayShorts((short[])ip.getPixels(), 0, 0, z, c, t, w, h, 1);
                                continue block7;
                            }
                            case 32: {
                                dataset.SetDataSubVolumeAs1DArrayFloats((float[])ip.getPixels(), 0, 0, z, c, t, w, h, 1);
                            }
                        }
                    }
                }
            }
            for (c = 0; c < imp.getNChannels(); ++c) {
                imp.setC(c + 1);
                if (imp instanceof CompositeImage) {
                    CompositeImage cimp = (CompositeImage)imp;
                    cimp.setC(c + 1);
                    Color color = cimp.getChannelColor();
                    dataset.SetChannelColorRGBA(c, Utils.getRGBAColor(color));
                }
                dataset.SetChannelRange(c, (float)imp.getDisplayRangeMin(), (float)imp.getDisplayRangeMax());
            }
        }

        public static int getBitDepth(IDataSetPrx dataset) throws Error {
            tType type = dataset.GetType();
            return datatype.get(type);
        }

        public static void setBitDepth(int bitDepth, IDataSetPrx dataset) throws Error {
            tType aType = dataset.GetType();
            String outputString = "Dataset was converted from " + aType;
            switch (bitDepth) {
                case 32: {
                    aType = tType.eTypeFloat;
                    break;
                }
                case 16: {
                    aType = tType.eTypeUInt16;
                    break;
                }
                case 8: {
                    aType = tType.eTypeUInt8;
                }
            }
            dataset.SetType(aType);
            log.info(outputString + " to " + aType + "bit");
        }

        public static void setBitDepth(int bitDepth) throws Error {
            IDataSetPrx dataset = Dataset.getCurrent();
            Dataset.setBitDepth(bitDepth, dataset);
        }

        public static ImagePlus getImagePlus(IDataSetPrx dataset) throws Error {
            ImarisCalibration cal = new ImarisCalibration(dataset);
            int w = cal.xSize;
            int h = cal.ySize;
            int nc = cal.cSize;
            int nz = cal.zSize;
            int nt = cal.tSize;
            int bitDepth = Dataset.getBitDepth(dataset);
            ImageStack stack = ImageStack.create(w, h, nc * nz * nt, bitDepth);
            ImagePlus imp = new ImagePlus(Utils.getImarisApp().GetCurrentFileName(), stack);
            imp.setDimensions(nc, nz, nt);
            for (int c = 0; c < nc; ++c) {
                for (int z = 0; z < nz; ++z) {
                    block7: for (int t = 0; t < nt; ++t) {
                        int idx = imp.getStackIndex(c + 1, z + 1, t + 1);
                        switch (bitDepth) {
                            case 8: {
                                byte[] dataB = dataset.GetDataSubVolumeAs1DArrayBytes(0, 0, z, c, t, w, h, 1);
                                ImageProcessor ip = new ByteProcessor(w, h, dataB, null);
                                stack.setProcessor(ip, idx);
                                continue block7;
                            }
                            case 16: {
                                short[] dataS = dataset.GetDataSubVolumeAs1DArrayShorts(0, 0, z, c, t, w, h, 1);
                                ImageProcessor ip = new ShortProcessor(w, h, dataS, null);
                                stack.setProcessor(ip, idx);
                                continue block7;
                            }
                            case 32: {
                                float[] dataF = dataset.GetDataSubVolumeAs1DArrayFloats(0, 0, z, c, t, w, h, 1);
                                ImageProcessor ip = new FloatProcessor(w, h, dataF, null);
                                stack.setProcessor(ip, idx);
                            }
                        }
                    }
                }
            }
            imp.setStack(stack);
            imp.setCalibration(cal);
            if (nc * nz * nt > 1) {
                imp = HyperStackConverter.toHyperStack(imp, nc, nz, nt);
            }
            if (imp instanceof CompositeImage) {
                LUT[] luts = new LUT[nc];
                for (int c = 0; c < nc; ++c) {
                    Color color = Utils.getColorFromInt(cal.cColorsRGBA[c]);
                    luts[c] = LUT.createLutFromColor(color);
                }
                ((CompositeImage)imp).setLuts(luts);
            } else if (nc == 1) {
                imp.setLut(LUT.createLutFromColor(Utils.getColorFromInt(cal.cColorsRGBA[0])));
            }
            for (int c = 0; c < nc; ++c) {
                imp.setC(c + 1);
                imp.setDisplayRange(cal.cMin[c], cal.cMax[c]);
            }
            return imp;
        }

        public static void addDataset(IDataSetPrx dataset, int position) throws Error {
            Utils.getImarisApp().SetImage(position, dataset);
            IFramePrx frame = Utils.getImarisApp().GetFactory().CreateFrame();
            Scene.addItem((IDataItemPrx)frame);
        }

        public static IDataSetPrx getDataset(int position) throws Error {
            return Utils.getImarisApp().GetImage(position);
        }

        public static void addChannels(ImagePlus imp) throws Error {
            IDataSetPrx dataset = Dataset.getCurrent();
            IDataSetPrx newDataset = dataset.Clone();
            Dataset.addChannels(imp, newDataset, 0, 0, 0, 0);
            Dataset.setCurrent(newDataset);
            dataset.Dispose();
        }

        public static void addChannels(ImagePlus imp, IDataSetPrx dataset, int xStart, int yStart, int zStart, int tStart) throws Error {
            ImarisCalibration dCal = new ImarisCalibration(dataset);
            int dc = dataset.GetSizeC();
            Calibration iCal = imp.getCalibration();
            int iw = imp.getWidth();
            int ih = imp.getHeight();
            int iz = imp.getNSlices();
            int it = imp.getNFrames();
            int ic = imp.getNChannels();
            int dBitDepth = Dataset.getBitDepth(dataset);
            int iBitDepth = imp.getBitDepth();
            if (dCal.xSize < xStart + iw || dCal.ySize < yStart + ih || dCal.zSize < zStart + iz || dCal.tSize < tStart + it) {
                String errorDetail = "Dataset\t(X,\tY,\tZ,\tT):\t (" + dCal.xSize + ",\t" + dCal.ySize + ",\t" + dCal.zSize + ",\t" + dCal.tSize + ")";
                errorDetail = errorDetail + "\nImage\t(X,\tY,\tZ,\tT):\t (" + iw + ",\t" + ih + ",\t" + iz + ",\t" + it + ")";
                errorDetail = errorDetail + "\nIncl. offset\t(X,\tY,\tZ,\tT):\t (" + (iw + xStart) + ",\t" + (ih + yStart) + ",\t" + (iz + zStart) + ",\t" + (it + tStart) + ")";
                throw new Error("Size Mismatch", "Dataset and ImagePlus do not have the same size in XYZT", errorDetail);
            }
            if (dBitDepth != iBitDepth) {
                String errorDetail = "   Dataset:" + dBitDepth + "-bit";
                errorDetail = errorDetail + "\n    Image:" + iBitDepth + "-bit";
                log.warning("Bit Depth Mismatch : Imaris Dataset and Fiji ImagePlus do not have same bit depth \n " + errorDetail);
                if (iBitDepth <= dBitDepth) {
                    if (dBitDepth == 16) {
                        new ImageConverter(imp).convertToGray16();
                    }
                    if (dBitDepth == 32) {
                        new ImageConverter(imp).convertToGray32();
                    }
                    log.warning("Image converted: " + imp.getBitDepth() + "-bit to match dataset bit depth (" + dBitDepth + "-bit)");
                } else {
                    log.severe("ImagePlus has higher bit depth than dataset. Cannot convert");
                    throw new Error("Bit depth Mismatch", "Image is " + iBitDepth + "-bit, dataset is " + dBitDepth + "-bit", "");
                }
            }
            if (dCal.pixelDepth != iCal.pixelDepth && dCal.pixelHeight != iCal.pixelHeight && dCal.pixelWidth != iCal.pixelWidth) {
                log.warning("Warning: Voxel Sizes between Dataset and ImagePlus do not match:\n   Dataset Voxel Size\t(X,\tY,\tZ):\t" + dCal.pixelWidth + ",\t" + dCal.pixelHeight + ",\t" + dCal.pixelDepth + ")\n   Image Voxel Size\t(X,\tY,\tZ):\t" + iCal.pixelWidth + ",\t" + iCal.pixelHeight + ",\t" + iCal.pixelDepth + ")");
            }
            dataset.SetSizeC(dc + ic);
            for (int c = 0; c < ic; ++c) {
                int idx = imp.getStackIndex(c + 1, 1, 1);
                int color = imp.getStack().getProcessor(idx).getColorModel().getRGB(255);
                dataset.SetChannelColorRGBA(c, color);
                for (int z = 0; z < iz; ++z) {
                    block7: for (int t = 0; t < it; ++t) {
                        idx = imp.getStackIndex(c + 1, z + 1, t + 1);
                        ImageProcessor ip = imp.getStack().getProcessor(idx);
                        switch (dBitDepth) {
                            case 8: {
                                dataset.SetDataSubVolumeAs1DArrayBytes((byte[])ip.getPixels(), xStart, yStart, zStart + z, c + dc, tStart + t, iw, ih, 1);
                                continue block7;
                            }
                            case 16: {
                                dataset.SetDataSubVolumeAs1DArrayShorts((short[])ip.getPixels(), xStart, yStart, zStart + z, c + dc, tStart + t, iw, ih, 1);
                                continue block7;
                            }
                            case 32: {
                                dataset.SetDataSubVolumeAs1DArrayFloats((float[])ip.getPixels(), xStart, yStart, zStart + z, c + dc, tStart + t, iw, ih, 1);
                            }
                        }
                    }
                }
            }
        }

        public static void addChannels(ImagePlus imp, IDataSetPrx dataset) throws Error {
            Dataset.addChannels(imp, dataset, 0, 0, 0, 0);
        }
    }

    public static class Scene {
        public static void createNewScene() throws Error {
            IDataContainerPrx vSurpassScene = Utils.getImarisApp().GetFactory().CreateDataContainer();
            vSurpassScene.SetName("Scene");
            ILightSourcePrx vLightSource = Utils.getImarisApp().GetFactory().CreateLightSource();
            vLightSource.SetName("Light source 1");
            IFramePrx vFrame = Utils.getImarisApp().GetFactory().CreateFrame();
            vFrame.SetName("Frame 1");
            IVolumePrx vVolume = Utils.getImarisApp().GetFactory().CreateVolume();
            vVolume.SetName("Volume");
            Utils.getImarisApp().SetSurpassScene(vSurpassScene);
            Scene.addItem((IDataItemPrx)vLightSource);
            Scene.addItem((IDataItemPrx)vFrame);
            Scene.addItem((IDataItemPrx)vVolume);
        }

        public static String getFullName(IDataItemPrx item) throws Error {
            String finalName = item.GetName();
            IDataContainerPrx scene = Scene.getScene();
            IDataContainerPrx parent = item.GetParent();
            while (!scene.equals(parent)) {
                finalName = parent.GetName() + "/" + finalName;
            }
            return finalName;
        }

        public static IDataContainerPrx getScene() throws Error {
            return Utils.getImarisApp().GetSurpassScene();
        }

        public static String getName(IDataItemPrx item) throws Error {
            return item.GetName();
        }

        public static void setName(IDataItemPrx item, String name) throws Error {
            item.SetName(name);
        }

        public static IDataItemPrx findItem(String name) throws Error {
            return Scene.findItem(name, Scene.getScene());
        }

        public static IDataItemPrx findItem(String name, IDataContainerPrx parent) throws Error {
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setName(name).setParent(parent).build();
            return query.find(0);
        }

        public static ISpotsPrx findSpots(String name) throws Error {
            return Scene.findSpots(name, Scene.getScene());
        }

        public static ISpotsPrx findSpots(String name, IDataContainerPrx parent) throws Error {
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setName(name).setType("Spots").setParent(parent).build();
            return (ISpotsPrx)query.findFirst();
        }

        public static ISurfacesPrx findSurfaces(String name) throws Error {
            return Scene.findSurfaces(name, Scene.getScene());
        }

        public static ISurfacesPrx findSurfaces(String name, IDataContainerPrx parent) throws Error {
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setName(name).setParent(parent).setType("Surfaces").build();
            return (ISurfacesPrx)query.findFirst();
        }

        public static List<IDataItemPrx> findAll(String type, IDataContainerPrx parent) throws Error {
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setType(type).setParent(parent).build();
            return query.find();
        }

        public static List<IDataItemPrx> findAll(String type) throws Error {
            return Scene.findAll(type, null);
        }

        public static List<ISpotsPrx> findAllSpots() throws Error {
            List<IDataItemPrx> items = Scene.findAll("Spots");
            List<ISpotsPrx> spots = items.stream().map(item -> (ISpotsPrx)item).collect(Collectors.toList());
            return spots;
        }

        public static List<ISurfacesPrx> findAllSurfaces() throws Error {
            List<IDataItemPrx> items = Scene.findAll("Surfaces");
            List<ISurfacesPrx> surfs = items.stream().map(item -> (ISurfacesPrx)item).collect(Collectors.toList());
            return surfs;
        }

        public static List<IDataContainerPrx> findAllGroups() throws Error {
            ItemQuery query = new ItemQuery.ItemQueryBuilder().setType("Group").build();
            List<IDataItemPrx> items = query.find();
            List<IDataContainerPrx> groups = items.stream().map(item -> (IDataContainerPrx)item).collect(Collectors.toList());
            return groups;
        }

        public static void addItem(IDataItemPrx item) throws Error {
            Scene.addItem(item, Scene.getScene());
        }

        public static void addItem(IDataItemPrx item, IDataContainerPrx parent) throws Error {
            parent.AddChild(item, -1);
        }

        public static void removeItem(IDataItemPrx item) throws Error {
            IFactoryPrx factory = Utils.getImarisApp().GetFactory();
            if (factory.IsDataContainer((ObjectPrx)item)) {
                IDataContainerPrx group = factory.ToDataContainer((ObjectPrx)item);
                for (int grp = 0; grp < group.GetNumberOfChildren(); ++grp) {
                    Scene.removeItem(group.GetChild(grp));
                }
            }
            item.GetParent().RemoveChild(item);
        }

        public static void removeItems(List<? extends IDataItemPrx> items) throws Error {
            for (IDataItemPrx iDataItemPrx : items) {
                Scene.removeItem(iDataItemPrx);
            }
        }

        public static void reset() throws Error {
            List<ISpotsPrx> spots = Scene.findAllSpots();
            List<ISurfacesPrx> surfaces = Scene.findAllSurfaces();
            List<IDataContainerPrx> groups = Scene.findAllGroups();
            Scene.removeItems(spots);
            Scene.removeItems(surfaces);
            Scene.removeItems(groups);
            if (Scene.getScene() != null) {
                Scene.selectItem((IDataItemPrx)Scene.getScene());
            }
        }

        public static IDataContainerPrx createGroup(String groupName) throws Error {
            IDataContainerPrx group = Utils.getImarisApp().GetFactory().CreateDataContainer();
            group.SetName(groupName);
            return group;
        }

        public static IDataContainerPrx findGroup(String groupName) throws Error {
            return Scene.findGroup(groupName, Scene.getScene());
        }

        public static IDataContainerPrx findGroup(String groupName, IDataContainerPrx parent) throws Error {
            IDataItemPrx group = new ItemQuery.ItemQueryBuilder().setType("Group").setName(groupName).setParent(parent).build().findFirst();
            return (IDataContainerPrx)group;
        }

        public static void selectItem(IDataItemPrx item) throws Error {
            Utils.getImarisApp().SetSurpassSelection(item);
        }
    }

    public static class Samples {
        private static final String SAMPLE_IMAGE_URL = "https://zenodo.org/record/4449687/files/HeLa_H2BmCherry_GFPtubulin_Mitotracker.ims";
        private static final String DEMO_IMAGES_FOLDER = "Imaris Demo Images";

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static File getSampleFile() {
            URI sampleUri = URI.create(SAMPLE_IMAGE_URL);
            String destName = new File(sampleUri.getPath()).getName();
            File samples_directory = new File(IJ.getDirectory("imagej"), "samples");
            samples_directory.mkdirs();
            Path destPath = new File(samples_directory, destName).toPath();
            if (destPath.toFile().exists()) {
                log.info("Sample file " + destPath.toFile().getAbsolutePath() + " exists, no need to download");
                return destPath.toFile();
            }
            log.info("Sample file " + destPath.toFile().getAbsolutePath() + " does not exist, downloading...");
            log.info("From: " + sampleUri);
            try (InputStream in = sampleUri.toURL().openStream();){
                java.nio.file.Files.copy(in, destPath, StandardCopyOption.REPLACE_EXISTING);
                log.info("Download complete, returning path to " + destPath.toFile().getName());
                File file = destPath.toFile();
                return file;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error downloading " + destPath.toFile().getName(), e);
                return null;
            }
        }

        public static File getImarisDemoFile(String imageName) throws Error {
            File userFolder = new File(System.getProperty("user.home"));
            File demoImageFolder = new File(userFolder, DEMO_IMAGES_FOLDER);
            if (!demoImageFolder.exists()) {
                log.log(Level.SEVERE, "No Imaris Demo Folder at '" + demoImageFolder.getAbsolutePath() + "'");
                throw new Error("Demo File Open Error", "No Imaris Demo Folder at '" + demoImageFolder.getAbsolutePath() + "'", "getImarisDemoImage");
            }
            File selectedImage = new File(demoImageFolder, imageName);
            if (!selectedImage.exists()) {
                log.log(Level.SEVERE, "No Demo file named '" + selectedImage.getName() + "'");
                throw new Error("Demo File Open Error", "No Demo file named '" + selectedImage.getName() + "'", "getImarisDemoImage");
            }
            return selectedImage;
        }

        public static List<String> listAllImarisDemoImages() throws Error {
            File userFolder = new File(System.getProperty("user.home"));
            File demoImageFolder = new File(userFolder, DEMO_IMAGES_FOLDER);
            if (!demoImageFolder.exists()) {
                log.log(Level.SEVERE, "No Imaris Demo Folder at '" + demoImageFolder.getAbsolutePath() + "'");
                throw new Error("Demo File Open Error", "No Imaris Demo Folder at '" + demoImageFolder.getAbsolutePath() + "'", "getImarisDemoImage");
            }
            return Arrays.stream(demoImageFolder.list()).filter(f -> f.endsWith(".ims")).collect(Collectors.toList());
        }
    }

    public static class Files {
        public static void openImage(File filepath) throws Error {
            Files.openImage(filepath, "");
        }

        public static void openImage(File filepath, String options) throws Error {
            if (!filepath.exists()) {
                log.severe(filepath + "doesn't exist");
                throw new Error();
            }
            if (!filepath.isFile()) {
                log.severe(filepath + "is not a file");
                throw new Error();
            }
            if (!filepath.getName().endsWith("ims")) {
                log.severe(filepath + "is not an imaris file, please convert your image first");
                throw new Error();
            }
            Scene.reset();
            Utils.getImarisApp().FileOpen(filepath.getAbsolutePath(), options);
        }

        public static void saveImage(File filepath) throws Error {
            Files.saveImage(filepath, "");
        }

        public static void saveImage(File filepath, String options) throws Error {
            if (!filepath.getName().endsWith("ims")) {
                filepath = new File(filepath.getAbsoluteFile() + ".ims");
                log.info("Saved as : " + filepath.getAbsoluteFile());
            }
            Utils.getImarisApp().FileSave(filepath.getAbsolutePath(), options);
        }

        public static String getOpenFileName() throws Error {
            return Files.getOpenFile().getName();
        }

        public static File getOpenFile() throws Error {
            return new File(Utils.getImarisApp().GetCurrentFileName());
        }
    }
}

