/*
 * Decompiled with CFR 0.152.
 */
package org.orangepalantir.leastsquares.fitters;

import Jama.LUDecomposition;
import Jama.Matrix;
import org.orangepalantir.leastsquares.Fitter;
import org.orangepalantir.leastsquares.Function;

public class NonLinearSolver
implements Fitter {
    double[][] X;
    double[] A;
    double[] Z;
    Function FUNCTION;
    double[] ERROR;
    double[][] DERIVATIVES;
    double DELTA = 1.0E-6;
    double MIN_ERROR = 1.0E-6;
    double MIN_CHANGE = 1.0E-6;
    double STEP = 0.1;
    double MAX_ITERATIONS = 10000.0;

    public NonLinearSolver(Function funct) {
        this.FUNCTION = funct;
    }

    @Override
    public void setData(double[][] xvalues, double[] zvalues) {
        if (xvalues.length != zvalues.length) {
            throw new IllegalArgumentException("there must be 1 z value for each set of x values");
        }
        if (xvalues[0].length != this.FUNCTION.getNInputs()) {
            throw new IllegalArgumentException("The length of parameters is longer that the parameters accepted by the function");
        }
        this.X = xvalues;
        this.Z = zvalues;
    }

    @Override
    public void setParameters(double[] parameters) {
        if (parameters.length != this.FUNCTION.getNParameters()) {
            throw new IllegalArgumentException("the number of parameters must equal the required number for the function: " + this.FUNCTION.getNParameters());
        }
        this.A = new double[parameters.length];
        System.arraycopy(parameters, 0, this.A, 0, parameters.length);
    }

    @Override
    public double calculateErrors() {
        double new_error = 0.0;
        for (int i = 0; i < this.Z.length; ++i) {
            double v = this.FUNCTION.evaluate(this.X[i], this.A);
            this.ERROR[i] = this.Z[i] - v;
            new_error += Math.pow(this.ERROR[i], 2.0);
        }
        return new_error;
    }

    public void calculateDerivatives() {
        double[] abefore = new double[this.A.length];
        double[] aafter = new double[this.A.length];
        System.arraycopy(this.A, 0, abefore, 0, this.A.length);
        System.arraycopy(this.A, 0, aafter, 0, this.A.length);
        for (int j = 0; j < this.A.length; ++j) {
            int n = j;
            aafter[n] = aafter[n] + this.DELTA;
            int n2 = j;
            abefore[n2] = abefore[n2] - this.DELTA;
            if (j > 0) {
                aafter[j - 1] = this.A[j - 1];
                abefore[j - 1] = this.A[j - 1];
            }
            for (int i = 0; i < this.Z.length; ++i) {
                this.DERIVATIVES[i][j] = (this.FUNCTION.evaluate(this.X[i], aafter) - this.FUNCTION.evaluate(this.X[i], abefore)) / (2.0 * this.DELTA);
            }
        }
    }

    public double iterateValues() {
        double[][] matrix = new double[this.A.length][this.A.length];
        double[] right = new double[this.A.length];
        for (int i = 0; i < this.A.length; ++i) {
            for (int k = 0; k < this.Z.length; ++k) {
                int n = i;
                right[n] = right[n] + this.ERROR[k] * this.DERIVATIVES[k][i];
                for (int l = 0; l < this.A.length; ++l) {
                    double[] dArray = matrix[i];
                    int n2 = l;
                    dArray[n2] = dArray[n2] + this.DERIVATIVES[k][i] * this.DERIVATIVES[k][l];
                }
            }
        }
        Matrix coeff = new Matrix(matrix);
        Matrix sols = new Matrix(right, this.A.length);
        LUDecomposition adecom = coeff.lu();
        Matrix out = adecom.solve(sols);
        double[][] values = out.getArray();
        double max_change = Math.abs(values[0][0]);
        for (int i = 0; i < this.A.length; ++i) {
            max_change = max_change > Math.abs(values[i][0]) ? max_change : Math.abs(values[i][0]);
            int n = i;
            this.A[n] = this.A[n] + values[i][0] * this.STEP;
        }
        return max_change;
    }

    public void iterateValuesB() {
        Matrix system = new Matrix(this.DERIVATIVES);
        Matrix params = new Matrix(this.ERROR, this.ERROR.length);
        Matrix out = system.solve(params);
        double[][] values = out.getArray();
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + values[i][0] * 0.001;
        }
    }

    public void initializeWorkspace() {
        this.ERROR = new double[this.Z.length];
        this.DERIVATIVES = new double[this.Z.length][this.A.length];
    }

    @Override
    public void fitData() {
        double e;
        this.initializeWorkspace();
        double changes = 0.0;
        double last_error = Double.MAX_VALUE;
        int i = 0;
        while ((double)i < this.MAX_ITERATIONS && !((e = this.calculateErrors()) < this.MIN_ERROR)) {
            if (e > last_error) {
                System.err.println("Error increased: consider smaller step size.");
                break;
            }
            last_error = e;
            this.calculateDerivatives();
            try {
                changes = this.iterateValues();
                if (changes < this.MIN_CHANGE) {
                    break;
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
            ++i;
        }
        if ((double)i == this.MAX_ITERATIONS) {
            System.err.println("Warning: Maximum iteration reached.");
        }
    }

    @Override
    public double[] getParameters() {
        return this.A;
    }

    @Override
    public double[] getUncertainty() {
        return new double[0];
    }

    public void setStepSize(double step) {
        this.STEP = step;
    }

    public void setMinError(double error) {
        this.MIN_ERROR = error;
    }

    public void setMinChange(double change) {
        this.MIN_CHANGE = change;
    }
}

